/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.xml.merge.advanced;

import java.util.Map;
import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.InheritancePolicy;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.sequencing.NativeSequence;
import org.eclipse.persistence.sequencing.Sequence;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.xml.merge.advanced.Employee;
import org.eclipse.persistence.testing.models.jpa.xml.merge.advanced.Project;

public class EntityMappingsMergeAdvancedJUnitTestCase
extends JUnitTestCase {
    static String packageName = "org.eclipse.persistence.testing.models.jpa.xml.merge.advanced.";
    static String packageToCompareName = "org.eclipse.persistence.testing.models.jpa.advanced.";
    static String[] classNames = new String[]{"Address", "Employee", "EmploymentPeriod", "LargeProject", "PhoneNumber", "Project", "SmallProject"};

    public EntityMappingsMergeAdvancedJUnitTestCase() {
    }

    public EntityMappingsMergeAdvancedJUnitTestCase(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(EntityMappingsMergeAdvancedJUnitTestCase.class, "Advanced Model");
    }

    public void testInheritanceDiscriminatorFieldValue() {
        String largeProjectIndicator;
        String smallProjectIndicator;
        Map classNameIndicators;
        String projectIndicator;
        String classIndicatorFieldTableName;
        Class classIndicatorFieldType;
        InheritancePolicy projectInheritancePolicy = EntityMappingsMergeAdvancedJUnitTestCase.getServerSession().getDescriptor(Project.class).getInheritancePolicy();
        DatabaseField classIndicatorField = projectInheritancePolicy.getClassIndicatorField();
        String classIndicatorFieldName = classIndicatorField.getName();
        if (!classIndicatorFieldName.equals("XML_MERGE_PROJ_TYPE")) {
            EntityMappingsMergeAdvancedJUnitTestCase.fail((String)("Wrong classIndicatorField name '" + classIndicatorFieldName + "'"));
        }
        if (!(classIndicatorFieldType = classIndicatorField.getType()).equals(String.class)) {
            EntityMappingsMergeAdvancedJUnitTestCase.fail((String)("Wrong classIndicatorField type '" + classIndicatorFieldType.getName() + "'"));
        }
        if (!(classIndicatorFieldTableName = classIndicatorField.getTableName()).equals("CMP3_XML_MERGE_PROJECT")) {
            EntityMappingsMergeAdvancedJUnitTestCase.fail((String)("Wrong classIndicatorField table '" + classIndicatorFieldTableName + "'"));
        }
        if (!(projectIndicator = (String)(classNameIndicators = projectInheritancePolicy.getClassNameIndicatorMapping()).get(packageName + "Project")).equals("XML_MERGE_P")) {
            EntityMappingsMergeAdvancedJUnitTestCase.fail((String)("Wrong classIndicatorField value for Project '" + projectIndicator + "'"));
        }
        if (!(smallProjectIndicator = (String)classNameIndicators.get(packageName + "SmallProject")).equals("XMLMergeSmallProject")) {
            EntityMappingsMergeAdvancedJUnitTestCase.fail((String)("Wrong classIndicatorField value for SmallProject '" + smallProjectIndicator + "'"));
        }
        if (!(largeProjectIndicator = (String)classNameIndicators.get(packageName + "LargeProject")).equals("XMLMergeLargeProject")) {
            EntityMappingsMergeAdvancedJUnitTestCase.fail((String)("Wrong classIndicatorField value for LargeProject '" + largeProjectIndicator + "'"));
        }
    }

    public void testMappingsTypes() throws ClassNotFoundException {
        Map descriptors = EntityMappingsMergeAdvancedJUnitTestCase.getServerSession().getDescriptors();
        String errorMsg = "";
        for (int i = 0; i < classNames.length; ++i) {
            String classErrorMsg = "";
            String className = packageName + classNames[i];
            String classToCompareName = packageToCompareName + classNames[i];
            Class<?> cls = Class.forName(className);
            Class<?> clsToCompare = Class.forName(classToCompareName);
            ClassDescriptor desc = (ClassDescriptor)descriptors.get(cls);
            ClassDescriptor descToCompare = (ClassDescriptor)descriptors.get(clsToCompare);
            Vector mappings = desc.getMappings();
            Vector mappingsToCompare = descToCompare.getMappings();
            if (mappings.size() != mappingsToCompare.size()) {
                classErrorMsg = classErrorMsg + "Number of mappings is different; ";
                continue;
            }
            for (int j = 0; j < mappings.size(); ++j) {
                DatabaseMapping mapping = (DatabaseMapping)mappings.elementAt(j);
                String attributeName = mapping.getAttributeName();
                DatabaseMapping mappingToCompare = descToCompare.getMappingForAttributeName(attributeName);
                if (mapping.getClass().equals(mappingToCompare.getClass())) continue;
                classErrorMsg = classErrorMsg + "attribute " + attributeName + " - mappings of different types; ";
            }
            if (classErrorMsg.length() <= 0) continue;
            errorMsg = errorMsg + "class " + classNames[i] + ": " + classErrorMsg;
        }
        if (errorMsg.length() > 0) {
            EntityMappingsMergeAdvancedJUnitTestCase.fail((String)errorMsg);
        }
    }

    public void testIgnoredTransientAnnotation() {
        Map descriptors = EntityMappingsMergeAdvancedJUnitTestCase.getServerSession().getDescriptors();
        ClassDescriptor descriptor = (ClassDescriptor)descriptors.get(Employee.class);
        DatabaseMapping mapping = descriptor.getMappingForAttributeName("lastName");
        EntityMappingsMergeAdvancedJUnitTestCase.assertTrue((String)"No mapping for attribute that was set as @Transient, in a metadata complete entity.", (mapping != null ? 1 : 0) != 0);
        EntityMappingsMergeAdvancedJUnitTestCase.assertTrue((String)"Incorrect mapping for attribute that was set as @Transient, in a metadata complete entity.", (boolean)mapping.isDirectToFieldMapping());
    }

    public void testSequenceGenerator() {
        Sequence sequence = EntityMappingsMergeAdvancedJUnitTestCase.getServerSession().getLogin().getSequence("ANN_MERGE_ADDRESS_SEQ");
        EntityMappingsMergeAdvancedJUnitTestCase.assertTrue((String)"ANN_MERGE_ADDRESS_SEQ sequence incorrect.", (boolean)(sequence instanceof NativeSequence));
        EntityMappingsMergeAdvancedJUnitTestCase.assertTrue((String)"ANN_MERGE_ADDRESS_SEQ incorrect allocation size.", (sequence.getPreallocationSize() == 1 ? 1 : 0) != 0);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)EntityMappingsMergeAdvancedJUnitTestCase.suite());
    }
}

