/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.framework;

import java.util.List;
import java.util.Vector;
import org.eclipse.persistence.queries.CursoredStream;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;

public class ReadAllTest
extends AutoVerifyTestCase {
    protected Vector arguments;
    protected ReadAllQuery query;
    protected int originalObjectsSize;
    protected Object objectsFromDatabase;
    protected Class referenceClass;

    public ReadAllTest(Class referenceClass, int originalObjectsSize) {
        this.setOriginalObjectsSize(originalObjectsSize);
        this.setReferenceClass(referenceClass);
        this.setName("ReadAllTest(" + referenceClass.getName() + ")");
        this.setDescription("The test reads the intended objects from the database and checks if it was read properly.");
    }

    public Vector getArguments() {
        if (this.arguments == null) {
            this.arguments = new Vector();
        }
        return this.arguments;
    }

    public int getOriginalObjectsSize() {
        return this.originalObjectsSize;
    }

    public ReadAllQuery getQuery() {
        return this.query;
    }

    public Class getReferenceClass() {
        return this.referenceClass;
    }

    public boolean hasArguments() {
        return this.arguments != null && this.arguments.size() > 0;
    }

    public void setArguments(Vector arguments) {
        this.arguments = arguments;
    }

    public void setOriginalObjectsSize(int size) {
        this.originalObjectsSize = size;
    }

    public void setQuery(ReadAllQuery query) {
        this.query = query;
    }

    public void setReferenceClass(Class aClass) {
        this.referenceClass = aClass;
    }

    @Override
    protected void setup() {
        if (this.getQuery() == null) {
            this.setQuery(new ReadAllQuery());
            this.getQuery().setReferenceClass(this.getReferenceClass());
        }
    }

    @Override
    protected void test() {
        if (this.getQuery().getContainerPolicy().isCursorPolicy()) {
            this.objectsFromDatabase = new Vector();
            CursoredStream stream = null;
            stream = this.hasArguments() ? (CursoredStream)this.getSession().executeQuery((DatabaseQuery)this.getQuery(), (List)this.getArguments()) : (CursoredStream)this.getSession().executeQuery((DatabaseQuery)this.getQuery());
            while (!stream.atEnd()) {
                ((Vector)this.objectsFromDatabase).addElement(stream.read());
            }
        } else {
            this.objectsFromDatabase = this.hasArguments() ? this.getSession().executeQuery((DatabaseQuery)this.getQuery(), (List)this.getArguments()) : this.getSession().executeQuery((DatabaseQuery)this.getQuery());
        }
    }

    @Override
    protected void verify() throws Exception {
        if (this.getQuery().getContainerPolicy().isCursorPolicy()) {
            if (this.getOriginalObjectsSize() != ((Vector)this.objectsFromDatabase).size()) {
                throw new TestErrorException(((Vector)this.objectsFromDatabase).size() + " objects were read from the database, but originially there were, " + this.getOriginalObjectsSize() + ".");
            }
        } else if (this.getOriginalObjectsSize() != this.getQuery().getContainerPolicy().sizeFor(this.objectsFromDatabase)) {
            throw new TestErrorException(this.getQuery().getContainerPolicy().sizeFor(this.objectsFromDatabase) + " objects were read from the database, but originially there were, " + this.getOriginalObjectsSize() + ".");
        }
    }

    @Override
    public void reset() throws Exception {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }
}

