/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.uitools;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.eclipse.persistence.tools.workbench.framework.context.ApplicationContext;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ListModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ObjectListSelectionModel;
import org.eclipse.persistence.tools.workbench.uitools.cell.DisplayableListCellRenderer;

public final class DualListSelectorPanel
extends AbstractPanel {
    ListValueModel availableLVM;
    private ListModel availableLM;
    private ObjectListSelectionModel availableLSM;
    ListValueModel selectedLVM;
    private ListModel selectedLM;
    private ObjectListSelectionModel selectedLSM;
    private Adapter adapter;
    private ListCellRenderer listCellRenderer;
    private String availableListBoxLabelKey;
    private String selectedListBoxLabelKey;
    private String selectButtonToolTipKey;
    private String deselectButtonToolTipKey;
    private Action selectAction;
    private Action deselectAction;

    DualListSelectorPanel(Builder builder) {
        super(builder.getContext());
        this.availableLVM = builder.getAvailableLVM();
        if (this.availableLVM == null) {
            throw new NullPointerException();
        }
        this.availableLM = new ListModelAdapter(this.availableLVM);
        this.availableLSM = new ObjectListSelectionModel(this.availableLM);
        this.selectedLVM = builder.getSelectedLVM();
        if (this.selectedLVM == null) {
            throw new NullPointerException();
        }
        this.selectedLM = new ListModelAdapter(this.selectedLVM);
        this.selectedLSM = new ObjectListSelectionModel(this.selectedLM);
        this.adapter = builder.getAdapter();
        if (this.adapter == null) {
            this.adapter = new DefaultAdapter();
        }
        this.listCellRenderer = builder.getListCellRenderer();
        if (this.listCellRenderer == null) {
            this.listCellRenderer = new DisplayableListCellRenderer();
        }
        this.availableListBoxLabelKey = builder.getAvailableListBoxLabelKey();
        if (this.availableListBoxLabelKey == null) {
            this.availableListBoxLabelKey = "AVAILABLE_ITEMS_LIST_BOX_LABEL";
        }
        this.selectedListBoxLabelKey = builder.getSelectedListBoxLabelKey();
        if (this.selectedListBoxLabelKey == null) {
            this.selectedListBoxLabelKey = "SELECTED_ITEMS_LIST_LABEL";
        }
        this.selectButtonToolTipKey = builder.getSelectButtonToolTipKey();
        if (this.selectButtonToolTipKey == null) {
            this.selectButtonToolTipKey = "ADD_SELECTED_ITEMS_BUTTON.toolTipText";
        }
        this.deselectButtonToolTipKey = builder.getDeselectButtonToolTipKey();
        if (this.deselectButtonToolTipKey == null) {
            this.deselectButtonToolTipKey = "REMOVE_SELECTED_ITEMS_BUTTON.toolTipText";
        }
        this.addHelpTopicId(this, builder.getHelpTopicID());
        this.selectAction = this.buildSelectAction();
        this.deselectAction = this.buildDeselectAction();
        this.initializeLayout();
    }

    private Action buildSelectAction() {
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DualListSelectorPanel.this.selectItems();
            }
        };
        action.setEnabled(false);
        return action;
    }

    private Action buildDeselectAction() {
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DualListSelectorPanel.this.deselectItems();
            }
        };
        action.setEnabled(false);
        return action;
    }

    private void initializeLayout() {
        GridBagConstraints constraints = new GridBagConstraints();
        JLabel availableLabel = new JLabel(this.resourceRepository().getString(this.availableListBoxLabelKey));
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)availableLabel, constraints);
        Component availableListBox = this.buildListBox(this.availableLM, this.availableLSM, this.selectAction);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 2;
        constraints.weightx = 0.5;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.anchor = 10;
        constraints.insets = new Insets(1, 0, 0, 0);
        this.add(availableListBox, constraints);
        availableLabel.setLabelFor(availableListBox);
        JLabel selectedLabel = new JLabel(this.resourceRepository().getString(this.selectedListBoxLabelKey));
        constraints.gridx = 2;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 5, 0, 0);
        this.add((Component)selectedLabel, constraints);
        Component selectedListBox = this.buildListBox(this.selectedLM, this.selectedLSM, this.deselectAction);
        constraints.gridx = 2;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 2;
        constraints.weightx = 0.5;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.anchor = 10;
        constraints.insets = new Insets(1, 5, 0, 0);
        this.add(selectedListBox, constraints);
        selectedLabel.setLabelFor(selectedListBox);
        JButton rightArrowButton = new JButton();
        rightArrowButton.setAction(this.selectAction);
        rightArrowButton.setIcon(this.resourceRepository().getIcon("shuttle.right"));
        rightArrowButton.setToolTipText(this.resourceRepository().getString(this.selectButtonToolTipKey));
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 10;
        constraints.insets = new Insets(1, 5, 0, 0);
        this.add((Component)rightArrowButton, constraints);
        JButton leftArrowButton = new JButton();
        leftArrowButton.setAction(this.deselectAction);
        leftArrowButton.setIcon(this.resourceRepository().getIcon("shuttle.left"));
        leftArrowButton.setToolTipText(this.resourceRepository().getString(this.deselectButtonToolTipKey));
        constraints.gridx = 1;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 1.0;
        constraints.fill = 0;
        constraints.anchor = 19;
        constraints.insets = new Insets(5, 5, 5, 0);
        this.add((Component)leftArrowButton, constraints);
    }

    private Component buildListBox(ListModel lm, ListSelectionModel lsm, Action action) {
        JList listBox = SwingComponentFactory.buildList(lm);
        listBox.setSelectionModel(lsm);
        listBox.setCellRenderer(this.listCellRenderer);
        listBox.setSelectionMode(2);
        listBox.addListSelectionListener(new LocalListSelectionListener(action));
        listBox.addMouseListener(new DoubleClickActionMouseAdapter(action));
        JScrollPane scrollPane = new JScrollPane(listBox);
        scrollPane.setPreferredSize(new Dimension(200, 100));
        scrollPane.setMinimumSize(new Dimension(200, 100));
        return scrollPane;
    }

    void selectItems() {
        Object[] items = this.availableLSM.getSelectedValues();
        for (int i = 0; i < items.length; ++i) {
            this.adapter.select(items[i]);
        }
        this.selectedLSM.setSelectedValues(items);
    }

    void deselectItems() {
        Object[] items = this.selectedLSM.getSelectedValues();
        for (int i = 0; i < items.length; ++i) {
            this.adapter.deselect(items[i]);
        }
        this.availableLSM.setSelectedValues(items);
    }

    private class LocalListSelectionListener
    implements ListSelectionListener {
        private Action action;

        LocalListSelectionListener(Action action) {
            this.action = action;
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            this.action.setEnabled(((JList)e.getSource()).getSelectedIndex() != -1);
        }
    }

    private class DoubleClickActionMouseAdapter
    extends MouseAdapter {
        private Action action;

        DoubleClickActionMouseAdapter(Action action) {
            this.action = action;
        }

        @Override
        public void mouseClicked(MouseEvent event) {
            if (event.getClickCount() == 2) {
                this.action.actionPerformed(null);
            }
        }
    }

    public static class Builder {
        private ListValueModel availableLVM;
        private ListValueModel selectedLVM;
        private Adapter adapter;
        private ListCellRenderer listCellRenderer;
        private ApplicationContext context;
        private String availableListBoxLabelKey;
        private String selectedListBoxLabelKey;
        private String selectButtonToolTipKey;
        private String deselectButtonToolTipKey;
        private String helpTopicID;

        public DualListSelectorPanel buildPanel() {
            return new DualListSelectorPanel(this);
        }

        public void setAvailableLVM(ListValueModel availableLVM) {
            this.availableLVM = availableLVM;
        }

        public ListValueModel getAvailableLVM() {
            return this.availableLVM;
        }

        public void setSelectedLVM(ListValueModel selectedLVM) {
            this.selectedLVM = selectedLVM;
        }

        public ListValueModel getSelectedLVM() {
            return this.selectedLVM;
        }

        public void setAdapter(Adapter adapter) {
            this.adapter = adapter;
        }

        public Adapter getAdapter() {
            return this.adapter;
        }

        public void setListCellRenderer(ListCellRenderer listCellRenderer) {
            this.listCellRenderer = listCellRenderer;
        }

        public ListCellRenderer getListCellRenderer() {
            return this.listCellRenderer;
        }

        public void setContext(ApplicationContext context) {
            this.context = context;
        }

        public ApplicationContext getContext() {
            return this.context;
        }

        public void setAvailableListBoxLabelKey(String availableListBoxLabelKey) {
            this.availableListBoxLabelKey = availableListBoxLabelKey;
        }

        public String getAvailableListBoxLabelKey() {
            return this.availableListBoxLabelKey;
        }

        public void setSelectedListBoxLabelKey(String selectedListBoxLabelKey) {
            this.selectedListBoxLabelKey = selectedListBoxLabelKey;
        }

        public String getSelectedListBoxLabelKey() {
            return this.selectedListBoxLabelKey;
        }

        public void setSelectButtonToolTipKey(String selectButtonToolTipKey) {
            this.selectButtonToolTipKey = selectButtonToolTipKey;
        }

        public String getSelectButtonToolTipKey() {
            return this.selectButtonToolTipKey;
        }

        public void setDeselectButtonToolTipKey(String deselectButtonToolTipKey) {
            this.deselectButtonToolTipKey = deselectButtonToolTipKey;
        }

        public String getDeselectButtonToolTipKey() {
            return this.deselectButtonToolTipKey;
        }

        public void setHelpTopicID(String helpTopicID) {
            this.helpTopicID = helpTopicID;
        }

        public String getHelpTopicID() {
            return this.helpTopicID;
        }
    }

    private class DefaultAdapter
    implements Adapter {
        private DefaultAdapter() {
        }

        @Override
        public void select(Object item) {
            this.remove(DualListSelectorPanel.this.availableLVM, item);
            this.add(DualListSelectorPanel.this.selectedLVM, item);
        }

        @Override
        public void deselect(Object item) {
            this.remove(DualListSelectorPanel.this.selectedLVM, item);
            this.add(DualListSelectorPanel.this.availableLVM, item);
        }

        private void remove(ListValueModel lvm, Object item) {
            int size = lvm.size();
            for (int i = 0; i < size; ++i) {
                if (lvm.getItem(i) != item) continue;
                lvm.removeItem(i);
                return;
            }
        }

        private void add(ListValueModel lvm, Object item) {
            lvm.addItem(lvm.size(), item);
        }
    }

    public static interface Adapter {
        public void select(Object var1);

        public void deselect(Object var1);
    }
}

