/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.DefaultListChooser;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.DefaultListChooserDialog;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassAttribute;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWMethod;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.cell.MethodCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.uitools.ComponentEnabler;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.TransformationPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.cell.AdaptableListCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.chooser.ListChooser;
import org.eclipse.persistence.tools.workbench.uitools.swing.CachingComboBoxModel;
import org.eclipse.persistence.tools.workbench.uitools.swing.ExtendedComboBoxModel;
import org.eclipse.persistence.tools.workbench.uitools.swing.IndirectComboBoxModel;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.string.StringConverter;

final class ClassAttributeAccessorsPanel
extends AbstractPanel {
    private ValueModel attributeHolder;
    private PropertyValueModel attributeTypeHolder;
    private PropertyValueModel attributeValueTypeHolder;
    private PropertyValueModel attributeTypeDimensionalityHolder;
    private JLabel getMethodLabel;
    private JLabel setMethodLabel;
    private JButton generateGetSetMethodsButton;
    private JPanel valueGetSetMethodsPanel;
    private JLabel valueGetMethodLabel;
    private JLabel valueSetMethodLabel;
    private JButton generateValueGetSetMethodsButton;
    private JPanel addRemoveMethodsPanel;
    private JLabel addMethodLabel;
    private JLabel removeMethodLabel;
    private JButton generateAddRemoveMethodsButton;
    private ListCellRenderer methodListCellRenderer;

    protected ClassAttributeAccessorsPanel(ValueModel attributeHolder, WorkbenchContextHolder contextHolder) {
        super(contextHolder);
        this.attributeHolder = attributeHolder;
        PropertyChangeListener attributeTypeDeclarationListener = this.buildAttributeTypeDeclarationListener();
        this.attributeTypeHolder = this.buildAttributeTypeAdapter();
        this.attributeTypeHolder.addPropertyChangeListener("value", attributeTypeDeclarationListener);
        this.attributeTypeDimensionalityHolder = this.buildAttributeDimensionalityAdapter();
        this.attributeTypeDimensionalityHolder.addPropertyChangeListener("value", attributeTypeDeclarationListener);
        this.attributeValueTypeHolder = this.buildAttributeValueTypeAdapter();
        this.attributeValueTypeHolder.addPropertyChangeListener("value", this.buildAttributeValueTypeListener());
        this.initializeLayout();
    }

    private PropertyChangeListener buildAttributeTypeDeclarationListener() {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ClassAttributeAccessorsPanel.this.updateGetAndSetMethodLabels();
                ClassAttributeAccessorsPanel.this.updateAccessorPanelVisibility();
            }
        };
    }

    private PropertyValueModel buildAttributeTypeAdapter() {
        return new PropertyAspectAdapter(this.attributeHolder, "type"){

            @Override
            protected Object getValueFromSubject() {
                return ((MWClassAttribute)this.subject).getType();
            }
        };
    }

    private PropertyValueModel buildAttributeDimensionalityAdapter() {
        return new PropertyAspectAdapter(this.attributeHolder, "dimensionality"){

            @Override
            protected Object getValueFromSubject() {
                return new Integer(((MWClassAttribute)this.subject).getDimensionality());
            }
        };
    }

    private PropertyValueModel buildAttributeValueTypeAdapter() {
        return new PropertyAspectAdapter(this.attributeHolder, "valueType"){

            @Override
            protected Object getValueFromSubject() {
                return ((MWClassAttribute)this.subject).getValueType();
            }
        };
    }

    private PropertyChangeListener buildAttributeValueTypeListener() {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ClassAttributeAccessorsPanel.this.updateAccessorPanelVisibility();
            }
        };
    }

    private void initializeLayout() {
        this.setBorder(BorderFactory.createEmptyBorder());
        GridBagConstraints constraints = new GridBagConstraints();
        ArrayList<JComponent> components = new ArrayList<JComponent>();
        JPanel getSetMethodsPanel = new JPanel(new GridBagLayout());
        getSetMethodsPanel.setBorder(BorderFactory.createTitledBorder((String)null));
        this.getMethodLabel = SwingComponentFactory.buildLabel("GET_METHOD_LABEL", this.resourceRepository());
        components.add(this.getMethodLabel);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(5, 5, 0, 0);
        getSetMethodsPanel.add((Component)this.getMethodLabel, constraints);
        ListChooser getMethodChooser = this.buildGetMethodListChooser();
        components.add(getMethodChooser);
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(5, 5, 0, 5);
        getSetMethodsPanel.add((Component)getMethodChooser, constraints);
        this.setMethodLabel = SwingComponentFactory.buildLabel("SET_METHOD_LABEL", this.resourceRepository());
        components.add(this.setMethodLabel);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(5, 5, 0, 0);
        getSetMethodsPanel.add((Component)this.setMethodLabel, constraints);
        ListChooser setMethodChooser = this.buildSetMethodListChooser();
        components.add(setMethodChooser);
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(5, 5, 0, 5);
        getSetMethodsPanel.add((Component)setMethodChooser, constraints);
        this.generateGetSetMethodsButton = SwingComponentFactory.buildButton("GENERATE_METHODS_BUTTON_TEXT", this.resourceRepository());
        this.generateGetSetMethodsButton.addActionListener(this.buildGenerateGetSetMethodsActionListener());
        components.add(this.generateGetSetMethodsButton);
        constraints.gridx = 2;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 22;
        constraints.insets = new Insets(10, 5, 5, 5);
        getSetMethodsPanel.add((Component)this.generateGetSetMethodsButton, constraints);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 1;
        constraints.anchor = 19;
        constraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)getSetMethodsPanel, constraints);
        this.valueGetSetMethodsPanel = new JPanel(new GridBagLayout());
        this.valueGetSetMethodsPanel.setBorder(BorderFactory.createTitledBorder((String)null));
        this.valueGetMethodLabel = SwingComponentFactory.buildLabel("VALUE_GET_METHOD_LABEL", this.resourceRepository());
        components.add(this.valueGetMethodLabel);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(5, 5, 0, 0);
        this.valueGetSetMethodsPanel.add((Component)this.valueGetMethodLabel, constraints);
        ListChooser valueGetMethodChooser = this.buildValueGetMethodListChooser();
        components.add(valueGetMethodChooser);
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(5, 5, 0, 5);
        this.valueGetSetMethodsPanel.add((Component)valueGetMethodChooser, constraints);
        this.valueSetMethodLabel = SwingComponentFactory.buildLabel("VALUE_SET_METHOD_LABEL", this.resourceRepository());
        components.add(this.valueSetMethodLabel);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(5, 5, 5, 5);
        this.valueGetSetMethodsPanel.add((Component)this.valueSetMethodLabel, constraints);
        ListChooser valueSetMethodChooser = this.buildValueSetMethodListChooser();
        components.add(valueSetMethodChooser);
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(5, 5, 0, 5);
        this.valueGetSetMethodsPanel.add((Component)valueSetMethodChooser, constraints);
        this.generateValueGetSetMethodsButton = SwingComponentFactory.buildButton("GENERATE_METHODS_BUTTON_TEXT", this.resourceRepository());
        this.generateValueGetSetMethodsButton.addActionListener(this.buildGenerateValueGetSetMethodsActionListener());
        components.add(this.generateValueGetSetMethodsButton);
        constraints.gridx = 2;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 22;
        constraints.insets = new Insets(10, 5, 5, 5);
        this.valueGetSetMethodsPanel.add((Component)this.generateValueGetSetMethodsButton, constraints);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 1;
        constraints.anchor = 19;
        constraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.valueGetSetMethodsPanel, constraints);
        this.setPanelVisible(this.valueGetSetMethodsPanel, false);
        this.addRemoveMethodsPanel = new JPanel(new GridBagLayout());
        this.addRemoveMethodsPanel.setBorder(BorderFactory.createTitledBorder((String)null));
        this.addMethodLabel = SwingComponentFactory.buildLabel("ADD_METHOD_LABEL", this.resourceRepository());
        components.add(this.addMethodLabel);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(5, 5, 0, 0);
        this.addRemoveMethodsPanel.add((Component)this.addMethodLabel, constraints);
        ListChooser addMethodChooser = this.buildAddMethodListChooser();
        components.add(addMethodChooser);
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(5, 5, 0, 5);
        this.addRemoveMethodsPanel.add((Component)addMethodChooser, constraints);
        this.removeMethodLabel = SwingComponentFactory.buildLabel("REMOVE_METHOD_LABEL", this.resourceRepository());
        components.add(this.removeMethodLabel);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(5, 5, 5, 0);
        this.addRemoveMethodsPanel.add((Component)this.removeMethodLabel, constraints);
        ListChooser removeMethodChooser = this.buildRemoveMethodListChooser();
        components.add(removeMethodChooser);
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(5, 5, 0, 5);
        this.addRemoveMethodsPanel.add((Component)removeMethodChooser, constraints);
        this.generateAddRemoveMethodsButton = SwingComponentFactory.buildButton("GENERATE_METHODS_BUTTON_TEXT", this.resourceRepository());
        this.generateAddRemoveMethodsButton.addActionListener(this.buildGenerateAddRemoveMethodsActionListener());
        components.add(this.generateAddRemoveMethodsButton);
        constraints.gridx = 2;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 22;
        constraints.insets = new Insets(10, 5, 5, 5);
        this.addRemoveMethodsPanel.add((Component)this.generateAddRemoveMethodsButton, constraints);
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.anchor = 19;
        constraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.addRemoveMethodsPanel, constraints);
        this.setPanelVisible(this.addRemoveMethodsPanel, false);
        new ComponentEnabler(this.buildAttributeTypeBooleanHolder(), components);
        this.addHelpTopicId(this, this.helpTopicId());
    }

    private ValueModel buildAttributeTypeBooleanHolder() {
        return new TransformationPropertyValueModel(this.attributeTypeHolder){

            @Override
            protected Object transform(Object value) {
                return value == null ? Boolean.FALSE : Boolean.TRUE;
            }
        };
    }

    private ActionListener buildGenerateGetSetMethodsActionListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClassAttributeAccessorsPanel.this.getAttribute().generateGetAndSetMethods();
            }
        };
    }

    private ActionListener buildGenerateValueGetSetMethodsActionListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClassAttributeAccessorsPanel.this.getAttribute().generateValueGetAndSetMethods();
            }
        };
    }

    private ActionListener buildGenerateAddRemoveMethodsActionListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClassAttributeAccessorsPanel.this.getAttribute().generateAddAndRemoveMethods();
            }
        };
    }

    private String helpTopicId() {
        return "descriptor.classInfo.attributes.accessors";
    }

    private ListChooser buildGetMethodListChooser() {
        DefaultListChooser listChooser = new DefaultListChooser(this.buildGetMethodComboBoxModel(), this.getWorkbenchContextHolder(), this.buildGetMethodChooserDialogBuilder());
        listChooser.setRenderer(this.getMethodListCellRenderer());
        return listChooser;
    }

    private CachingComboBoxModel buildGetMethodComboBoxModel() {
        return new ExtendedComboBoxModel(new IndirectComboBoxModel(this.buildGetMethodHolder(), this.attributeHolder){

            @Override
            protected ListIterator listValueFromSubject(Object subject) {
                return ClassAttributeAccessorsPanel.this.orderedGetMethodChoices((MWClassAttribute)subject);
            }
        });
    }

    private PropertyValueModel buildGetMethodHolder() {
        return new PropertyAspectAdapter(this.attributeHolder, "getMethod"){

            @Override
            protected Object getValueFromSubject() {
                return ((MWClassAttribute)this.subject).getGetMethod();
            }

            @Override
            protected void setValueOnSubject(Object value) {
                ((MWClassAttribute)this.subject).setGetMethod((MWMethod)value);
            }
        };
    }

    ListIterator orderedGetMethodChoices(MWClassAttribute attribute) {
        return CollectionTools.sort((Iterator)attribute.candidateGetMethods()).listIterator();
    }

    private DefaultListChooserDialog.Builder buildGetMethodChooserDialogBuilder() {
        DefaultListChooserDialog.Builder builder = new DefaultListChooserDialog.Builder();
        builder.setTitleKey("GET_METHOD_LIST_BROWSER_DIALOG.title");
        builder.setListBoxLabelKey("GET_METHOD_LIST_BROWSER_DIALOG.listLabel");
        builder.setStringConverter(this.buildMethodStringConverter());
        return builder;
    }

    private ListChooser buildSetMethodListChooser() {
        DefaultListChooser listChooser = new DefaultListChooser(this.buildSetMethodComboBoxModel(), this.getWorkbenchContextHolder(), this.buildSetMethodChooserDialogBuilder());
        listChooser.setRenderer(this.getMethodListCellRenderer());
        return listChooser;
    }

    private CachingComboBoxModel buildSetMethodComboBoxModel() {
        return new ExtendedComboBoxModel(new IndirectComboBoxModel(this.buildSetMethodHolder(), this.attributeHolder){

            @Override
            protected ListIterator listValueFromSubject(Object subject) {
                return ClassAttributeAccessorsPanel.this.orderedSetMethodChoices((MWClassAttribute)subject);
            }
        });
    }

    private PropertyValueModel buildSetMethodHolder() {
        return new PropertyAspectAdapter(this.attributeHolder, "setMethod"){

            @Override
            protected Object getValueFromSubject() {
                return ((MWClassAttribute)this.subject).getSetMethod();
            }

            @Override
            protected void setValueOnSubject(Object value) {
                ((MWClassAttribute)this.subject).setSetMethod((MWMethod)value);
            }
        };
    }

    ListIterator orderedSetMethodChoices(MWClassAttribute attribute) {
        return CollectionTools.sort((Iterator)attribute.candidateSetMethods()).listIterator();
    }

    private DefaultListChooserDialog.Builder buildSetMethodChooserDialogBuilder() {
        DefaultListChooserDialog.Builder builder = new DefaultListChooserDialog.Builder();
        builder.setTitleKey("SET_METHOD_LIST_BROWSER_DIALOG.title");
        builder.setListBoxLabelKey("SET_METHOD_LIST_BROWSER_DIALOG.listLabel");
        builder.setStringConverter(this.buildMethodStringConverter());
        return builder;
    }

    private ListChooser buildValueGetMethodListChooser() {
        DefaultListChooser listChooser = new DefaultListChooser(this.buildValueGetMethodComboBoxModel(), this.getWorkbenchContextHolder(), this.buildValueGetMethodChooserDialogBuilder());
        listChooser.setRenderer(this.getMethodListCellRenderer());
        return listChooser;
    }

    private CachingComboBoxModel buildValueGetMethodComboBoxModel() {
        return new ExtendedComboBoxModel(new IndirectComboBoxModel(this.buildValueGetMethodHolder(), this.attributeHolder){

            @Override
            protected ListIterator listValueFromSubject(Object subject) {
                return ClassAttributeAccessorsPanel.this.orderedValueGetMethodChoices((MWClassAttribute)subject);
            }
        });
    }

    private PropertyValueModel buildValueGetMethodHolder() {
        return new PropertyAspectAdapter(this.attributeHolder, "valueGetMethod"){

            @Override
            protected Object getValueFromSubject() {
                return ((MWClassAttribute)this.subject).getValueGetMethod();
            }

            @Override
            protected void setValueOnSubject(Object value) {
                ((MWClassAttribute)this.subject).setValueGetMethod((MWMethod)value);
            }
        };
    }

    ListIterator orderedValueGetMethodChoices(MWClassAttribute attribute) {
        return CollectionTools.sort((Iterator)attribute.candidateValueGetMethods()).listIterator();
    }

    private DefaultListChooserDialog.Builder buildValueGetMethodChooserDialogBuilder() {
        DefaultListChooserDialog.Builder builder = new DefaultListChooserDialog.Builder();
        builder.setTitleKey("VALUE_GET_METHOD_LIST_BROWSER_DIALOG.title");
        builder.setListBoxLabelKey("VALUE_GET_METHOD_LIST_BROWSER_DIALOG.listLabel");
        builder.setStringConverter(this.buildMethodStringConverter());
        return builder;
    }

    private ListChooser buildValueSetMethodListChooser() {
        DefaultListChooser listChooser = new DefaultListChooser(this.buildValueSetMethodComboBoxModel(), this.getWorkbenchContextHolder(), this.buildValueSetMethodChooserDialogBuilder());
        listChooser.setRenderer(this.getMethodListCellRenderer());
        return listChooser;
    }

    private CachingComboBoxModel buildValueSetMethodComboBoxModel() {
        return new ExtendedComboBoxModel(new IndirectComboBoxModel(this.buildValueSetMethodHolder(), this.attributeHolder){

            @Override
            protected ListIterator listValueFromSubject(Object subject) {
                return ClassAttributeAccessorsPanel.this.orderedValueSetMethodChoices((MWClassAttribute)subject);
            }
        });
    }

    private PropertyValueModel buildValueSetMethodHolder() {
        return new PropertyAspectAdapter(this.attributeHolder, "valueSetMethod"){

            @Override
            protected Object getValueFromSubject() {
                return ((MWClassAttribute)this.subject).getValueSetMethod();
            }

            @Override
            protected void setValueOnSubject(Object value) {
                ((MWClassAttribute)this.subject).setValueSetMethod((MWMethod)value);
            }
        };
    }

    ListIterator orderedValueSetMethodChoices(MWClassAttribute attribute) {
        return CollectionTools.sort((Iterator)attribute.candidateValueSetMethods()).listIterator();
    }

    private DefaultListChooserDialog.Builder buildValueSetMethodChooserDialogBuilder() {
        DefaultListChooserDialog.Builder builder = new DefaultListChooserDialog.Builder();
        builder.setTitleKey("VALUE_SET_METHOD_LIST_BROWSER_DIALOG.title");
        builder.setListBoxLabelKey("VALUE_SET_METHOD_LIST_BROWSER_DIALOG.listLabel");
        builder.setStringConverter(this.buildMethodStringConverter());
        return builder;
    }

    private ListChooser buildAddMethodListChooser() {
        DefaultListChooser listChooser = new DefaultListChooser(this.buildAddMethodComboBoxModel(), this.getWorkbenchContextHolder(), this.buildAddMethodChooserDialogBuilder());
        listChooser.setRenderer(this.getMethodListCellRenderer());
        return listChooser;
    }

    private CachingComboBoxModel buildAddMethodComboBoxModel() {
        return new ExtendedComboBoxModel(new IndirectComboBoxModel(this.buildAddMethodHolder(), this.attributeHolder){

            @Override
            protected ListIterator listValueFromSubject(Object subject) {
                return ClassAttributeAccessorsPanel.this.orderedAddMethodChoices((MWClassAttribute)subject);
            }
        });
    }

    private PropertyValueModel buildAddMethodHolder() {
        return new PropertyAspectAdapter(this.attributeHolder, "addMethod"){

            @Override
            protected Object getValueFromSubject() {
                return ((MWClassAttribute)this.subject).getAddMethod();
            }

            @Override
            protected void setValueOnSubject(Object value) {
                ((MWClassAttribute)this.subject).setAddMethod((MWMethod)value);
            }
        };
    }

    ListIterator orderedAddMethodChoices(MWClassAttribute attribute) {
        return CollectionTools.sort((Iterator)attribute.candidateAddMethods()).listIterator();
    }

    private DefaultListChooserDialog.Builder buildAddMethodChooserDialogBuilder() {
        DefaultListChooserDialog.Builder builder = new DefaultListChooserDialog.Builder();
        builder.setTitleKey("ADD_METHOD_LIST_BROWSER_DIALOG.title");
        builder.setListBoxLabelKey("ADD_METHOD_LIST_BROWSER_DIALOG.listLabel");
        builder.setStringConverter(this.buildMethodStringConverter());
        return builder;
    }

    private ListChooser buildRemoveMethodListChooser() {
        DefaultListChooser listChooser = new DefaultListChooser(this.buildRemoveMethodComboBoxModel(), this.getWorkbenchContextHolder(), this.buildRemoveMethodChooserDialogBuilder());
        listChooser.setRenderer(this.getMethodListCellRenderer());
        return listChooser;
    }

    private CachingComboBoxModel buildRemoveMethodComboBoxModel() {
        return new ExtendedComboBoxModel(new IndirectComboBoxModel(this.buildRemoveMethodHolder(), this.attributeHolder){

            @Override
            protected ListIterator listValueFromSubject(Object subject) {
                return ClassAttributeAccessorsPanel.this.orderedRemoveMethodChoices((MWClassAttribute)subject);
            }
        });
    }

    private PropertyValueModel buildRemoveMethodHolder() {
        return new PropertyAspectAdapter(this.attributeHolder, "removeMethod"){

            @Override
            protected Object getValueFromSubject() {
                return ((MWClassAttribute)this.subject).getRemoveMethod();
            }

            @Override
            protected void setValueOnSubject(Object value) {
                ((MWClassAttribute)this.subject).setRemoveMethod((MWMethod)value);
            }
        };
    }

    ListIterator orderedRemoveMethodChoices(MWClassAttribute attribute) {
        return CollectionTools.sort((Iterator)attribute.candidateRemoveMethods()).listIterator();
    }

    private DefaultListChooserDialog.Builder buildRemoveMethodChooserDialogBuilder() {
        DefaultListChooserDialog.Builder builder = new DefaultListChooserDialog.Builder();
        builder.setTitleKey("REMOVE_METHOD_LIST_BROWSER_DIALOG.title");
        builder.setListBoxLabelKey("REMOVE_METHOD_LIST_BROWSER_DIALOG.listLabel");
        builder.setStringConverter(this.buildMethodStringConverter());
        return builder;
    }

    private StringConverter buildMethodStringConverter() {
        return new StringConverter(){

            public String convertToString(Object o) {
                return o == null ? "" : ((MWMethod)o).getName();
            }
        };
    }

    private ListCellRenderer getMethodListCellRenderer() {
        if (this.methodListCellRenderer == null) {
            this.methodListCellRenderer = new AdaptableListCellRenderer(new MethodCellRendererAdapter(this.resourceRepository()));
        }
        return this.methodListCellRenderer;
    }

    void updateGetAndSetMethodLabels() {
        if (this.getAttribute() != null && this.getAttribute().isValueHolder()) {
            this.getMethodLabel.setText(this.resourceRepository().getString("VALUE_HOLDER_GET_METHOD_LABEL"));
            this.setMethodLabel.setText(this.resourceRepository().getString("VALUE_HOLDER_SET_METHOD_LABEL"));
        } else {
            this.getMethodLabel.setText(this.resourceRepository().getString("GET_METHOD_LABEL"));
            this.setMethodLabel.setText(this.resourceRepository().getString("SET_METHOD_LABEL"));
        }
    }

    void updateAccessorPanelVisibility() {
        this.setPanelVisible(this.valueGetSetMethodsPanel, this.getAttribute() != null && this.getAttribute().canHaveValueGetAndSetMethods());
        this.setPanelVisible(this.addRemoveMethodsPanel, this.getAttribute() != null && this.getAttribute().canHaveAddAndRemoveMethods());
    }

    private void setPanelVisible(JPanel panel, boolean visible) {
        panel.setVisible(visible);
        this.revalidate();
        this.repaint();
    }

    MWClassAttribute getAttribute() {
        return (MWClassAttribute)this.attributeHolder.getValue();
    }
}

