/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.ui.tools;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.ClassChooserDialog;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.ClassDescriptionRepository;
import org.eclipse.persistence.tools.workbench.framework.uitools.CursorConstants;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;

public final class ClassChooserTools {
    public static JButton buildBrowseButton(WorkbenchContextHolder contextHolder, String key, ValueModel classRepositoryHolder, PropertyValueModel selectionHolder) {
        ResourceRepository repository = contextHolder.getWorkbenchContext().getApplicationContext().getResourceRepository();
        JButton browseButton = new JButton();
        browseButton.setText(repository.getString(key));
        browseButton.setMnemonic(repository.getMnemonic(key));
        browseButton.setDisplayedMnemonicIndex(repository.getMnemonicIndex(key));
        browseButton.setName(key);
        BrowseAction action = new BrowseAction(contextHolder, classRepositoryHolder, selectionHolder);
        browseButton.addActionListener(action);
        ClassChooserTools.installBrowseButtonEnabler(classRepositoryHolder, browseButton);
        return browseButton;
    }

    private static void installBrowseButtonEnabler(ValueModel classRepositoryHolder, final JButton button) {
        classRepositoryHolder.addPropertyChangeListener("value", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                button.setEnabled(e.getNewValue() != null);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void promptForType(WorkbenchContext context, ClassDescriptionRepository repository, PropertyValueModel selectionHolder) {
        try {
            context.getCurrentWindow().setCursor(CursorConstants.WAIT_CURSOR);
            PropertyChangeListener fakeListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                }
            };
            selectionHolder.addPropertyChangeListener("value", fakeListener);
            ClassChooserDialog dialog = ClassChooserDialog.createDialog(repository, context);
            dialog.setVisible(true);
            if (dialog.wasConfirmed()) {
                selectionHolder.setValue(dialog.selection());
            }
            selectionHolder.removePropertyChangeListener("value", fakeListener);
        }
        finally {
            context.getCurrentWindow().setCursor(CursorConstants.DEFAULT_CURSOR);
        }
    }

    private static class BrowseAction
    implements ActionListener {
        private final ValueModel classRepositoryHolder;
        private final WorkbenchContextHolder contextHolder;
        private final PropertyValueModel selectionHolder;

        private BrowseAction(WorkbenchContextHolder contextHolder, ValueModel classRepositoryHolder, PropertyValueModel selectionHolder) {
            this.classRepositoryHolder = classRepositoryHolder;
            this.contextHolder = contextHolder;
            this.selectionHolder = selectionHolder;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ClassChooserTools.promptForType(this.contextHolder.getWorkbenchContext(), (ClassDescriptionRepository)this.classRepositoryHolder.getValue(), this.selectionHolder);
        }
    }
}

