/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor;

import java.util.Calendar;
import java.util.Date;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.invalidation.CacheInvalidationPolicy;
import org.eclipse.persistence.descriptors.invalidation.DailyCacheInvalidationPolicy;
import org.eclipse.persistence.descriptors.invalidation.NoExpiryCacheInvalidationPolicy;
import org.eclipse.persistence.descriptors.invalidation.TimeToLiveCacheInvalidationPolicy;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.converters.ObjectTypeConverter;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWCacheExpiry;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWCachingPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWMappingDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWTransactionalPolicy;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWDescriptorCacheExpiry
extends MWModel
implements MWCacheExpiry {
    private volatile String expiryType;
    private volatile boolean updateReadTimeOnUpdate;
    private volatile Long timeToLiveExpiry;
    private volatile Date dailyExpiryTime;

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(MWDescriptorCacheExpiry.class);
        ObjectTypeConverter cacheExpiryMappingConverter = new ObjectTypeConverter();
        cacheExpiryMappingConverter.addConversionValue((Object)"No Expiry", (Object)"No Expiry");
        cacheExpiryMappingConverter.addConversionValue((Object)"Time to Live Expiry", (Object)"Time to Live Expiry");
        cacheExpiryMappingConverter.addConversionValue((Object)"Daily Expiry", (Object)"Daily Expiry");
        XMLDirectMapping cacheExpiryMapping = new XMLDirectMapping();
        cacheExpiryMapping.setAttributeName("expiryType");
        cacheExpiryMapping.setNullValue((Object)"No Expiry");
        cacheExpiryMapping.setXPath("expiry-type/text()");
        cacheExpiryMapping.setConverter((Converter)cacheExpiryMappingConverter);
        descriptor.addMapping((DatabaseMapping)cacheExpiryMapping);
        XMLDirectMapping timeToLiveExpiryMapping = (XMLDirectMapping)descriptor.addDirectMapping("timeToLiveExpiry", "time-to-live-expiry/text()");
        timeToLiveExpiryMapping.setNullValue((Object)DEFAULT_TIME_TO_LIVE_EXPIRY);
        XMLDirectMapping dailyExpireTimeMapping = (XMLDirectMapping)descriptor.addDirectMapping("dailyExpiryTime", "daily-expiry-time/text()");
        dailyExpireTimeMapping.setNullValue((Object)DEFAULT_DAILY_EXPIRY_TIME);
        XMLDirectMapping updateReadTimeOnUpdateMapping = (XMLDirectMapping)descriptor.addDirectMapping("updateReadTimeOnUpdate", "update-read-time-on-update/text()");
        updateReadTimeOnUpdateMapping.setNullValue((Object)false);
        return descriptor;
    }

    private MWDescriptorCacheExpiry() {
    }

    public MWDescriptorCacheExpiry(MWCachingPolicy parent) {
        super(parent);
    }

    @Override
    protected void initialize(Node parent) {
        super.initialize(parent);
        this.dailyExpiryTime = DEFAULT_DAILY_EXPIRY_TIME;
        this.expiryType = "No Expiry";
        this.timeToLiveExpiry = DEFAULT_TIME_TO_LIVE_EXPIRY;
        this.updateReadTimeOnUpdate = false;
    }

    @Override
    public Date getDailyExpiryTime() {
        return this.dailyExpiryTime;
    }

    @Override
    public void setDailyExpiryTime(Date dailyExpiryTime) {
        Date oldDailyExpiryTime = this.dailyExpiryTime;
        if (this.newExpiryTimeDifferent(dailyExpiryTime)) {
            this.dailyExpiryTime = dailyExpiryTime;
            this.firePropertyChanged("dailyExpiryTime", oldDailyExpiryTime, this.dailyExpiryTime);
        }
    }

    private boolean newExpiryTimeDifferent(Date newExpiryTime) {
        Date oldExpiryTime = this.getDailyExpiryTime();
        return newExpiryTime.getHours() != oldExpiryTime.getHours() || newExpiryTime.getMinutes() != oldExpiryTime.getMinutes() || newExpiryTime.getSeconds() != oldExpiryTime.getSeconds();
    }

    @Override
    public void setDailyExpiryTime(Calendar dailyExpiryTime) {
        this.setDailyExpiryTime(dailyExpiryTime.getTime());
    }

    @Override
    public String getExpiryType() {
        return this.expiryType;
    }

    @Override
    public void setExpiryType(String expiryType) {
        String oldExpiryType = this.expiryType;
        this.expiryType = expiryType;
        this.firePropertyChanged("expiryType", oldExpiryType, this.expiryType);
        if (this.valuesAreDifferent(oldExpiryType, this.expiryType) && this.expiryType == "No Expiry") {
            this.setUpdateReadTimeOnUpdate(false);
        }
    }

    @Override
    public boolean getUpdateReadTimeOnUpdate() {
        return this.updateReadTimeOnUpdate;
    }

    @Override
    public void setUpdateReadTimeOnUpdate(boolean updateReadTimeOnUpdate) {
        boolean oldUpdateReadTimeOnUpdate = this.updateReadTimeOnUpdate;
        this.updateReadTimeOnUpdate = updateReadTimeOnUpdate;
        this.firePropertyChanged("updateReadTimeOnUpdate", oldUpdateReadTimeOnUpdate, this.updateReadTimeOnUpdate);
    }

    @Override
    public Long getTimeToLiveExpiry() {
        return this.timeToLiveExpiry;
    }

    @Override
    public void setTimeToLiveExpiry(Long timeToLiveExpiry) {
        Long oldTimeToLive = this.timeToLiveExpiry;
        this.timeToLiveExpiry = timeToLiveExpiry;
        this.firePropertyChanged("timeToLiveExpiry", oldTimeToLive, this.timeToLiveExpiry);
    }

    public MWMappingDescriptor getOwningDescriptor() {
        return (MWMappingDescriptor)((MWTransactionalPolicy)this.getParent()).getParent();
    }

    @Override
    public void adjustRuntimeDescriptor(ClassDescriptor runtimeDescriptor) {
        if (this.getExpiryType() == "No Expiry") {
            runtimeDescriptor.setCacheInvalidationPolicy((CacheInvalidationPolicy)new NoExpiryCacheInvalidationPolicy());
        } else if (this.getExpiryType() == "Daily Expiry") {
            Date expiryTime = this.getDailyExpiryTime();
            runtimeDescriptor.setCacheInvalidationPolicy((CacheInvalidationPolicy)new DailyCacheInvalidationPolicy(expiryTime.getHours(), expiryTime.getMinutes(), expiryTime.getSeconds(), 0));
        } else if (this.getExpiryType() == "Time to Live Expiry") {
            runtimeDescriptor.setCacheInvalidationPolicy((CacheInvalidationPolicy)new TimeToLiveCacheInvalidationPolicy(this.getTimeToLiveExpiry().longValue()));
        }
    }

    @Override
    public MWCacheExpiry getPersistedPolicy() {
        return this;
    }
}

