/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.tests;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.eclipse.persistence.tools.utility.ObjectTools;
import org.eclipse.persistence.tools.utility.StringTools;
import org.eclipse.persistence.tools.utility.collection.CollectionTools;
import org.eclipse.persistence.tools.utility.filter.Filter;
import org.eclipse.persistence.tools.utility.filter.FilterAdapter;
import org.eclipse.persistence.tools.utility.io.NullOutputStream;
import org.eclipse.persistence.tools.utility.iterable.FilteringIterable;
import org.eclipse.persistence.tools.utility.iterable.TransformationIterable;
import org.eclipse.persistence.tools.utility.transformer.Transformer;
import org.eclipse.persistence.tools.utility.transformer.TransformerAdapter;

public class JDKTools {
    private static final String CR = StringTools.CR;
    private static final String FS = System.getProperty("file.separator");
    private static final String JAVA_HOME = System.getProperty("java.home");
    private static final String JAVA_CLASSPATH = System.getProperty("java.class.path");
    private static final Transformer<File, String> FILE_NAME_TRANSFORMER = new FileNameTransformer();
    private static final Filter<File> JAVA_FILE_FILTER = new JavaFileFilter();

    public static void compile(File sourceFile) throws IOException, InterruptedException {
        JDKTools.compile(sourceFile, JAVA_CLASSPATH);
    }

    public static void compile(File sourceFile, String classpath) throws IOException, InterruptedException {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(JDKTools.javaCompiler());
        if (classpath != null && classpath.length() != 0) {
            cmd.add("-classpath");
            cmd.add(classpath);
        }
        cmd.add(sourceFile.getAbsolutePath());
        JDKTools.exec(cmd.toArray(new String[cmd.size()]));
    }

    public static void compile(Iterable<File> sourceFiles) throws IOException, InterruptedException {
        JDKTools.compile(sourceFiles, JAVA_CLASSPATH);
    }

    public static void compile(Iterable<File> sourceFiles, String classpath) throws IOException, InterruptedException {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(JDKTools.javaCompiler());
        if (classpath != null && classpath.length() != 0) {
            cmd.add("-classpath");
            cmd.add(classpath);
        }
        CollectionTools.addAll(cmd, JDKTools.javaFileNames(sourceFiles));
        JDKTools.exec(cmd.toArray(new String[cmd.size()]));
    }

    private static Iterable<String> javaFileNames(Iterable<File> files) {
        return new TransformationIterable(JDKTools.filterJavaFiles(files), FILE_NAME_TRANSFORMER);
    }

    private static Iterable<File> filterJavaFiles(Iterable<File> files) {
        return new FilteringIterable(files, JAVA_FILE_FILTER);
    }

    public static void jar(File jarFile, File directory) throws IOException, InterruptedException {
        JDKTools.jar("cf", jarFile, directory);
    }

    public static void zip(File zipFile, File directory) throws IOException, InterruptedException {
        JDKTools.jar("cMf", zipFile, directory);
    }

    private static void jar(String jarOptions, File jarFile, File directory) throws IOException, InterruptedException {
        JDKTools.exec(new String[]{JDKTools.jarUtility(), jarOptions, jarFile.getAbsolutePath(), "-C", directory.getAbsolutePath(), "."});
    }

    public static void java(String className) throws IOException, InterruptedException {
        JDKTools.java(className, JAVA_CLASSPATH);
    }

    public static void java(String className, String classpath) throws IOException, InterruptedException {
        JDKTools.java(className, classpath, StringTools.EMPTY_STRING_ARRAY);
    }

    public static void java(String className, String classpath, String[] args) throws IOException, InterruptedException {
        JDKTools.java(className, classpath, StringTools.EMPTY_STRING_ARRAY, args);
    }

    public static void java(String className, String classpath, String[] javaOptions, String[] args) throws IOException, InterruptedException {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(JDKTools.javaVM());
        if (classpath != null && classpath.length() != 0) {
            cmd.add("-classpath");
            cmd.add(classpath);
        }
        CollectionTools.addAll(cmd, (Object[])javaOptions);
        cmd.add(className);
        CollectionTools.addAll(cmd, (Object[])args);
        JDKTools.exec(cmd.toArray(new String[cmd.size()]));
    }

    public static void exec(String[] cmd) throws IOException, InterruptedException {
        Process process = Runtime.getRuntime().exec(cmd);
        ByteArrayOutputStream stderrStream = new ByteArrayOutputStream(1000);
        RunnableStreamReader stderrRunnable = new RunnableStreamReader(new BufferedInputStream(process.getErrorStream()), new BufferedOutputStream(stderrStream));
        Thread stderrThread = new Thread((Runnable)stderrRunnable, "stderr stream reader");
        stderrThread.start();
        ByteArrayOutputStream stdoutStream = new ByteArrayOutputStream(1000);
        RunnableStreamReader stdoutRunnable = new RunnableStreamReader(new BufferedInputStream(process.getInputStream()), new BufferedOutputStream(stdoutStream));
        Thread stdoutThread = new Thread((Runnable)stdoutRunnable, "stdout stream reader");
        stdoutThread.start();
        stderrThread.join();
        stdoutThread.join();
        int exitValue = process.waitFor();
        stderrStream.close();
        stdoutStream.close();
        if (exitValue != 0) {
            StringBuffer sb = new StringBuffer(2000);
            sb.append(CR);
            sb.append("**** exit value: ");
            sb.append(exitValue);
            sb.append(CR);
            sb.append("**** stderr: ");
            sb.append(CR);
            sb.append(stderrStream.toString());
            sb.append(CR);
            sb.append("**** stdout: ");
            sb.append(CR);
            sb.append(stdoutStream.toString());
            throw new RuntimeException(sb.toString());
        }
    }

    public static String javaHomeDirectoryName() {
        return JAVA_HOME;
    }

    public static File javaHomeDirectory() {
        return new File(JDKTools.javaHomeDirectoryName());
    }

    public static File javaToolDirectory() {
        return new File(JDKTools.javaHomeDirectory().getParentFile(), "bin");
    }

    public static String javaToolDirectoryName() {
        return JDKTools.javaToolDirectory().getPath();
    }

    public static String javaVM() {
        return String.valueOf(JDKTools.javaToolDirectoryName()) + FS + "java";
    }

    public static String javaCompiler() {
        return String.valueOf(JDKTools.javaToolDirectoryName()) + FS + "javac";
    }

    public static String jarUtility() {
        return String.valueOf(JDKTools.javaToolDirectoryName()) + FS + "jar";
    }

    static void dump(String[] cmd) {
        int i = 0;
        while (i < cmd.length) {
            System.out.print(cmd[i]);
            if (i + 1 < cmd.length) {
                System.out.print(" ");
            }
            ++i;
        }
        System.out.println();
    }

    private JDKTools() {
        throw new UnsupportedOperationException();
    }

    static class FileNameTransformer
    extends TransformerAdapter<File, String> {
        FileNameTransformer() {
        }

        public String transform(File file) {
            return file.getAbsolutePath();
        }
    }

    static class JavaFileFilter
    extends FilterAdapter<File> {
        JavaFileFilter() {
        }

        public boolean accept(File file) {
            return file.isFile() && file.getPath().endsWith(".java");
        }
    }

    static class RunnableStreamReader
    implements Runnable {
        private InputStream inputStream;
        private OutputStream outputStream;

        RunnableStreamReader(InputStream inputStream) {
            this(inputStream, NullOutputStream.instance());
        }

        RunnableStreamReader(InputStream inputStream, OutputStream outputStream) {
            this.inputStream = inputStream;
            this.outputStream = outputStream;
        }

        @Override
        public void run() {
            try {
                int b = -1;
                while ((b = this.inputStream.read()) != -1) {
                    this.outputStream.write(b);
                }
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }

        public String toString() {
            return ObjectTools.toString((Object)this);
        }
    }
}

