/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.model.event;

import java.util.List;
import org.eclipse.persistence.tools.utility.StringBuilderTools;
import org.eclipse.persistence.tools.utility.iterable.ArrayIterable;
import org.eclipse.persistence.tools.utility.model.Model;
import org.eclipse.persistence.tools.utility.model.event.ListEvent;

public final class ListAddEvent
extends ListEvent {
    private final int index;
    private final Object[] items;
    private static final long serialVersionUID = 1L;

    public ListAddEvent(Model source, String listName, int index, Object item) {
        this(source, listName, index, new Object[]{item});
    }

    public ListAddEvent(Model source, String listName, int index, List<?> items) {
        this(source, listName, index, items.toArray());
    }

    private ListAddEvent(Model source, String listName, int index, Object[] items) {
        super(source, listName);
        this.index = index;
        this.items = items;
    }

    public int getIndex() {
        return this.index;
    }

    public Iterable<?> getItems() {
        return new ArrayIterable<Object>(this.items);
    }

    public int getItemsSize() {
        return this.items.length;
    }

    @Override
    protected void toString(StringBuilder sb) {
        super.toString(sb);
        sb.append(": ");
        StringBuilderTools.append(sb, this.items);
    }

    public ListAddEvent clone(Model newSource) {
        return this.clone(newSource, this.listName);
    }

    public ListAddEvent clone(Model newSource, String newListName) {
        return this.clone(newSource, newListName, 0);
    }

    public ListAddEvent clone(Model newSource, String newListName, int offset) {
        return new ListAddEvent(newSource, newListName, this.index + offset, this.items);
    }
}

