/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.model.value;

import org.eclipse.persistence.tools.utility.model.AbstractModel;
import org.eclipse.persistence.tools.utility.model.ChangeSupport;
import org.eclipse.persistence.tools.utility.model.SingleAspectChangeSupport;
import org.eclipse.persistence.tools.utility.model.listener.ChangeListener;
import org.eclipse.persistence.tools.utility.model.listener.ListChangeListener;

public abstract class AbstractListValueModel
extends AbstractModel {
    protected AbstractListValueModel() {
    }

    @Override
    protected ChangeSupport buildChangeSupport() {
        return new SingleAspectChangeSupport(this, ListChangeListener.class, "list values");
    }

    @Override
    public void addChangeListener(ChangeListener listener) {
        if (this.hasNoListeners()) {
            this.engageModel();
        }
        super.addChangeListener(listener);
    }

    @Override
    public void addListChangeListener(String listName, ListChangeListener listener) {
        if (listName.equals("list values") && this.hasNoListeners()) {
            this.engageModel();
        }
        super.addListChangeListener(listName, listener);
    }

    @Override
    public void removeChangeListener(ChangeListener listener) {
        super.removeChangeListener(listener);
        if (this.hasNoListeners()) {
            this.disengageModel();
        }
    }

    @Override
    public void removeListChangeListener(String listName, ListChangeListener listener) {
        super.removeListChangeListener(listName, listener);
        if (listName.equals("list values") && this.hasNoListeners()) {
            this.disengageModel();
        }
    }

    protected boolean hasNoListeners() {
        return !this.hasListeners();
    }

    protected boolean hasListeners() {
        return this.hasAnyListChangeListeners("list values");
    }

    protected abstract void engageModel();

    protected abstract void disengageModel();
}

