/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.model.value.swing;

import org.eclipse.persistence.tools.utility.filter.Filter;
import org.eclipse.persistence.tools.utility.model.value.FilteringModifiablePropertyValueModel;
import org.eclipse.persistence.tools.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.persistence.tools.utility.model.value.TransformationModifiablePropertyValueModel;
import org.eclipse.persistence.tools.utility.model.value.swing.ToggleButtonModelAdapter;
import org.eclipse.persistence.tools.utility.transformer.Transformer;

public class RadioButtonModelAdapter
extends ToggleButtonModelAdapter {
    private static final long serialVersionUID = 1L;

    public RadioButtonModelAdapter(ModifiablePropertyValueModel<Object> valueHolder, Object buttonValue, boolean defaultValue) {
        super(RadioButtonModelAdapter.buildBooleanHolder(valueHolder, buttonValue), defaultValue);
    }

    public RadioButtonModelAdapter(ModifiablePropertyValueModel<Object> valueHolder, Object buttonValue) {
        super(RadioButtonModelAdapter.buildBooleanHolder(valueHolder, buttonValue));
    }

    public static ModifiablePropertyValueModel<Boolean> buildBooleanHolder(ModifiablePropertyValueModel<Object> valueHolder, Object buttonValue) {
        FilteringModifiablePropertyValueModel<Object> filteringPVM = new FilteringModifiablePropertyValueModel<Object>(valueHolder, Filter.Transparent.instance(), new SetRadioButtonFilter(buttonValue));
        return new TransformationModifiablePropertyValueModel<Object, Boolean>(filteringPVM, new RadioButtonTransformer(buttonValue), new ReverseRadioButtonTransformer(buttonValue));
    }

    @Override
    public void setSelected(boolean b) {
        if (!b && this.isArmed()) {
            return;
        }
        super.setSelected(b);
    }

    public static class RadioButtonTransformer
    implements Transformer<Object, Boolean> {
        private Object buttonValue;

        public RadioButtonTransformer(Object buttonValue) {
            this.buttonValue = buttonValue;
        }

        @Override
        public Boolean transform(Object value) {
            return value == null ? null : Boolean.valueOf(value.equals(this.buttonValue));
        }
    }

    public static class ReverseRadioButtonTransformer
    implements Transformer<Boolean, Object> {
        private Object buttonValue;

        public ReverseRadioButtonTransformer(Object buttonValue) {
            this.buttonValue = buttonValue;
        }

        @Override
        public Object transform(Boolean value) {
            return value != false ? this.buttonValue : null;
        }
    }

    public static class SetRadioButtonFilter
    implements Filter<Object> {
        private Object buttonValue;

        public SetRadioButtonFilter(Object buttonValue) {
            this.buttonValue = buttonValue;
        }

        @Override
        public boolean accept(Object value) {
            return value != null && value.equals(this.buttonValue);
        }
    }
}

