/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.mapping.orm.dom;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.FetchType;
import org.eclipse.persistence.annotations.JoinFetchType;
import org.eclipse.persistence.tools.mapping.orm.ExternalBatchFetch;
import org.eclipse.persistence.tools.mapping.orm.ExternalJoinTable;
import org.eclipse.persistence.tools.mapping.orm.ExternalRelationshipMapping;
import org.eclipse.persistence.tools.mapping.orm.dom.BatchFetch;
import org.eclipse.persistence.tools.mapping.orm.dom.EmbeddableEntity;
import org.eclipse.persistence.tools.mapping.orm.dom.JoinTable;
import org.eclipse.persistence.tools.mapping.orm.dom.NonTransientMapping;
import org.eclipse.persistence.tools.utility.ObjectTools;
import org.eclipse.persistence.tools.utility.iterable.EmptyListIterable;
import org.eclipse.persistence.tools.utility.iterable.ListIterable;
import org.eclipse.persistence.tools.utility.iterable.ListListIterable;
import org.w3c.dom.Element;

abstract class RelationshipMapping
extends NonTransientMapping
implements ExternalRelationshipMapping {
    private List<String> cascadeTypeIndices;
    static final String ACCESS = "access";
    static final String CASCADE = "cascade";
    static final String CASCADE_ALL = "cascade-all";
    static final String CASCADE_DETACH = "cascade-detach";
    static final String CASCADE_MERGE = "cascade-merge";
    static final String CASCADE_PERSIST = "cascade-persist";
    static final String CASCADE_REFRESH = "cascade-refresh";
    static final String CASCADE_REMOVE = "cascade-remove";
    static final String FETCH = "fetch";
    static final String JOIN_FETCH = "join-fetch";
    static final String OPTIONAL = "optional";
    static final String TARGET_ENTITY = "target-entity";

    RelationshipMapping(EmbeddableEntity parent, int index) {
        super(parent, index);
    }

    @Override
    public final void addBatchFetch() {
        BatchFetch batchFetch = this.buildBatchFetch();
        batchFetch.addSelf();
    }

    @Override
    public final void addCascadeType(CascadeType type) {
        Element element = this.getChild(CASCADE);
        if (element == null) {
            element = this.addChild(CASCADE);
        }
        this.addChild(element, this.cascadeType(type), this.cascadeTypeIndices);
    }

    @Override
    public final ExternalJoinTable addJoinTable() {
        JoinTable joinTable = this.buildJoinTable();
        joinTable.addSelf();
        return joinTable;
    }

    private BatchFetch buildBatchFetch() {
        return new BatchFetch(this);
    }

    private List<String> buildCascadeTypeIndices() {
        ArrayList<String> names = new ArrayList<String>();
        names.add(CASCADE_ALL);
        names.add(CASCADE_PERSIST);
        names.add(CASCADE_MERGE);
        names.add(CASCADE_REMOVE);
        names.add(CASCADE_REFRESH);
        names.add(CASCADE_DETACH);
        return names;
    }

    private JoinTable buildJoinTable() {
        return new JoinTable(this);
    }

    private String cascadeType(CascadeType type) {
        switch (type) {
            case ALL: {
                return CASCADE_ALL;
            }
            case DETACH: {
                return CASCADE_DETACH;
            }
            case MERGE: {
                return CASCADE_MERGE;
            }
            case PERSIST: {
                return CASCADE_PERSIST;
            }
            case REFRESH: {
                return CASCADE_REFRESH;
            }
            case REMOVE: {
                return CASCADE_REMOVE;
            }
        }
        return null;
    }

    private CascadeType cascadeType(Element element) {
        String elementName = this.getNodeName(element);
        if (ObjectTools.equals((Object)elementName, (Object)CASCADE_ALL)) {
            return CascadeType.ALL;
        }
        if (ObjectTools.equals((Object)elementName, (Object)CASCADE_DETACH)) {
            return CascadeType.DETACH;
        }
        if (ObjectTools.equals((Object)elementName, (Object)CASCADE_MERGE)) {
            return CascadeType.MERGE;
        }
        if (ObjectTools.equals((Object)elementName, (Object)CASCADE_PERSIST)) {
            return CascadeType.PERSIST;
        }
        if (ObjectTools.equals((Object)elementName, (Object)CASCADE_REFRESH)) {
            return CascadeType.REFRESH;
        }
        if (ObjectTools.equals((Object)elementName, (Object)CASCADE_REMOVE)) {
            return CascadeType.REMOVE;
        }
        return null;
    }

    @Override
    public final ListIterable<CascadeType> cascadeTypes() {
        Element element = this.getChild(CASCADE);
        if (element == null) {
            return EmptyListIterable.instance();
        }
        List<Element> children = this.getChildren(element);
        ArrayList<CascadeType> cascadeTypes = new ArrayList<CascadeType>(children.size());
        for (Element childElement : children) {
            CascadeType cascadeType = this.cascadeType(childElement);
            if (cascadeType == null) continue;
            cascadeTypes.add(cascadeType);
        }
        return new ListListIterable(cascadeTypes);
    }

    @Override
    public final ExternalBatchFetch getBatchFetch() {
        if (this.hasChild("batch-fetch")) {
            return this.buildBatchFetch();
        }
        return null;
    }

    @Override
    public final FetchType getFetchType() {
        return this.getEnumAttribute(FETCH, FetchType.class);
    }

    @Override
    public final JoinFetchType getJoinFetchType() {
        return this.getChildEnumNode(JOIN_FETCH, JoinFetchType.class);
    }

    @Override
    public final ExternalJoinTable getJoinTable() {
        if (this.hasChild("join-table")) {
            return this.buildJoinTable();
        }
        return null;
    }

    @Override
    public final String getTargetEntityName() {
        return this.getAttribute(TARGET_ENTITY);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.cascadeTypeIndices = this.buildCascadeTypeIndices();
    }

    @Override
    public final Boolean isOptional() {
        return this.getBooleanAttribute(OPTIONAL);
    }

    @Override
    public final void removeBatchFetch() {
        this.removeChild("batch-fetch");
    }

    @Override
    public final void removeCascadeType(CascadeType type) {
        Element element = this.getChild(CASCADE);
        if (element != null) {
            this.removeChild(element, this.cascadeType(type));
            if (!this.hasAnyChildren(element)) {
                this.remove(element);
            }
        }
    }

    @Override
    public final void removeJoinTable() {
        Element element = this.getChild("join-table");
        if (element != null) {
            this.remove(element);
        }
    }

    @Override
    public final void setFetchType(FetchType type) {
        this.setAttribute(FETCH, (Enum<?>)type);
    }

    @Override
    public final void setJoinFetchType(JoinFetchType type) {
        this.updateChildTextNode(JOIN_FETCH, (Enum<?>)type);
    }

    @Override
    public final void setOptional(Boolean optional) {
        this.setAttribute(OPTIONAL, optional);
    }

    @Override
    public final void setTargetEntityName(String entityName) {
        this.setAttribute(TARGET_ENTITY, entityName);
    }
}

