/*******************************************************************************
 * Copyright (c) 2010, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.utility;

import java.io.Serializable;
import java.util.concurrent.ThreadFactory;

/**
 * A <code>SimpleThreadFactory</code> is a straightforward implementation of
 * the JDK {@link ThreadFactory}.
 */
public class SimpleThreadFactory
	implements ThreadFactory, Serializable
{
	// singleton
	private static final SimpleThreadFactory INSTANCE = new SimpleThreadFactory();

	/**
	 * Return the singleton.
	 */
	public static ThreadFactory instance() {
		return INSTANCE;
	}

	/**
	 * Ensure single instance.
	 */
	private SimpleThreadFactory() {
		super();
	}

	@Override
	public Thread newThread(Runnable r) {
		return new Thread(r);
	}

	@Override
	public String toString() {
		return this.getClass().getSimpleName();
	}

	private static final long serialVersionUID = 1L;
	private Object readResolve() {
		// replace this object with the singleton
		return INSTANCE;
	}
}