/*******************************************************************************
 * Copyright (c) 2009, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.utility.command;

import org.eclipse.persistence.tools.utility.ObjectTools;
import org.eclipse.persistence.tools.utility.iterable.ArrayIterable;

/**
 * <code>CompositeCommand</code> provides support for treating a collection of
 * {@link Command}s as a single command.
 */
public class CompositeCommand
	implements Command
{
	private final Iterable<Command> commands;

	public CompositeCommand(Command... commands) {
		this(new ArrayIterable<Command>(commands));
	}

	public CompositeCommand(Iterable<Command> commands) {
		super();
		if (commands == null) {
			throw new NullPointerException();
		}
		this.commands = commands;
	}

	@Override
	public void execute() {
		for (Command command : this.commands) {
			command.execute();
		}
	}

	@Override
	public String toString() {
		return ObjectTools.toString(this, this.commands);
	}
}