/*******************************************************************************
 * Copyright (c) 2009, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.utility.filter;

import java.io.Serializable;

/**
 * This filter accepts only non-null objects.
 *
 * @param <T> the type of objects to be filtered
 */
public final class NotNullFilter<T>
	implements Filter<T>, Serializable
{
	@SuppressWarnings("rawtypes")
	public static final Filter INSTANCE = new NotNullFilter();

	@SuppressWarnings("unchecked")
	public static <R> Filter<R> instance() {
		return INSTANCE;
	}

	// ensure single instance
	private NotNullFilter() {
		super();
	}

	// accept only non-null objects
	@Override
	public boolean accept(T o) {
		return o != null;
	}

	@Override
	public String toString() {
		return this.getClass().getSimpleName();
	}

	private static final long serialVersionUID = 1L;
	private Object readResolve() {
		// replace this object with the singleton
		return INSTANCE;
	}
}