/*******************************************************************************
 * Copyright (c) 2006, 2012 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm;


/**
 * This interface represents the basis for all mapping types defined by the JPA spec that are
 * available for configuration via the ORM xml.
 * <p>
 * Provisional API: This interface is part of an interim API that is still under development and
 * expected to change significantly before reaching stability. It is available at this early stage
 * to solicit feedback from pioneering adopters on the understanding that any code that uses this
 * API will almost certainly be broken (repeatedly) as the API evolves.<p>
 *
 * @see http://jcp.org/aboutJava/communityprocess/final/jsr220/index.html, persistence specificaton
 *
 * @version 2.5
 * @author John Bracken
 */
public interface ExternalMapping extends ExternalForm {

	/**
	 * Returns the attribute type of this mapping.
	 */
	String getAttributeType();
	
	/**
	 * Returns the short name of the attribute type 
	 * of this mapping.
	 */	
	String getAttributeTypeShortName();
	
	/**
	 * Returns the name of the mapping.
	 */
	String getName();
	
	/**
	 * Indicates whether this mapping is of type 
	 * {@link Basic}.
	 */
	boolean isBasicMapping();
	
	/**
	 * Indicates whether this mapping is of type 
	 * {@link ElementCollection}.
	 */
	boolean isElementCollectionMapping();
	
	/**
	 * Indicates whether this mapping is of type 
	 * {@link Embedded}.
	 */
	boolean isEmbeddedMapping();
	
	
	/**
	 * Derives a getter method name for this mapping's 
	 * attribute.
	 */
	String getGetMethodName();
	
	/**
	 * Derives a setter method name for this mapping's 
	 * attribute.
	 */
	String getSetMethodName();
	
	/**
	 * Indicates whether this mapping is of type 
	 * {@link Id}.
	 */
	boolean isIdMapping();
	
	/**
	 * Sets the attribute type of this mapping.
	 */
	void setAttributeType(String attributeType);

	
	/**
	 * Sets the name of the mapping.
	 */
	void setName(String name);
}