/*******************************************************************************
 * Copyright (c) 2006, 2012 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm;

import javax.persistence.EnumType;
import javax.persistence.TemporalType;
import org.eclipse.persistence.tools.utility.iterable.ListIterable;

/**
 * This interface represents some common API for one-to-many, many-to-many, and element collection mappings.
 * <p>
 * Provisional API: This interface is part of an interim API that is still under development and
 * expected to change significantly before reaching stability. It is available at this early stage
 * to solicit feedback from pioneering adopters on the understanding that any code that uses this
 * API will almost certainly be broken (repeatedly) as the API evolves.<p>
 *
 * @version 2.5
 * @author Les Davis
 */
public interface ExternalObjectCollectionMapping extends ExternalNonTransientMapping {

	/**
	 * Adds a override with the given name.
	 */
	ExternalAssociationOverride addMapKeyAssociationOverride(int index);

	/**
	 * Adds a override with the given name.
	 */
	ExternalAttributeOverride addMapKeyAttributeOverride(int index);

	/**
	 * Adds the map key column for this mapping.
	 */
	void addMapKeyColumn();

	/**
	 * Adds a map key join column with the given name.
	 */
	void addMapKeyJoinColumn(int index, String name);

	/**
	 * Adds the order column for this mapping.
	 */
	void addOrderColumn();

	/**
	 * Returns the map key.
	 */
	String getMapKey();

	/**
	 * Returns the association override at the specified index.
	 */
	ExternalAssociationOverride getMapKeyAssociationOverride(int index);

	/**
	 * Returns the attribute override at the specified index.
	 */
	ExternalAttributeOverride getMapKeyAttributeOverride(int index);

	/**
	 * Returns the map key class name.
	 */
	String getMapKeyClassName();

	/**
	 * Returns the map key column for this mapping.
	 */
	ExternalEntityColumn getMapKeyColumn();

	/**
	 * Returns the map key converter name for this mapping.
	 */
	String getMapKeyConverterName();

	/**
	 * Returns the map key enumerated type for this mapping.
	 */
	EnumType getMapKeyEnumeratedType();

	/**
	 * Returns a map key join column with the given name.
	 */
	ExternalJoinColumn getMapKeyJoinColumn(int index);

	/**
	 * Returns the temporal type for this mapping.
	 */
	TemporalType getMapKeyTemporalType();

	/**
	 * Returns the order by string.
	 */
	String getOrderByFieldName();

	/**
	 * Returns the order column for this mapping.
	 */
	ExternalOrderColumn getOrderColumn();

	/**
	 * Returns a list of association overrides defined on this mapping.
	 */
	ListIterable<ExternalAssociationOverride> mapKeyAssociationOverrides();

	/**
	 * Returns the count of association overrides defined on this entity.
	 */
	int mapKeyAssociationOverridesSize();

	/**
	 * Returns a list of overridden column mappings for embedded mapping.
	 */
	ListIterable<ExternalAttributeOverride> mapKeyAttributeOverrides();

	/**
	 * Returns the count of overridden column mappings for embedded fields.
	 */
	int mapKeyAttributeOverridesSize();

	/**
	 * Returns the map key join column for this mapping.
	 */
	ListIterable<ExternalJoinColumn> mapKeyJoinColumns();

	/**
	 * Returns the count of map key join columns for this mapping.
	 */
	int mapKeyJoinColumnsSize();

	/**
	 * Removes the override named
	 */
	void removeMapKeyAssociationOverride(int index);

	/**
	 * Removes the override named.
	 */
	void removeMapKeyAttributeOverride(int index);

	/**
	 * Removes the map key column from this mapping.
	 */
	void removeMapKeyColumn();

	/**
	 * Removes the map key join column named.
	 */
	void removeMapKeyJoinColumn(int index);

	/**
	 * Removes the order column from this mapping.
	 */
	void removeOrderColumn();

	/**
	 * Sets the map key.
	 */
	void setMapKey(String mapKey);

	/**
	 * Sets the map key class name.
	 */
	void setMapKeyClassName(String className);

	/**
	 * Sets the map key converter name.
	 */
	void setMapKeyConverterName(String converterName);

	/**
	 * Sets the enumerated type for this mapping.
	 */
	void setMapKeyEnumeratedType(EnumType enumType);

	/**
	 * Sets the temporal type.
	 */
	void setMapKeyTemporalType(TemporalType temporalType);

	/**
	 * Sets the order by string.
	 */
	void setOrderByFieldName(String orderBy);
}