/*******************************************************************************
 * Copyright (c) 2006, 2012 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.persistence;

import org.eclipse.persistence.tools.mapping.orm.XmlConstants;

/**
 * This interface represents a collection of static constants for the jpa, persistence xml document.
 * <p>
 * Provisional API: This interface is part of an interim API that is still under development and
 * expected to change significantly before reaching stability. It is available at this early stage
 * to solicit feedback from pioneering adopters on the understanding that any code that uses this
 * API will almost certainly be broken (repeatedly) as the API evolves.<p>
 *
 * @version 2.5
 */
@SuppressWarnings("nls")
public interface PersistenceXmlConstants extends XmlConstants {

	/**
	 * The URI of the persistence namespace.
	 */
	String PERSISTENCE_NAMESPACE_URI = "http://java.sun.com/xml/ns/persistence";

	/**
	 * The URI of the persistence 1.0.
	 */
	String PERSISTENCE_XSD_URI_1_0 = "http://java.sun.com/xml/ns/persistence/persistence_1_0.xsd";

	/**
	 * The URI of the persistence 2.0 schema.
	 */
	String PERSISTENCE_XSD_URI_2_0 = "http://java.sun.com/xml/ns/persistence/persistence_2_0.xsd";

	/**
	 * The URI of the persistence 2.1 schema.
	 */
	String PERSISTENCE_XSD_URI_2_1 = "http://java.sun.com/xml/ns/persistence/persistence_2_1.xsd";
}