/*******************************************************************************
 * Copyright (c) 2006, 2012 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.persistence.dom;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.persistence.tools.mapping.persistence.ExternalPersistenceConfiguration;
import org.eclipse.persistence.tools.mapping.persistence.ExternalPersistenceRepository;
import org.eclipse.persistence.tools.mapping.persistence.PersistenceDocumentType;
import org.eclipse.persistence.tools.utility.XMLTools;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

/**
 * This is the concrete implementation of the external repository used to handle the retrieval and
 * creation of Persistence Configuration files.
 *
 * @see ExternalPersistenceConfiguration
 * @see PersistenceConfiguration
 *
 * @version 2.5
 */
@SuppressWarnings("nls")
public final class PersistenceRepository implements ExternalPersistenceRepository {

	/**
	 * The Persistence Configuration file name, which is <code>persistence.xml</code>.
	 */
	public static final String PERSISTENCE_XML = "persistence.xml";

	/**
	 * Creates a new <code>PersistenceRepository</code>.
	 */
	public PersistenceRepository() {
		super();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public ExternalPersistenceConfiguration buildPersistenceConfiguration(URL location, PersistenceDocumentType type) throws IOException {

		PersistenceConfiguration persistence = new PersistenceConfiguration(XMLTools.newDocument());
		persistence.addSelf();
		persistence.setDocumentType(type);

		return persistence;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public ExternalPersistenceConfiguration getPersistenceConfiguration(String persistenceXml) {

		try {
			DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
			dbf.setValidating(false);
			dbf.setNamespaceAware(false);
			DocumentBuilder builder = dbf.newDocumentBuilder();
			Document document = builder.parse(new InputSource(
				new ByteArrayInputStream(persistenceXml.getBytes("utf-8"))
			));
			return new PersistenceConfiguration(document);
		}
		catch (Exception e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		}
		return null;
	}
}