/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo.helper;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import org.eclipse.persistence.exceptions.SDOException;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedGetDeclaredConstructorFor;
import org.eclipse.persistence.internal.security.PrivilegedInvokeConstructor;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.sessions.Session;

public class InstanceClassConverter
implements Converter {
    private Class customClass;

    public Object convertObjectValueToDataValue(Object objectValue, Session session) {
        if (objectValue != null) {
            return objectValue.toString();
        }
        return null;
    }

    public Object convertDataValueToObjectValue(Object dataValue, Session session) {
        if (dataValue != null) {
            Class[] params = new Class[]{String.class};
            Constructor ctor = null;
            try {
                ctor = PrivilegedAccessHelper.shouldUsePrivilegedAccess() ? (Constructor)AccessController.doPrivileged(new PrivilegedGetDeclaredConstructorFor(this.customClass, params, true)) : PrivilegedAccessHelper.getDeclaredConstructorFor((Class)this.customClass, (Class[])params, (boolean)true);
                Object[] args = new Object[]{dataValue.toString()};
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    return AccessController.doPrivileged(new PrivilegedInvokeConstructor(ctor, args));
                }
                return PrivilegedAccessHelper.invokeConstructor((Constructor)ctor, (Object[])args);
            }
            catch (PrivilegedActionException e) {
                throw SDOException.noConstructorWithString((Exception)e, (String)this.customClass.getName());
            }
            catch (NoSuchMethodException e) {
                throw SDOException.noConstructorWithString((Exception)e, (String)this.customClass.getName());
            }
            catch (IllegalAccessException e) {
                throw SDOException.noConstructorWithString((Exception)e, (String)this.customClass.getName());
            }
            catch (InvocationTargetException e) {
                throw SDOException.noConstructorWithString((Exception)e, (String)this.customClass.getName());
            }
            catch (InstantiationException e) {
                throw SDOException.noConstructorWithString((Exception)e, (String)this.customClass.getName());
            }
        }
        return null;
    }

    public boolean isMutable() {
        return true;
    }

    public void initialize(DatabaseMapping mapping, Session session) {
    }

    public void setCustomClass(Class customClass) {
        this.customClass = customClass;
    }

    public Class getCustomClass() {
        return this.customClass;
    }
}

