/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.models.readonly;

import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.internal.identitymaps.FullIdentityMap;
import org.eclipse.persistence.mappings.AggregateObjectMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.mappings.ManyToManyMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.testing.models.readonly.Actor;
import org.eclipse.persistence.testing.models.readonly.Address;
import org.eclipse.persistence.testing.models.readonly.Charity;
import org.eclipse.persistence.testing.models.readonly.Country;
import org.eclipse.persistence.testing.models.readonly.DefaultReadOnlyTestClass;
import org.eclipse.persistence.testing.models.readonly.HollywoodAgent;
import org.eclipse.persistence.testing.models.readonly.Movie;
import org.eclipse.persistence.testing.models.readonly.Promoter;
import org.eclipse.persistence.testing.models.readonly.ReadOnlyCharity;
import org.eclipse.persistence.testing.models.readonly.ReadOnlyHollywoodAgent;
import org.eclipse.persistence.testing.models.readonly.Studio;

public class ReadOnlyProject
extends Project {
    public ReadOnlyProject() {
        this.applyPROJECT();
        this.applyLOGIN();
        this.buildActorDescriptor();
        this.buildAddressDescriptor();
        this.buildCharityDescriptor();
        this.buildCountryDescriptor();
        this.buildDefaultReadOnlyTestClassDescriptor();
        this.buildHollywoodAgentDescriptor();
        this.buildMovieDescriptor();
        this.buildPromoterDescriptor();
        this.buildReadOnlyCharityDescriptor();
        this.buildReadOnlyHollywoodAgentDescriptor();
        this.buildStudioDescriptor();
    }

    protected void applyLOGIN() {
        this.setLogin(new DatabaseLogin());
    }

    protected void applyPROJECT() {
        this.setName("ReadOnlyProject");
    }

    protected void buildActorDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Actor.class);
        Vector<String> vector = new Vector<String>();
        vector.addElement("RO_ACTOR");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("RO_ACTOR.ACT_ID");
        descriptor.setIdentityMapClass(FullIdentityMap.class);
        descriptor.setSequenceNumberName("SEQ");
        descriptor.setSequenceNumberFieldName("ACT_ID");
        descriptor.setExistenceChecking("Check cache");
        descriptor.setIdentityMapSize(100);
        descriptor.createCopyPolicy("constructor");
        descriptor.createInstantiationPolicy("constructor");
        DirectToFieldMapping directtofieldmapping = new DirectToFieldMapping();
        directtofieldmapping.setAttributeName("id");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setFieldName("RO_ACTOR.ACT_ID");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping);
        DirectToFieldMapping directtofieldmapping1 = new DirectToFieldMapping();
        directtofieldmapping1.setAttributeName("minimumSalary");
        directtofieldmapping1.setIsReadOnly(false);
        directtofieldmapping1.setFieldName("RO_ACTOR.MIN_SAL");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping1);
        DirectToFieldMapping directtofieldmapping2 = new DirectToFieldMapping();
        directtofieldmapping2.setAttributeName("name");
        directtofieldmapping2.setIsReadOnly(false);
        directtofieldmapping2.setFieldName("RO_ACTOR.ACT_NAME");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping2);
        ManyToManyMapping manytomanymapping = new ManyToManyMapping();
        manytomanymapping.setAttributeName("movies");
        manytomanymapping.setIsReadOnly(true);
        manytomanymapping.setUsesIndirection(false);
        manytomanymapping.setReferenceClass(Movie.class);
        manytomanymapping.setIsPrivateOwned(false);
        manytomanymapping.setRelationTableName("ACT_MOV");
        manytomanymapping.addSourceRelationKeyFieldName("ACT_MOV.ACT_ID", "RO_ACTOR.ACT_ID");
        manytomanymapping.addTargetRelationKeyFieldName("ACT_MOV.MOV_ID", "RO_MOVIE.MOV_ID");
        descriptor.addMapping((DatabaseMapping)manytomanymapping);
        ManyToManyMapping charitiesMapping = new ManyToManyMapping();
        charitiesMapping.setAttributeName("charities");
        charitiesMapping.setIsReadOnly(false);
        charitiesMapping.setUsesIndirection(false);
        charitiesMapping.setReferenceClass(ReadOnlyCharity.class);
        charitiesMapping.setIsPrivateOwned(false);
        charitiesMapping.setRelationTableName("ACT_CHA");
        charitiesMapping.setSourceRelationKeyFieldName("ACT_ID");
        charitiesMapping.setTargetRelationKeyFieldName("CHARITY_ID");
        descriptor.addMapping((DatabaseMapping)charitiesMapping);
        OneToOneMapping hollywoodAgentMapping = new OneToOneMapping();
        hollywoodAgentMapping.setAttributeName("hollywoodAgent");
        hollywoodAgentMapping.setIsReadOnly(false);
        hollywoodAgentMapping.setUsesIndirection(false);
        hollywoodAgentMapping.setReferenceClass(ReadOnlyHollywoodAgent.class);
        hollywoodAgentMapping.setIsPrivateOwned(false);
        hollywoodAgentMapping.addForeignKeyFieldName("HOLLYWOODAGENT_ID", "HOLLYWOODAGENT_ID");
        descriptor.addMapping((DatabaseMapping)hollywoodAgentMapping);
        this.addDescriptor((ClassDescriptor)descriptor);
    }

    protected void buildAddressDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Address.class);
        Vector<String> vector = new Vector<String>();
        vector.addElement("RO_ADDR");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("RO_ADDR.ADD_ID");
        descriptor.setIdentityMapClass(FullIdentityMap.class);
        descriptor.setSequenceNumberName("ADD_SEQ");
        descriptor.setSequenceNumberFieldName("ADD_ID");
        descriptor.setExistenceChecking("Check cache");
        descriptor.setIdentityMapSize(100);
        descriptor.createCopyPolicy("constructor");
        descriptor.createInstantiationPolicy("constructor");
        DirectToFieldMapping directtofieldmapping = new DirectToFieldMapping();
        directtofieldmapping.setAttributeName("city");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setFieldName("RO_ADDR.CITY");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping);
        DirectToFieldMapping directtofieldmapping1 = new DirectToFieldMapping();
        directtofieldmapping1.setAttributeName("id");
        directtofieldmapping1.setIsReadOnly(false);
        directtofieldmapping1.setFieldName("RO_ADDR.ADD_ID");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping1);
        DirectToFieldMapping directtofieldmapping2 = new DirectToFieldMapping();
        directtofieldmapping2.setAttributeName("streetAddress");
        directtofieldmapping2.setIsReadOnly(false);
        directtofieldmapping2.setFieldName("RO_ADDR.STREET");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping2);
        DirectToFieldMapping directtofieldmapping3 = new DirectToFieldMapping();
        directtofieldmapping3.setAttributeName("zipCode");
        directtofieldmapping3.setIsReadOnly(false);
        directtofieldmapping3.setFieldName("RO_ADDR.ZIP");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping3);
        OneToOneMapping onetoonemapping = new OneToOneMapping();
        onetoonemapping.setAttributeName("country");
        onetoonemapping.setIsReadOnly(false);
        onetoonemapping.setUsesIndirection(false);
        onetoonemapping.setReferenceClass(Country.class);
        onetoonemapping.setIsPrivateOwned(false);
        onetoonemapping.addForeignKeyFieldName("RO_ADDR.COUNTRY_ID", "COUNTRY.COUNTRY_ID");
        descriptor.addMapping((DatabaseMapping)onetoonemapping);
        this.addDescriptor((ClassDescriptor)descriptor);
    }

    protected void buildCharityDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Charity.class);
        descriptor.setTableName("CHARITY");
        descriptor.addPrimaryKeyFieldName("CHARITY_ID");
        descriptor.setSequenceNumberName("CHARITY_SEQ");
        descriptor.setSequenceNumberFieldName("CHARITY_ID");
        descriptor.addDirectMapping("id", "CHARITY_ID");
        descriptor.addDirectMapping("name", "NAME");
        descriptor.addDirectMapping("donationsRaised", "DONATIONS_RAISED");
        this.addDescriptor((ClassDescriptor)descriptor);
    }

    protected void buildCountryDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Country.class);
        Vector<String> vector = new Vector<String>();
        vector.addElement("COUNTRY");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("COUNTRY.COUNTRY_ID");
        descriptor.setIdentityMapClass(FullIdentityMap.class);
        descriptor.setSequenceNumberName("COUNTRY_SEQ");
        descriptor.setSequenceNumberFieldName("COUNTRY_ID");
        descriptor.setExistenceChecking("Check cache");
        descriptor.setIdentityMapSize(100);
        descriptor.createCopyPolicy("constructor");
        descriptor.createInstantiationPolicy("constructor");
        DirectToFieldMapping directtofieldmapping = new DirectToFieldMapping();
        directtofieldmapping.setAttributeName("id");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setFieldName("COUNTRY.COUNTRY_ID");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping);
        DirectToFieldMapping directtofieldmapping1 = new DirectToFieldMapping();
        directtofieldmapping1.setAttributeName("name");
        directtofieldmapping1.setIsReadOnly(false);
        directtofieldmapping1.setFieldName("COUNTRY.NAME");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping1);
        this.addDescriptor((ClassDescriptor)descriptor);
    }

    protected void buildDefaultReadOnlyTestClassDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(DefaultReadOnlyTestClass.class);
        descriptor.setTableName("DEFAULT_READ_ONLY");
        descriptor.setPrimaryKeyFieldName("DEFAULT_READ_ONLY.DATA");
        DirectToFieldMapping directToFieldMapping = new DirectToFieldMapping();
        directToFieldMapping.setAttributeName("data");
        directToFieldMapping.setFieldName("DEFAULT_READ_ONLY.DATA");
        directToFieldMapping.setGetMethodName("getData");
        directToFieldMapping.setSetMethodName("setData");
        descriptor.addMapping((DatabaseMapping)directToFieldMapping);
        this.addDescriptor((ClassDescriptor)descriptor);
        this.addDefaultReadOnlyClass(DefaultReadOnlyTestClass.class);
    }

    protected void buildHollywoodAgentDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(HollywoodAgent.class);
        descriptor.setTableName("HOLLYWOODAGENT");
        descriptor.addPrimaryKeyFieldName("HOLLYWOODAGENT_ID");
        descriptor.setSequenceNumberName("HOLLYWOODAGENT_SEQ");
        descriptor.setSequenceNumberFieldName("HOLLYWOODAGENT_ID");
        descriptor.addDirectMapping("id", "HOLLYWOODAGENT_ID");
        descriptor.addDirectMapping("name", "NAME");
        descriptor.addDirectMapping("numberOfConnections", "CONNECTIONS");
        this.addDescriptor((ClassDescriptor)descriptor);
    }

    protected void buildMovieDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Movie.class);
        Vector<String> vector = new Vector<String>();
        vector.addElement("RO_MOVIE");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("RO_MOVIE.MOV_ID");
        descriptor.setIdentityMapClass(FullIdentityMap.class);
        descriptor.setSequenceNumberName("MOV_SEQ");
        descriptor.setSequenceNumberFieldName("MOV_ID");
        descriptor.setExistenceChecking("Check cache");
        descriptor.setIdentityMapSize(100);
        descriptor.createCopyPolicy("constructor");
        descriptor.createInstantiationPolicy("constructor");
        AggregateObjectMapping aggregateobjectmapping = new AggregateObjectMapping();
        aggregateobjectmapping.setAttributeName("studio");
        aggregateobjectmapping.setIsReadOnly(true);
        aggregateobjectmapping.setReferenceClass(Studio.class);
        aggregateobjectmapping.setIsNullAllowed(false);
        descriptor.addMapping((DatabaseMapping)aggregateobjectmapping);
        DirectToFieldMapping directtofieldmapping = new DirectToFieldMapping();
        directtofieldmapping.setAttributeName("id");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setFieldName("RO_MOVIE.MOV_ID");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping);
        DirectToFieldMapping directtofieldmapping1 = new DirectToFieldMapping();
        directtofieldmapping1.setAttributeName("title");
        directtofieldmapping1.setIsReadOnly(false);
        directtofieldmapping1.setFieldName("RO_MOVIE.TITLE");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping1);
        ManyToManyMapping manytomanymapping = new ManyToManyMapping();
        manytomanymapping.setAttributeName("actors");
        manytomanymapping.setIsReadOnly(false);
        manytomanymapping.setUsesIndirection(false);
        manytomanymapping.setReferenceClass(Actor.class);
        manytomanymapping.setIsPrivateOwned(true);
        manytomanymapping.setRelationTableName("ACT_MOV");
        manytomanymapping.addSourceRelationKeyFieldName("ACT_MOV.MOV_ID", "RO_MOVIE.MOV_ID");
        manytomanymapping.addTargetRelationKeyFieldName("ACT_MOV.ACT_ID", "RO_ACTOR.ACT_ID");
        descriptor.addMapping((DatabaseMapping)manytomanymapping);
        OneToOneMapping onetoonemapping = new OneToOneMapping();
        onetoonemapping.setAttributeName("promoter");
        onetoonemapping.setIsReadOnly(false);
        onetoonemapping.setUsesIndirection(false);
        onetoonemapping.setReferenceClass(Promoter.class);
        onetoonemapping.setIsPrivateOwned(false);
        onetoonemapping.addForeignKeyFieldName("RO_MOVIE.PROMO_ID", "RO_PROMO.PROMO_ID");
        descriptor.addMapping((DatabaseMapping)onetoonemapping);
        this.addDescriptor((ClassDescriptor)descriptor);
    }

    protected void buildPromoterDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Promoter.class);
        Vector<String> vector = new Vector<String>();
        vector.addElement("RO_PROMO");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("RO_PROMO.PROMO_ID");
        descriptor.setIdentityMapClass(FullIdentityMap.class);
        descriptor.setSequenceNumberName("PROMO_SEQ");
        descriptor.setSequenceNumberFieldName("PROMO_ID");
        descriptor.setExistenceChecking("Check cache");
        descriptor.setIdentityMapSize(100);
        descriptor.createCopyPolicy("constructor");
        descriptor.createInstantiationPolicy("constructor");
        DirectToFieldMapping directtofieldmapping = new DirectToFieldMapping();
        directtofieldmapping.setAttributeName("id");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setFieldName("RO_PROMO.PROMO_ID");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping);
        DirectToFieldMapping directtofieldmapping1 = new DirectToFieldMapping();
        directtofieldmapping1.setAttributeName("name");
        directtofieldmapping1.setIsReadOnly(false);
        directtofieldmapping1.setFieldName("RO_PROMO.NAME");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping1);
        this.addDescriptor((ClassDescriptor)descriptor);
    }

    protected void buildReadOnlyCharityDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(ReadOnlyCharity.class);
        descriptor.setTableName("CHARITY");
        descriptor.addPrimaryKeyFieldName("CHARITY_ID");
        descriptor.setSequenceNumberName("CHARITY_SEQ");
        descriptor.setSequenceNumberFieldName("CHARITY_ID");
        descriptor.addDirectMapping("id", "CHARITY_ID");
        descriptor.addDirectMapping("name", "NAME");
        descriptor.setShouldBeReadOnly(true);
        this.addDescriptor((ClassDescriptor)descriptor);
    }

    protected void buildReadOnlyHollywoodAgentDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(ReadOnlyHollywoodAgent.class);
        descriptor.setTableName("HOLLYWOODAGENT");
        descriptor.addPrimaryKeyFieldName("HOLLYWOODAGENT_ID");
        descriptor.setSequenceNumberName("HOLLYWOODAGENT_SEQ");
        descriptor.setSequenceNumberFieldName("HOLLYWOODAGENT_ID");
        descriptor.addDirectMapping("id", "HOLLYWOODAGENT_ID");
        descriptor.addDirectMapping("name", "NAME");
        this.addDescriptor((ClassDescriptor)descriptor);
        this.addDefaultReadOnlyClass(ReadOnlyHollywoodAgent.class);
    }

    protected void buildStudioDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Studio.class);
        Vector<String> vector = new Vector<String>();
        vector.addElement("RO_MOVIE");
        descriptor.setTableNames(vector);
        descriptor.setIdentityMapClass(FullIdentityMap.class);
        descriptor.setExistenceChecking("Check cache");
        descriptor.setIdentityMapSize(100);
        descriptor.descriptorIsAggregate();
        descriptor.createCopyPolicy("constructor");
        descriptor.createInstantiationPolicy("constructor");
        DirectToFieldMapping directtofieldmapping = new DirectToFieldMapping();
        directtofieldmapping.setAttributeName("name");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setFieldName("RO_MOVIE.STD_NAME");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping);
        DirectToFieldMapping directtofieldmapping1 = new DirectToFieldMapping();
        directtofieldmapping1.setAttributeName("owner");
        directtofieldmapping1.setIsReadOnly(false);
        directtofieldmapping1.setFieldName("RO_MOVIE.STD_OWN");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping1);
        OneToOneMapping onetoonemapping = new OneToOneMapping();
        onetoonemapping.setAttributeName("address");
        onetoonemapping.setIsReadOnly(false);
        onetoonemapping.setUsesIndirection(false);
        onetoonemapping.setReferenceClass(Address.class);
        onetoonemapping.setIsPrivateOwned(true);
        onetoonemapping.addForeignKeyFieldName("RO_MOVIE.STD_ADD", "RO_ADDR.ADD_ID");
        descriptor.addMapping((DatabaseMapping)onetoonemapping);
        this.addDescriptor((ClassDescriptor)descriptor);
    }
}

