/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.models.vehicle;

import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.testing.models.vehicle.CarOwner;
import org.eclipse.persistence.testing.models.vehicle.EngineType;
import org.eclipse.persistence.testing.models.vehicle.FuelType;
import org.eclipse.persistence.testing.models.vehicle.SportsCar;

public class VehicleProject
extends Project {
    public VehicleProject() {
        this.setName("Vehicle");
        this.applyLogin();
        this.addDescriptor(this.buildCarOwnerClassDescriptor());
        this.addDescriptor(this.buildEngineTypeClassDescriptor());
        this.addDescriptor(this.buildFuelTypeClassDescriptor());
        this.addDescriptor(this.buildSportsCarClassDescriptor());
    }

    public ClassDescriptor buildCarOwnerClassDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(CarOwner.class);
        descriptor.addTableName("CAROWNER");
        descriptor.addPrimaryKeyFieldName("CAROWNER.ID");
        descriptor.useSoftCacheWeakIdentityMap();
        descriptor.setIdentityMapSize(100);
        descriptor.useRemoteSoftCacheWeakIdentityMap();
        descriptor.setRemoteIdentityMapSize(100);
        descriptor.setAlias("CarOwner");
        descriptor.getQueryManager().checkCacheForDoesExist();
        DirectToFieldMapping idMapping = new DirectToFieldMapping();
        idMapping.setAttributeName("id");
        idMapping.setFieldName("CAROWNER.ID");
        descriptor.addMapping((DatabaseMapping)idMapping);
        DirectToFieldMapping nameMapping = new DirectToFieldMapping();
        nameMapping.setAttributeName("name");
        nameMapping.setFieldName("CAROWNER.NAME");
        descriptor.addMapping((DatabaseMapping)nameMapping);
        OneToOneMapping carMapping = new OneToOneMapping();
        carMapping.setAttributeName("car");
        carMapping.setReferenceClass(SportsCar.class);
        carMapping.dontUseIndirection();
        carMapping.addForeignKeyFieldName("CAROWNER.CARID", "SPORTSCAR.ID");
        descriptor.addMapping((DatabaseMapping)carMapping);
        OneToOneMapping lastCarMapping = new OneToOneMapping();
        lastCarMapping.setAttributeName("lastCar");
        lastCarMapping.setReferenceClass(SportsCar.class);
        lastCarMapping.dontUseIndirection();
        lastCarMapping.addForeignKeyFieldName("CAROWNER.LASTCARID", "SPORTSCAR.ID");
        descriptor.addMapping((DatabaseMapping)lastCarMapping);
        return descriptor;
    }

    public ClassDescriptor buildEngineTypeClassDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(EngineType.class);
        descriptor.addTableName("ENGINETYPE");
        descriptor.addPrimaryKeyFieldName("ENGINETYPE.ID");
        descriptor.useSoftCacheWeakIdentityMap();
        descriptor.setIdentityMapSize(100);
        descriptor.useRemoteSoftCacheWeakIdentityMap();
        descriptor.setRemoteIdentityMapSize(100);
        descriptor.setAlias("EngineType");
        descriptor.getQueryManager().checkCacheForDoesExist();
        DirectToFieldMapping idMapping = new DirectToFieldMapping();
        idMapping.setAttributeName("id");
        idMapping.setFieldName("ENGINETYPE.ID");
        descriptor.addMapping((DatabaseMapping)idMapping);
        DirectToFieldMapping typeMapping = new DirectToFieldMapping();
        typeMapping.setAttributeName("type");
        typeMapping.setFieldName("ENGINETYPE.TYPE");
        descriptor.addMapping((DatabaseMapping)typeMapping);
        return descriptor;
    }

    public ClassDescriptor buildFuelTypeClassDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(FuelType.class);
        descriptor.addTableName("FUELTYPE");
        descriptor.addPrimaryKeyFieldName("FUELTYPE.ID");
        descriptor.useSoftCacheWeakIdentityMap();
        descriptor.setIdentityMapSize(100);
        descriptor.useRemoteSoftCacheWeakIdentityMap();
        descriptor.setRemoteIdentityMapSize(100);
        descriptor.setAlias("FuelType");
        descriptor.getQueryManager().checkCacheForDoesExist();
        DirectToFieldMapping fuelDescriptionMapping = new DirectToFieldMapping();
        fuelDescriptionMapping.setAttributeName("fuelDescription");
        fuelDescriptionMapping.setFieldName("FUELTYPE.DESCRIPTION");
        descriptor.addMapping((DatabaseMapping)fuelDescriptionMapping);
        DirectToFieldMapping fuelIdMapping = new DirectToFieldMapping();
        fuelIdMapping.setAttributeName("fuelId");
        fuelIdMapping.setFieldName("FUELTYPE.ID");
        descriptor.addMapping((DatabaseMapping)fuelIdMapping);
        return descriptor;
    }

    public ClassDescriptor buildSportsCarClassDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(SportsCar.class);
        descriptor.addTableName("SPORTSCAR");
        descriptor.addPrimaryKeyFieldName("SPORTSCAR.ID");
        descriptor.useSoftCacheWeakIdentityMap();
        descriptor.setIdentityMapSize(100);
        descriptor.useRemoteSoftCacheWeakIdentityMap();
        descriptor.setRemoteIdentityMapSize(100);
        descriptor.setAlias("SportsCar");
        descriptor.getQueryManager().checkCacheForDoesExist();
        DirectToFieldMapping descriptionMapping = new DirectToFieldMapping();
        descriptionMapping.setAttributeName("description");
        descriptionMapping.setFieldName("SPORTSCAR.DESCRIPTION");
        descriptor.addMapping((DatabaseMapping)descriptionMapping);
        DirectToFieldMapping fuelCapacityMapping = new DirectToFieldMapping();
        fuelCapacityMapping.setAttributeName("fuelCapacity");
        fuelCapacityMapping.setFieldName("SPORTSCAR.FUELCAPACITY");
        descriptor.addMapping((DatabaseMapping)fuelCapacityMapping);
        DirectToFieldMapping idMapping = new DirectToFieldMapping();
        idMapping.setAttributeName("id");
        idMapping.setFieldName("SPORTSCAR.ID");
        descriptor.addMapping((DatabaseMapping)idMapping);
        OneToOneMapping engineTypeMapping = new OneToOneMapping();
        engineTypeMapping.setAttributeName("engineType");
        engineTypeMapping.setReferenceClass(EngineType.class);
        engineTypeMapping.dontUseIndirection();
        engineTypeMapping.addForeignKeyFieldName("SPORTSCAR.ENGINEID", "ENGINETYPE.ID");
        descriptor.addMapping((DatabaseMapping)engineTypeMapping);
        OneToOneMapping fuelTypeMapping = new OneToOneMapping();
        fuelTypeMapping.setAttributeName("fuelType");
        fuelTypeMapping.setReferenceClass(FuelType.class);
        fuelTypeMapping.dontUseIndirection();
        fuelTypeMapping.addForeignKeyFieldName("SPORTSCAR.FUELID", "FUELTYPE.ID");
        descriptor.addMapping((DatabaseMapping)fuelTypeMapping);
        return descriptor;
    }
}

