/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.aggregate;

import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.aggregate.AddressDescription;
import org.eclipse.persistence.testing.models.aggregate.Client;

public class AggregateVersionOpimisticLockingTest
extends TestCase {
    protected Exception insertException = null;
    protected Exception updateException = null;
    protected Exception forceUpdateException = null;
    protected int initialVersion = -1;
    protected int forcedUpdateVersion = -1;
    protected int finalVersion = -1;

    public AggregateVersionOpimisticLockingTest() {
        this.setDescription("Test to ensure that inserting objects with the optimistic locking  version in an aggregate works when inserting in a UnitOfWork");
    }

    public void setup() {
        this.beginTransaction();
    }

    public void test() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        Client client = new Client();
        client.setName("Michael Ryder");
        client.setAddressDescription(AddressDescription.example1());
        uow.registerObject((Object)client);
        try {
            uow.commit();
        }
        catch (NullPointerException exception) {
            this.insertException = exception;
        }
        this.initialVersion = client.getVersion().getVersion();
        uow = this.getSession().acquireUnitOfWork();
        client = (Client)uow.readObject(Client.class);
        uow.forceUpdateToVersionField((Object)client, true);
        try {
            uow.commit();
        }
        catch (NullPointerException exception) {
            this.forceUpdateException = exception;
        }
        this.forcedUpdateVersion = client.getVersion().getVersion();
        uow = this.getSession().acquireUnitOfWork();
        client = (Client)uow.readObject((Object)client);
        client.setName("Mike Ribero");
        try {
            uow.commit();
        }
        catch (NullPointerException exception) {
            this.updateException = exception;
        }
        this.finalVersion = client.getVersion().getVersion();
    }

    public void verify() {
        if (this.insertException != null) {
            throw new TestErrorException("An exception was thrown when trying to insert an object with it's optimistic locking version stored in an aggregate: " + this.insertException.toString());
        }
        if (this.updateException != null) {
            throw new TestErrorException("An exception was thrown when trying to update an object with it's optimistic locking version stored in an aggregate: " + this.updateException.toString());
        }
        if (this.forceUpdateException != null) {
            throw new TestErrorException("An exception was thrown when trying to use an optimistic read lock on  an object with it's optimistic locking version stored in an aggregate: " + this.forceUpdateException.toString());
        }
        if (this.initialVersion + 1 != this.forcedUpdateVersion) {
            throw new TestErrorException("Forced Updates did not merge the version field into the original.");
        }
        if (this.initialVersion + 2 != this.finalVersion) {
            throw new TestErrorException("Updates did not merge the version field into the original.");
        }
    }

    public void reset() {
        this.rollbackTransaction();
        this.insertException = null;
        this.updateException = null;
        this.forceUpdateException = null;
    }
}

