/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.clientserver;

import java.io.IOException;
import junit.framework.Test;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.testing.framework.TestModel;
import org.eclipse.persistence.testing.framework.TestSuite;
import org.eclipse.persistence.testing.framework.TestSystem;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.models.employee.relational.EmployeeSystem;
import org.eclipse.persistence.testing.models.insurance.InsuranceSystem;
import org.eclipse.persistence.testing.tests.clientserver.ClientEmployeeSystem;
import org.eclipse.persistence.testing.tests.clientserver.ClientLoginTest;
import org.eclipse.persistence.testing.tests.clientserver.ClientServerConcurrentReadingTest_Case1;
import org.eclipse.persistence.testing.tests.clientserver.ClientServerConcurrentReadingTest_Case2;
import org.eclipse.persistence.testing.tests.clientserver.ClientServerConcurrentWriteTest;
import org.eclipse.persistence.testing.tests.clientserver.ClientServerEmployeeSystem;
import org.eclipse.persistence.testing.tests.clientserver.ClientServerExclusiveReadingTest;
import org.eclipse.persistence.testing.tests.clientserver.ClientServerOptimisticLockingTest;
import org.eclipse.persistence.testing.tests.clientserver.ClientServerReadingDeadlockTest;
import org.eclipse.persistence.testing.tests.clientserver.ClientServerReadingNonDeadlockTest;
import org.eclipse.persistence.testing.tests.clientserver.ClientServerSequenceDeadlockTest;
import org.eclipse.persistence.testing.tests.clientserver.ClientServerSequenceDeadlockTest2;
import org.eclipse.persistence.testing.tests.clientserver.ClientServerTest;
import org.eclipse.persistence.testing.tests.clientserver.ClientServerUpdateDeadlockTest;
import org.eclipse.persistence.testing.tests.clientserver.CommunicationFailureTest;
import org.eclipse.persistence.testing.tests.clientserver.ConcurrencyManagerTest;
import org.eclipse.persistence.testing.tests.clientserver.ConcurrentBatchReadingTest;
import org.eclipse.persistence.testing.tests.clientserver.ConcurrentTestRefreshWithOptimisticLocking;
import org.eclipse.persistence.testing.tests.clientserver.ConcurrentTestWithReadLocks;
import org.eclipse.persistence.testing.tests.clientserver.ConnectionPoolSizingTest;
import org.eclipse.persistence.testing.tests.clientserver.DonotAliaseTheTableWhenWeHaveSubSelectExpression;
import org.eclipse.persistence.testing.tests.clientserver.NPEIsThrownWhenWeTryToWriteNullToANullableField;
import org.eclipse.persistence.testing.tests.clientserver.PreBeginTransactionFailureTest;
import org.eclipse.persistence.testing.tests.identitymaps.ConcurrentIdentityMapKeyEnumerationTest;
import org.eclipse.persistence.testing.tests.unitofwork.ConcurrentNewObjectTest;
import org.eclipse.persistence.testing.tests.unitofwork.ConcurrentReadOnInsertTest;
import org.eclipse.persistence.testing.tests.unitofwork.ConcurrentReadOnUpdateWithEarlyTransTest;
import org.eclipse.persistence.testing.tests.unitofwork.ConcurrentRefreshOnCloneTest;
import org.eclipse.persistence.testing.tests.unitofwork.ConcurrentRefreshOnUpdateTest;
import org.eclipse.persistence.testing.tests.unitofwork.LockOnCloneDeadlockAvoidanceTest;
import org.eclipse.persistence.testing.tests.unitofwork.LockOnCloneTest;
import org.eclipse.persistence.testing.tests.unitofwork.NewObjectIdentityTest;
import org.eclipse.persistence.testing.tests.unitofwork.UOWSystem;
import org.eclipse.persistence.testing.tests.unitofwork.UnitOfWorkConcurrentRevertTest;
import org.eclipse.persistence.testing.tests.unitofwork.UnitOfWorkDeleteOrderTest;

public class ClientServerTestModel
extends TestModel {
    public ClientServerTestModel() {
        this.setDescription("This suite tests updating objects through various clients session.");
    }

    public void addRequiredSystems() {
        try {
            this.getSession().getLog().write("WARNING, some JDBC drivers may fail if they are not thread safe." + Helper.cr() + "JDBC-ODBC will not be run for this test." + Helper.cr() + "Oracle OCI may fail." + Helper.cr() + "DB2 IBM JDBC may fail." + Helper.cr());
            this.getSession().getLog().flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.getSession().getLogin().isJDBCODBCBridge()) {
            throw new TestWarningException("JDBC-ODBC cannot support concurrent connections.");
        }
        this.addRequiredSystem(new EmployeeSystem());
        this.addRequiredSystem(new InsuranceSystem());
        this.addRequiredSystem(new ClientServerEmployeeSystem());
        this.addRequiredSystem(new UOWSystem());
    }

    public void addTests() {
        this.addTest((Test)ClientServerTestModel.getClientServerTestSuite());
        this.addTest((Test)this.getClientServerReadingTestSuite());
    }

    public TestSuite getClientServerReadingTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("Reading Tests");
        suite.addTest((Test)new ClientServerExclusiveReadingTest());
        suite.addTest((Test)new ClientServerConcurrentReadingTest_Case1());
        suite.addTest((Test)new ClientServerConcurrentReadingTest_Case2());
        suite.addTest((Test)new ClientServerConcurrentReadingTest_Case2(true));
        suite.addTest((Test)new ClientServerOptimisticLockingTest());
        suite.addTest((Test)new ClientServerReadingDeadlockTest());
        suite.addTest((Test)new ClientServerReadingNonDeadlockTest());
        suite.addTest((Test)new ConcurrentTestWithReadLocks(180000L));
        suite.addTest((Test)new ConcurrentBatchReadingTest(70000L));
        suite.addTest((Test)new ConcurrentTestRefreshWithOptimisticLocking(100000L));
        return suite;
    }

    public static TestSuite getClientServerTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("ClientServerTestSuite");
        suite.addTest((Test)new ClientServerTest());
        suite.addTest((Test)new ConcurrencyManagerTest());
        suite.addTest((Test)new ClientServerConcurrentWriteTest());
        suite.addTest((Test)new ClientServerSequenceDeadlockTest());
        suite.addTest((Test)new ClientServerSequenceDeadlockTest2());
        suite.addTest((Test)new ClientLoginTest());
        suite.addTest((Test)new PreBeginTransactionFailureTest());
        suite.addTest((Test)new NPEIsThrownWhenWeTryToWriteNullToANullableField());
        suite.addTest((Test)new DonotAliaseTheTableWhenWeHaveSubSelectExpression());
        suite.addTest((Test)new ConcurrentIdentityMapKeyEnumerationTest());
        suite.addTest((Test)new ConcurrentReadOnUpdateWithEarlyTransTest());
        suite.addTest((Test)new UnitOfWorkConcurrentRevertTest());
        suite.addTest((Test)new LockOnCloneTest());
        suite.addTest((Test)new LockOnCloneDeadlockAvoidanceTest());
        suite.addTest((Test)new ConcurrentNewObjectTest());
        suite.addTest((Test)new ConcurrentReadOnInsertTest());
        suite.addTest((Test)new ConcurrentRefreshOnUpdateTest());
        suite.addTest((Test)new ConcurrentRefreshOnCloneTest());
        suite.addTest((Test)new NewObjectIdentityTest());
        suite.addTest((Test)new CommunicationFailureTest());
        suite.addTest((Test)new ClientServerUpdateDeadlockTest());
        suite.addTest((Test)new UnitOfWorkDeleteOrderTest());
        suite.addTest((Test)new ConnectionPoolSizingTest());
        return suite;
    }

    public void reset() {
        this.getExecutor().removeConfigureSystem((TestSystem)new ClientEmployeeSystem());
        this.getExecutor().getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }
}

