/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.clientserver;

import java.util.Vector;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.testing.models.employee.domain.Address;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.domain.LargeProject;
import org.eclipse.persistence.testing.models.insurance.Policy;
import org.eclipse.persistence.testing.tests.clientserver.Server1;

public class Reader
extends Thread {
    protected Session clientSession;
    protected Server1 server;
    protected Session session;

    public Reader(Server1 server, Session session) {
        this.server = server;
        this.session = session;
        this.clientSession = server.serverSession.acquireClientSession();
    }

    public void release() {
        this.clientSession.release();
    }

    @Override
    public void run() {
        try {
            Vector emp = this.clientSession.readAllObjects(Employee.class);
            Vector add = this.clientSession.readAllObjects(Address.class);
            Vector pol = this.clientSession.readAllObjects(Policy.class);
            Expression exp = new ExpressionBuilder().get("firstName").like("S%");
            Vector employees = this.clientSession.readAllObjects(Employee.class, exp);
            exp = new ExpressionBuilder().get("street").like("W%");
            Vector address = this.clientSession.readAllObjects(Address.class, exp);
            exp = new ExpressionBuilder().get("budget").greaterThanEqual(4000);
            Vector projects = this.clientSession.readAllObjects(LargeProject.class, exp);
            exp = new ExpressionBuilder().get("policyNumber").equal(4);
            Vector policyNumber = this.clientSession.readAllObjects(Policy.class, exp);
            exp = new ExpressionBuilder().get("maxCoverage").lessThan(2000);
            Vector maxCoverage = this.clientSession.readAllObjects(Policy.class, exp);
        }
        catch (Exception exception) {
            this.server.errorOccured = true;
            exception.printStackTrace(System.out);
        }
    }
}

