/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.flashback;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Vector;
import junit.framework.Test;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.expressions.ExpressionMath;
import org.eclipse.persistence.history.AsOfClause;
import org.eclipse.persistence.history.AsOfSCNClause;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.querykeys.OneToOneQueryKey;
import org.eclipse.persistence.mappings.querykeys.QueryKey;
import org.eclipse.persistence.platform.database.OraclePlatform;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.queries.ValueReadQuery;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestSuite;
import org.eclipse.persistence.testing.framework.UnitTestCase;
import org.eclipse.persistence.testing.models.employee.domain.Address;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.domain.LargeProject;
import org.eclipse.persistence.testing.models.employee.domain.PhoneNumber;
import org.eclipse.persistence.testing.models.employee.domain.Project;
import org.eclipse.persistence.testing.tests.flashback.FlashbackTestModel;

public class FlashbackUnitTestSuite
extends TestSuite {
    public FlashbackUnitTestSuite() {
        this.setDescription("Fast unit testing of the flashback feature.");
    }

    protected Object getSystemChangeNumber() {
        return ((FlashbackTestModel)this.getContainer()).getSystemChangeNumber();
    }

    protected Object getTimestamp() {
        return FlashbackTestModel.getTimestamp();
    }

    protected AsOfClause getAsOfClause() {
        return ((FlashbackTestModel)this.getContainer()).getAsOfClause();
    }

    public void _testAsOfStringLiteralTest() {
        if (this.getSession().getProject().hasGenericHistorySupport()) {
            return;
        }
        ValueReadQuery scnQuery = ((OraclePlatform)this.getSession().getPlatform()).getSystemChangeNumberQuery();
        long sCNNow = ((BigDecimal)this.getSession().executeQuery((DatabaseQuery)scnQuery)).longValue();
        long testSCN = ((Number)this.getAsOfClause().getValue()).longValue();
        ExpressionBuilder builder = new ExpressionBuilder(Employee.class);
        AsOfSCNClause sCNClause = new AsOfSCNClause(builder.value((Object)("" + sCNNow + " - " + (sCNNow - testSCN))));
        ReadAllQuery query = new ReadAllQuery(Employee.class);
        query.setAsOfClause((AsOfClause)sCNClause);
        query.dontMaintainCache();
        Vector result = (Vector)this.getSession().executeQuery((DatabaseQuery)query);
        if (result.size() != 12) {
            throw new TestErrorException("Expected 12 objects, read " + result.size());
        }
    }

    public void _testAsOfParameterTest() {
        ReadAllQuery query = new ReadAllQuery(Employee.class);
        query.dontMaintainCache();
        query.addArgument("ASOFCLAUSE");
        Vector<Object> arguments = new Vector<Object>();
        Object value = this.getAsOfClause().getValue();
        arguments.add(value);
        Expression parameterExp = query.getExpressionBuilder().getParameter("ASOFCLAUSE");
        if (this.getAsOfClause().isAsOfSCNClause()) {
            query.setAsOfClause((AsOfClause)new AsOfSCNClause(parameterExp));
        } else {
            query.setAsOfClause(new AsOfClause(parameterExp));
        }
        Vector result = (Vector)this.getSession().executeQuery((DatabaseQuery)query, arguments);
        if (result.size() != 12) {
            throw new TestErrorException("Expected 12 objects, read " + result.size());
        }
    }

    public void _testAsOfCurrentTimeMillisTest() {
        if (this.getSession().getProject().hasGenericHistorySupport()) {
            return;
        }
        long value = ((Date)this.getSession().executeQuery((DatabaseQuery)new ValueReadQuery("Select SYSDATE from DUAL"))).getTime();
        AsOfClause clause = new AsOfClause(value);
        ReadAllQuery query = new ReadAllQuery(Employee.class);
        query.dontMaintainCache();
        query.setAsOfClause(clause);
        Vector employees = (Vector)this.getSession().executeQuery((DatabaseQuery)query);
    }

    public void _testAsOfCurrentTimeMillisParameterTest() {
        if (this.getSession().getProject().hasGenericHistorySupport()) {
            return;
        }
        long value = ((Date)this.getSession().executeQuery((DatabaseQuery)new ValueReadQuery("Select SYSDATE from DUAL"))).getTime();
        AsOfClause clause = new AsOfClause(new ExpressionBuilder().getParameter("TIME"));
        ReadAllQuery query = new ReadAllQuery(Employee.class);
        query.dontMaintainCache();
        query.setAsOfClause(clause);
        query.addArgument("TIME");
        Vector<Long> arguments = new Vector<Long>();
        arguments.add(new Long(value));
        Vector employees = (Vector)this.getSession().executeQuery((DatabaseQuery)query, arguments);
        if (employees.size() != 0) {
            throw new TestErrorException("Somehow the long value was not converted to a proper timestamp.  Check the SQL against: " + value);
        }
    }

    public void _testAsOfExpressionMathTest() {
        if (!this.getAsOfClause().isAsOfSCNClause()) {
            return;
        }
        ValueReadQuery scnQuery = ((OraclePlatform)this.getSession().getPlatform()).getSystemChangeNumberQuery();
        long sCNNow = ((BigDecimal)this.getSession().executeQuery((DatabaseQuery)scnQuery)).longValue();
        long testSCN = ((BigDecimal)this.getAsOfClause().getValue()).longValue();
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression expression = ExpressionMath.subtract((Expression)builder.value(sCNNow), (Object)builder.value(sCNNow - testSCN));
        ReadAllQuery query = new ReadAllQuery(Employee.class);
        query.setAsOfClause((AsOfClause)new AsOfSCNClause(expression));
        query.dontMaintainCache();
        Vector result = (Vector)this.getSession().executeQuery((DatabaseQuery)query);
        if (result.size() != 12) {
            throw new TestErrorException("Expected 12 objects, read " + result.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _testCacheCorruptedByJoinedAttributeTest() {
        try {
            this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
            ExpressionBuilder project = new ExpressionBuilder(LargeProject.class);
            ExpressionBuilder oldProject = new ExpressionBuilder(LargeProject.class);
            oldProject.asOf(this.getAsOfClause());
            Expression criteria = project.equal((Expression)oldProject).and(oldProject.get("teamLeader").notNull());
            ReadAllQuery query = new ReadAllQuery(LargeProject.class, criteria);
            query.addJoinedAttribute(oldProject.get("teamLeader"));
            Vector projects = (Vector)this.getSession().executeQuery((DatabaseQuery)query);
            for (int i = 0; i < projects.size(); ++i) {
                LargeProject next = (LargeProject)projects.get(i);
                if (next.getTeamLeader() == null) continue;
                throw new TestErrorException("The dynamic query must still return objects as they exist now, even if a joined attribute is added as of a past time.");
            }
        }
        finally {
            this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _testCacheCorruptedByJoinedAttribute2Test() {
        try {
            this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
            ExpressionBuilder project = new ExpressionBuilder(LargeProject.class);
            Expression criteria = project.get("teamLeader").asOf(this.getAsOfClause()).notNull();
            ReadAllQuery query = new ReadAllQuery(LargeProject.class, criteria);
            query.addJoinedAttribute("teamLeader");
            Vector projects = (Vector)this.getSession().executeQuery((DatabaseQuery)query);
            for (int i = 0; i < projects.size(); ++i) {
                LargeProject next = (LargeProject)projects.get(i);
                if (next.getTeamLeader() == null) continue;
                throw new TestErrorException("The dynamic query must still return objects as they exist now, even if a joined attribute is added on an attribute read as of a past time.");
            }
        }
        finally {
            this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _testCacheCorruptedByBatchAttributeTest() {
        try {
            this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
            ExpressionBuilder project = new ExpressionBuilder(LargeProject.class);
            Expression criteria = project.get("teamLeader").asOf(this.getAsOfClause()).notNull();
            ReadAllQuery query = new ReadAllQuery(LargeProject.class, criteria);
            query.addBatchReadAttribute("teamLeader");
            Vector projects = (Vector)this.getSession().executeQuery((DatabaseQuery)query);
            for (int i = 0; i < projects.size(); ++i) {
                LargeProject next = (LargeProject)projects.get(i);
                if (next.getTeamLeader() == null) continue;
                throw new TestErrorException("The dynamic query must still return objects as they exist now, even if a batched attribute is added on an attribute read as of a past time.");
            }
        }
        finally {
            this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _testCacheIsolationTest() {
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        Session hs = this.getSession().acquireHistoricalSession(this.getAsOfClause());
        try {
            hs.readAllObjects(Employee.class);
            Vector employees = ((AbstractSession)this.getSession()).getIdentityMapAccessorInstance().getAllFromIdentityMap(null, Employee.class, null);
            if (employees != null && employees.size() > 0) {
                throw new TestErrorException("" + employees.size() + " objects read in a HistoricalSession were cached in the global session.");
            }
        }
        finally {
            hs.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _testCacheIsolationAcrossRelationshipsTest() {
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        Session hs = this.getSession().acquireHistoricalSession(this.getAsOfClause());
        try {
            Vector pastEmployees = hs.readAllObjects(Employee.class);
            for (int i = 0; i < pastEmployees.size(); ++i) {
                Employee employee = (Employee)pastEmployees.get(i);
                employee.getProjects();
                employee.getAddress();
                employee.getPhoneNumbers();
            }
            Vector projects = ((AbstractSession)this.getSession()).getIdentityMapAccessorInstance().getAllFromIdentityMap(null, Project.class, null);
            Vector addresses = ((AbstractSession)this.getSession()).getIdentityMapAccessorInstance().getAllFromIdentityMap(null, Address.class, null);
            Vector phoneNumbers = ((AbstractSession)this.getSession()).getIdentityMapAccessorInstance().getAllFromIdentityMap(null, PhoneNumber.class, null);
            if (projects.size() > 0 || addresses.size() > 0 || phoneNumbers.size() > 0) {
                throw new TestErrorException("" + projects.size() + " projects, " + addresses.size() + " addresses, and " + phoneNumbers.size() + " phone numbers read in a HistoricalSession were cached in the global session.");
            }
        }
        finally {
            hs.release();
        }
    }

    /*
     * Exception decompiling
     */
    public void _testCannotExecuteWriteInHistoricalSessionExceptionTest() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _testDynamicQueryUsingParallelExpressionTest() {
        try {
            this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
            ExpressionBuilder project = new ExpressionBuilder(LargeProject.class);
            ExpressionBuilder oldProject = new ExpressionBuilder(LargeProject.class);
            oldProject.asOf(this.getAsOfClause());
            Expression criteria = project.equal((Expression)oldProject).and(oldProject.get("teamLeader").notNull());
            Vector projects = this.getSession().readAllObjects(LargeProject.class, criteria);
            if (projects.size() != 3) {
                throw new TestErrorException("Expected to read 6 projects, instead read: " + projects.size());
            }
            for (int i = 0; i < projects.size(); ++i) {
                LargeProject next = (LargeProject)projects.get(i);
                if (next.getTeamLeader() == null) continue;
                throw new TestErrorException("The dynamic query must still return objects as they exist now.");
            }
        }
        finally {
            this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _testDynamicQueryUsingQueryKeyTest() {
        try {
            this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
            ExpressionBuilder builder = new ExpressionBuilder(LargeProject.class);
            Expression joinCriteria = builder.getField("PROJECT.PROJ_ID").equal(builder.getParameter("PROJECT.PROJ_ID"));
            OneToOneQueryKey self = new OneToOneQueryKey();
            self.setName("this");
            self.setJoinCriteria(joinCriteria);
            self.setReferenceClass(LargeProject.class);
            this.getSession().getDescriptor(LargeProject.class).addQueryKey((QueryKey)self);
            ExpressionBuilder project = new ExpressionBuilder(LargeProject.class);
            Expression oldProject = project.get("this");
            oldProject.asOf(this.getAsOfClause());
            Expression criteria = oldProject.get("teamLeader").notNull();
            Vector projects = this.getSession().readAllObjects(LargeProject.class, criteria);
            if (projects.size() != 3) {
                throw new TestErrorException("Expected to read 6 projects, instead read: " + projects.size());
            }
            for (int i = 0; i < projects.size(); ++i) {
                LargeProject next = (LargeProject)projects.get(i);
                if (next.getTeamLeader() == null) continue;
                throw new TestErrorException("The dynamic query must still return objects as they exist now.");
            }
        }
        finally {
            this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        }
    }

    /*
     * Exception decompiling
     */
    public void _testNoNestedHistoricalSessionsAllowedExceptionTest() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void _testNoTransactionsInHistoricalSessionExceptionTest() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [10[CATCHBLOCK]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void _testParameterBindingTest() {
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression expression = builder.get("firstName").equal(builder.getParameter("FIRSTNAME"));
        Vector<String> arguments = new Vector<String>();
        arguments.add("Bob");
        ReadObjectQuery query = new ReadObjectQuery(Employee.class);
        query.setAsOfClause(this.getAsOfClause());
        query.dontMaintainCache();
        query.addArgument("FIRSTNAME");
        Employee result = (Employee)this.getSession().executeQuery((DatabaseQuery)query, arguments);
        if (!result.getFirstName().equals("Bob")) {
            throw new TestErrorException("Expected Bob, read " + result);
        }
        arguments.set(0, "Sarah");
        result = (Employee)this.getSession().executeQuery((DatabaseQuery)query, arguments);
        if (!result.getFirstName().equals("Sarah")) {
            throw new TestErrorException("Expected Sarah, read " + result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _testSuccessfulCachingTest() {
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        Session hs = this.getSession().acquireHistoricalSession(this.getAsOfClause());
        try {
            Employee pastManager = (Employee)hs.readObject(Employee.class, new ExpressionBuilder().anyOf("managedEmployees").get("id").greaterThan(0));
            Vector employees = pastManager.getManagedEmployees();
            for (int i = 0; i < employees.size(); ++i) {
                Employee employee = (Employee)employees.get(i);
                if (employee.getManager() == pastManager) continue;
                throw new TestErrorException("Objects read in a HistoricalSession are not being cached properly by identity.");
            }
        }
        finally {
            hs.release();
        }
    }

    public void _testOuterJoinTest() {
        this.internalOuterJoinTest(true);
    }

    public void _testOuterJoinTestWithoutAsOf() {
        this.internalOuterJoinTest(false);
    }

    void internalOuterJoinTest(boolean withAsOf) {
        int expectedSize;
        ReadAllQuery query = new ReadAllQuery(LargeProject.class);
        ExpressionBuilder builder = query.getExpressionBuilder();
        Expression expression = builder.getAllowingNull("teamLeader").get("firstName").equal((Object)"Sarah");
        expression = expression.or(builder.get("name").equal((Object)"TOPEmployee Management"));
        query.setSelectionCriteria(expression);
        query.dontMaintainCache();
        if (withAsOf) {
            query.setAsOfClause(this.getAsOfClause());
        }
        Vector result = (Vector)this.getSession().executeQuery((DatabaseQuery)query);
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        int n = expectedSize = withAsOf ? 2 : 1;
        if (result == null || result.size() != expectedSize) {
            throw new TestErrorException("Expected " + expectedSize + " objects, read " + result.size());
        }
    }

    public void _testHistoricalQueriesMustPreserveGlobalCacheExceptionTest() {
        ReadAllQuery query = new ReadAllQuery(Employee.class);
        query.setSelectionCriteria(query.getExpressionBuilder().get("firstName").equal((Object)"Bob"));
        query.setAsOfClause((AsOfClause)new AsOfSCNClause(new Long(0L)));
        try {
            this.getSession().executeQuery((DatabaseQuery)query);
            this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
            throw new TestErrorException("Exception not thrown in reading past versions of objects into the global cache.");
        }
        catch (QueryException qe) {
            if (qe.getErrorCode() != 6101) {
                throw new TestErrorException("Wrong exception thrown.", (Throwable)qe);
            }
        }
        catch (TestErrorException tee) {
            throw tee;
        }
        catch (Exception e) {
            throw new TestErrorException("Exception not thrown in reading past versions of objects into the global cache.  Instead triggered: ", (Throwable)e);
        }
    }

    public void _testHistoricalQueriesOnlySupportedOnOracleExceptionTest() {
        boolean genericHistory = this.getSession().getProject().hasGenericHistorySupport();
        ReadAllQuery query = new ReadAllQuery(Employee.class);
        query.setSelectionCriteria(query.getExpressionBuilder().get("firstName").equal((Object)"Bob"));
        query.setAsOfClause(this.getAsOfClause());
        query.dontMaintainCache();
        DatabaseLogin oldLogin = this.getSession().getLogin();
        DatabaseLogin newLogin = (DatabaseLogin)oldLogin.clone();
        newLogin.useAccess();
        try {
            this.getAbstractSession().setLogin(newLogin);
            this.getSession().executeQuery((DatabaseQuery)query);
            this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
            if (!genericHistory) {
                throw new TestErrorException("Exception not thrown in reading past versions of objects outside of Oracle.");
            }
        }
        catch (QueryException qe) {
            if (qe.getErrorCode() != 6102) {
                throw new TestErrorException("Wrong exception thrown.", (Throwable)qe);
            }
        }
        catch (TestErrorException tee) {
            throw tee;
        }
        catch (Exception e) {
            throw new TestErrorException("Exception not thrown in reading past versions of objects outside of Oracle.  Instead triggered: " + e.toString(), (Throwable)e);
        }
        finally {
            this.getAbstractSession().setLogin(oldLogin);
        }
    }

    /*
     * Exception decompiling
     */
    public void _testHistoricalSessionOnlySupportedOnOracleExceptionTest() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void addTests() {
        this.addTest((Test)new UnitTestCase("AsOfCurrentTimeMillisTest"));
        this.addTest((Test)new UnitTestCase("AsOfExpressionMathTest"));
        this.addTest((Test)new UnitTestCase("AsOfParameterTest"));
        this.addTest((Test)new UnitTestCase("AsOfStringLiteralTest"));
        this.addTest((Test)new UnitTestCase("CacheCorruptedByBatchAttributeTest"));
        this.addTest((Test)new UnitTestCase("CacheIsolationTest"));
        this.addTest((Test)new UnitTestCase("CacheIsolationAcrossRelationshipsTest"));
        this.addTest((Test)new UnitTestCase("CannotExecuteWriteInHistoricalSessionExceptionTest"));
        this.addTest((Test)new UnitTestCase("DynamicQueryUsingQueryKeyTest"));
        this.addTest((Test)new UnitTestCase("DynamicQueryUsingParallelExpressionTest"));
        this.addTest((Test)new UnitTestCase("NoNestedHistoricalSessionsAllowedExceptionTest"));
        this.addTest((Test)new UnitTestCase("NoTransactionsInHistoricalSessionExceptionTest"));
        this.addTest((Test)new UnitTestCase("SuccessfulCachingTest"));
        this.addTest((Test)new UnitTestCase("OuterJoinTest"));
        this.addTest((Test)new UnitTestCase("OuterJoinTestWithoutAsOf"));
        this.addTest((Test)new UnitTestCase("HistoricalQueriesMustPreserveGlobalCacheExceptionTest"));
        this.addTest((Test)new UnitTestCase("HistoricalQueriesOnlySupportedOnOracleExceptionTest"));
        this.addTest((Test)new UnitTestCase("HistoricalSessionOnlySupportedOnOracleExceptionTest"));
    }
}

