/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.inheritance;

import java.util.Vector;
import junit.framework.Test;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.testing.framework.DeleteObjectTest;
import org.eclipse.persistence.testing.framework.InsertObjectTest;
import org.eclipse.persistence.testing.framework.ReadAllTest;
import org.eclipse.persistence.testing.framework.ReadObjectTest;
import org.eclipse.persistence.testing.framework.TestModel;
import org.eclipse.persistence.testing.framework.TestSuite;
import org.eclipse.persistence.testing.framework.UnitOfWorkBasicUpdateObjectTest;
import org.eclipse.persistence.testing.framework.WriteObjectTest;
import org.eclipse.persistence.testing.models.inheritance.A_King2;
import org.eclipse.persistence.testing.models.inheritance.Alligator;
import org.eclipse.persistence.testing.models.inheritance.Animal_Matt;
import org.eclipse.persistence.testing.models.inheritance.Bicycle;
import org.eclipse.persistence.testing.models.inheritance.Boat;
import org.eclipse.persistence.testing.models.inheritance.Bus;
import org.eclipse.persistence.testing.models.inheritance.Car;
import org.eclipse.persistence.testing.models.inheritance.Cat;
import org.eclipse.persistence.testing.models.inheritance.Company;
import org.eclipse.persistence.testing.models.inheritance.Computer;
import org.eclipse.persistence.testing.models.inheritance.Developer_King;
import org.eclipse.persistence.testing.models.inheritance.Dog;
import org.eclipse.persistence.testing.models.inheritance.Engineer;
import org.eclipse.persistence.testing.models.inheritance.FueledVehicle;
import org.eclipse.persistence.testing.models.inheritance.IBMPC;
import org.eclipse.persistence.testing.models.inheritance.InheritanceSystem;
import org.eclipse.persistence.testing.models.inheritance.Mac;
import org.eclipse.persistence.testing.models.inheritance.Mainframe;
import org.eclipse.persistence.testing.models.inheritance.NonFueledVehicle;
import org.eclipse.persistence.testing.models.inheritance.PC;
import org.eclipse.persistence.testing.models.inheritance.Person;
import org.eclipse.persistence.testing.models.inheritance.SalesRep;
import org.eclipse.persistence.testing.models.inheritance.SeniorDeveloper_King;
import org.eclipse.persistence.testing.models.inheritance.SoftwareEngineer;
import org.eclipse.persistence.testing.models.inheritance.SportsCar;
import org.eclipse.persistence.testing.models.inheritance.Vehicle;
import org.eclipse.persistence.testing.tests.inheritance.BindingWithShallowInsertTest;
import org.eclipse.persistence.testing.tests.inheritance.CursoredStreamInheritanceTestCase;
import org.eclipse.persistence.testing.tests.inheritance.InfiniteRecursionWithNoDescriptorTest;
import org.eclipse.persistence.testing.tests.inheritance.JoinWithSecondaryTableTest;
import org.eclipse.persistence.testing.tests.inheritance.LeafQueryTest;
import org.eclipse.persistence.testing.tests.inheritance.NestedUnitOfWorkMergeIntoParentTest;
import org.eclipse.persistence.testing.tests.inheritance.OverrideInheritedMappingTest;
import org.eclipse.persistence.testing.tests.inheritance.PaginationInheritanceTest;
import org.eclipse.persistence.testing.tests.inheritance.QueryInheritanceTest;
import org.eclipse.persistence.testing.tests.inheritance.ReinitializeJoiningOnClassDescriptorWithInheritanceTest;
import org.eclipse.persistence.testing.tests.inheritance.SecondaryTableUpdateTest;
import org.eclipse.persistence.testing.tests.inheritance.SingleInheritanceTest;
import org.eclipse.persistence.testing.tests.inheritance.TranslatedKeyInheritanceTestCase;
import org.eclipse.persistence.testing.tests.inheritance.UnitOfWorkCommitResumeTest;
import org.eclipse.persistence.testing.tests.inheritance.UnitOfWorkIdentityMapAccessorTest;
import org.eclipse.persistence.testing.tests.inheritance.UnitOfWorkTest;
import org.eclipse.persistence.testing.tests.writing.ComplexDeleteTest;
import org.eclipse.persistence.tools.schemaframework.PopulationManager;

public class InheritanceTestModel
extends TestModel {
    public InheritanceTestModel() {
    }

    public InheritanceTestModel(boolean isSRG) {
        this();
        this.isSRG = isSRG;
    }

    public void addRequiredSystems() {
        this.addRequiredSystem(new InheritanceSystem());
    }

    public void addTests() {
        this.addTest((Test)InheritanceTestModel.getDuplicateFieldTestSuite());
        this.addTest((Test)InheritanceTestModel.getReadObjectTestSuite());
        this.addTest((Test)InheritanceTestModel.getReadAllTestSuite());
        this.addTest((Test)InheritanceTestModel.getDeleteObjectTestSuite());
        this.addTest((Test)InheritanceTestModel.getInsertObjectTestSuite());
        this.addTest((Test)InheritanceTestModel.getUpdateObjectTestSuite());
        this.addTest((Test)InheritanceTestModel.getUnitOfWorkTestSuite());
        this.addTest((Test)InheritanceTestModel.getUnitOfWorkCommitResumeTestSuite());
        this.addTest((Test)InheritanceTestModel.getDeepInheritanceTestSuite());
        this.addTest((Test)InheritanceTestModel.getTranslatedKeyInheritanceTestSuite());
        this.addTest((Test)InheritanceTestModel.getSingleInheritanceTestSuite());
        this.addTest((Test)new CursoredStreamInheritanceTestCase());
        this.addTest((Test)new ReinitializeJoiningOnClassDescriptorWithInheritanceTest());
        this.addTest((Test)new UnitOfWorkIdentityMapAccessorTest());
        this.addTest((Test)new NestedUnitOfWorkMergeIntoParentTest());
    }

    public void addSRGTests() {
        this.addTest((Test)InheritanceTestModel.getSRGDuplicateFieldTestSuite());
        this.addTest((Test)InheritanceTestModel.getSRGReadObjectTestSuite());
        this.addTest((Test)InheritanceTestModel.getSRGReadAllTestSuite());
        this.addTest((Test)InheritanceTestModel.getSRGDeleteObjectTestSuite());
        this.addTest((Test)InheritanceTestModel.getSRGInsertObjectTestSuite());
        this.addTest((Test)InheritanceTestModel.getSRGUpdateObjectTestSuite());
        this.addTest((Test)InheritanceTestModel.getSRGUnitOfWorkTestSuite());
        this.addTest((Test)InheritanceTestModel.getSRGUnitOfWorkCommitResumeTestSuite());
        this.addTest((Test)InheritanceTestModel.getSRGDeepInheritanceTestSuite());
        this.addTest((Test)InheritanceTestModel.getSRGTranslatedKeyInheritanceTestSuite());
        this.addTest((Test)InheritanceTestModel.getSRGSingleInheritanceTestSuite());
    }

    public static TestSuite getDeepInheritanceTestSuite() {
        TestSuite suite = InheritanceTestModel.getSRGDeepInheritanceTestSuite();
        return suite;
    }

    public static TestSuite getSRGDeepInheritanceTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("Deep Inheritance Tests");
        suite.addTest((Test)new LeafQueryTest());
        suite.addTest((Test)new SecondaryTableUpdateTest());
        return suite;
    }

    public static TestSuite getDeleteObjectTestSuite() {
        TestSuite suite = InheritanceTestModel.getSRGDeleteObjectTestSuite();
        return suite;
    }

    public static TestSuite getSRGDeleteObjectTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("InheritanceDeleteObjectTestSuite");
        suite.setDescription("This suite tests the deletion of each object in the inheritance model.");
        PopulationManager manager = PopulationManager.getDefaultManager();
        suite.addTest((Test)new DeleteObjectTest(manager.getObject(Cat.class, "catExample1")));
        suite.addTest((Test)new DeleteObjectTest(manager.getObject(Dog.class, "dogExample1")));
        suite.addTest((Test)new DeleteObjectTest(manager.getObject(Cat.class, "catExample2")));
        suite.addTest((Test)new DeleteObjectTest(manager.getObject(Dog.class, "dogExample2")));
        suite.addTest((Test)new DeleteObjectTest(manager.getObject(Cat.class, "catExample3")));
        suite.addTest((Test)new DeleteObjectTest(manager.getObject(Dog.class, "dogExample3")));
        suite.addTest((Test)new DeleteObjectTest(manager.getObject(Person.class, "example1")));
        suite.addTest((Test)new DeleteObjectTest(manager.getObject(SalesRep.class, "example3")));
        suite.addTest((Test)new DeleteObjectTest(manager.getObject(Company.class, "example1")));
        suite.addTest((Test)new DeleteObjectTest(manager.getObject(Company.class, "example2")));
        suite.addTest((Test)new DeleteObjectTest(manager.getObject(Company.class, "example3")));
        suite.addTest((Test)new DeleteObjectTest(manager.getObject(Mac.class, "example1")));
        suite.addTest((Test)new DeleteObjectTest(manager.getObject(IBMPC.class, "example2")));
        suite.addTest((Test)new DeleteObjectTest(manager.getObject(IBMPC.class, "example3")));
        suite.addTest((Test)new DeleteObjectTest(manager.getObject(PC.class, "example4")));
        suite.addTest((Test)new DeleteObjectTest(manager.getObject(Mainframe.class, "example5")));
        Vector<Animal_Matt> dependants = new Vector<Animal_Matt>(1);
        Alligator alligator = (Alligator)manager.getObject(Alligator.class, "example1");
        dependants.add(alligator.getLatestVictim());
        suite.addTest((Test)new ComplexDeleteTest(alligator, dependants));
        return suite;
    }

    public static TestSuite getDuplicateFieldTestSuite() {
        TestSuite suite = InheritanceTestModel.getSRGDuplicateFieldTestSuite();
        return suite;
    }

    public static TestSuite getSRGDuplicateFieldTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("InheritanceDuplicateFieldTestSuite");
        suite.setDescription("This suite tests ther read from the root class generated duplicate filed in SQL in the inheritance model.");
        ReadAllTest rs = new ReadAllTest(A_King2.class, 5);
        ReadAllQuery rq = new ReadAllQuery(A_King2.class);
        rq.addAscendingOrdering("foo");
        rs.setQuery(rq);
        suite.addTest((Test)rs);
        return suite;
    }

    public static TestSuite getInsertObjectTestSuite() {
        TestSuite suite = InheritanceTestModel.getSRGInsertObjectTestSuite();
        return suite;
    }

    public static TestSuite getSRGInsertObjectTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("InheritanceInsertObjectTestSuite");
        suite.setDescription("This suite tests the insertion of each object in the inheritance model.");
        suite.addTest((Test)new InsertObjectTest((Object)Cat.example4()));
        suite.addTest((Test)new InsertObjectTest((Object)Dog.example4()));
        suite.addTest((Test)new InsertObjectTest((Object)Company.example1()));
        suite.addTest((Test)new InsertObjectTest((Object)Company.example2()));
        suite.addTest((Test)new InsertObjectTest((Object)Company.example3()));
        suite.addTest((Test)new InsertObjectTest((Object)Person.example1()));
        suite.addTest((Test)new InsertObjectTest((Object)Person.example3()));
        suite.addTest((Test)new InsertObjectTest((Object)Person.example6()));
        suite.addTest((Test)new InsertObjectTest((Object)Car.example1()));
        suite.addTest((Test)new InsertObjectTest((Object)Car.example2()));
        suite.addTest((Test)new InsertObjectTest((Object)Car.example3()));
        suite.addTest((Test)new InsertObjectTest((Object)Car.example4()));
        suite.addTest((Test)new InsertObjectTest((Object)Computer.example1()));
        suite.addTest((Test)new InsertObjectTest((Object)Computer.example2()));
        suite.addTest((Test)new InsertObjectTest((Object)Computer.example3()));
        suite.addTest((Test)new InsertObjectTest((Object)Computer.example4()));
        suite.addTest((Test)new InsertObjectTest((Object)Computer.example5()));
        suite.addTest((Test)new InsertObjectTest((Object)Developer_King.exp2()));
        suite.addTest((Test)new InsertObjectTest((Object)Developer_King.exp3()));
        suite.addTest((Test)new InsertObjectTest((Object)SeniorDeveloper_King.exp4()));
        suite.addTest((Test)new OverrideInheritedMappingTest());
        suite.addTest((Test)new BindingWithShallowInsertTest());
        return suite;
    }

    public static TestSuite getReadAllTestSuite() {
        TestSuite suite = InheritanceTestModel.getSRGReadAllTestSuite();
        suite.addTest((Test)new QueryInheritanceTest());
        suite.addTest((Test)new JoinWithSecondaryTableTest());
        suite.addTest((Test)new PaginationInheritanceTest());
        return suite;
    }

    public static TestSuite getSRGReadAllTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("InheritanceReadAllTestSuite");
        suite.setDescription("This suite tests the reading of all the objects of each class in the inheritance model.");
        suite.addTest((Test)new ReadAllTest(Cat.class, 3));
        suite.addTest((Test)new ReadAllTest(Dog.class, 3));
        suite.addTest((Test)new ReadAllTest(Company.class, 3));
        suite.addTest((Test)new ReadAllTest(Person.class, 1));
        suite.addTest((Test)new ReadAllTest(SalesRep.class, 2));
        suite.addTest((Test)new ReadAllTest(Engineer.class, 2));
        suite.addTest((Test)new ReadAllTest(SoftwareEngineer.class, 1));
        suite.addTest((Test)new ReadAllTest(Computer.class, 5));
        suite.addTest((Test)new ReadAllTest(PC.class, 4));
        suite.addTest((Test)new ReadAllTest(IBMPC.class, 2));
        suite.addTest((Test)new ReadAllTest(Mac.class, 1));
        suite.addTest((Test)new ReadAllTest(Mainframe.class, 1));
        suite.addTest((Test)new ReadAllTest(Car.class, 4));
        suite.addTest((Test)new ReadAllTest(SportsCar.class, 1));
        suite.addTest((Test)new ReadAllTest(Bus.class, 4));
        suite.addTest((Test)new ReadAllTest(Bicycle.class, 3));
        suite.addTest((Test)new ReadAllTest(Boat.class, 4));
        suite.addTest((Test)new ReadAllTest(Vehicle.class, 19));
        suite.addTest((Test)new ReadAllTest(NonFueledVehicle.class, 10));
        suite.addTest((Test)new ReadAllTest(FueledVehicle.class, 1));
        suite.addTest((Test)new ReadAllTest(A_King2.class, 5));
        return suite;
    }

    public static TestSuite getReadObjectTestSuite() {
        TestSuite suite = InheritanceTestModel.getSRGReadObjectTestSuite();
        return suite;
    }

    public static TestSuite getSRGReadObjectTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("InheritanceReadObjectTestSuite");
        suite.setDescription("This suite test the reading of each object in the inheritance model.");
        PopulationManager manager = PopulationManager.getDefaultManager();
        suite.addTest((Test)new ReadObjectTest(manager.getObject(Cat.class, "catExample1")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(Dog.class, "dogExample1")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(Cat.class, "catExample2")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(Dog.class, "dogExample2")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(Cat.class, "catExample3")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(Dog.class, "dogExample3")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(Company.class, "example1")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(Company.class, "example2")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(Company.class, "example3")));
        Bus bus = (Bus)manager.getObject(Bus.class, "example1");
        ReadObjectTest test = new ReadObjectTest((Object)bus);
        test.setQuery(new ReadObjectQuery(Vehicle.class, new ExpressionBuilder().get("id").equal((Object)bus.id)));
        suite.addTest((Test)test);
        suite.addTest((Test)new ReadObjectTest(manager.getObject(Person.class, "example1")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(Engineer.class, "example2")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(SalesRep.class, "example4")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(SoftwareEngineer.class, "example5")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(SalesRep.class, "example3")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(PC.class, "example4")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(IBMPC.class, "example3")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(IBMPC.class, "example2")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(Mac.class, "example1")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(Mainframe.class, "example5")));
        return suite;
    }

    public static TestSuite getTranslatedKeyInheritanceTestSuite() {
        TestSuite suite = InheritanceTestModel.getSRGTranslatedKeyInheritanceTestSuite();
        return suite;
    }

    public static TestSuite getSRGTranslatedKeyInheritanceTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("TranslatedKeyInheritance");
        suite.setDescription("Test when a subclass has a key different from the superclass");
        suite.addTest((Test)new TranslatedKeyInheritanceTestCase());
        return suite;
    }

    public static TestSuite getUnitOfWorkCommitResumeTestSuite() {
        TestSuite suite = InheritanceTestModel.getSRGUnitOfWorkCommitResumeTestSuite();
        return suite;
    }

    public static TestSuite getSRGUnitOfWorkCommitResumeTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("InheritanceUnitOfWorkCommitResumeTestSuite");
        suite.setDescription("This suite tests updating objects with UOW in the inheritance model using the commitAndResume method.");
        PopulationManager manager = PopulationManager.getDefaultManager();
        suite.addTest((Test)new UnitOfWorkCommitResumeTest(manager.getObject(Company.class, "example1")));
        suite.addTest((Test)new UnitOfWorkCommitResumeTest(manager.getObject(Company.class, "example2")));
        suite.addTest((Test)new UnitOfWorkCommitResumeTest(manager.getObject(Company.class, "example3")));
        return suite;
    }

    public static TestSuite getUnitOfWorkTestSuite() {
        TestSuite suite = InheritanceTestModel.getSRGUnitOfWorkTestSuite();
        suite.addTest((Test)new InfiniteRecursionWithNoDescriptorTest());
        return suite;
    }

    public static TestSuite getSRGUnitOfWorkTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("InheritanceUnitOfWorkTestSuite");
        suite.setDescription("This suite tests updating objects with UOW in the inheritance model.");
        PopulationManager manager = PopulationManager.getDefaultManager();
        suite.addTest((Test)new UnitOfWorkTest(manager.getObject(Company.class, "example1")));
        suite.addTest((Test)new UnitOfWorkTest(manager.getObject(Company.class, "example2")));
        suite.addTest((Test)new UnitOfWorkTest(manager.getObject(Company.class, "example3")));
        return suite;
    }

    public static TestSuite getUpdateObjectTestSuite() {
        TestSuite suite = InheritanceTestModel.getSRGUpdateObjectTestSuite();
        return suite;
    }

    public static TestSuite getSRGUpdateObjectTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("InheritanceUpdateObjectTestSuite");
        suite.setDescription("This suite tests the updating of each object in the inheritance model.");
        Class<Company> companyClass = Company.class;
        Class<Person> personClass = Person.class;
        PopulationManager manager = PopulationManager.getDefaultManager();
        suite.addTest((Test)new WriteObjectTest(manager.getObject(Cat.class, "catExample1")));
        suite.addTest((Test)new UnitOfWorkBasicUpdateObjectTest(manager.getObject(Cat.class, "catExample1")));
        suite.addTest((Test)new WriteObjectTest(manager.getObject(Dog.class, "dogExample1")));
        suite.addTest((Test)new UnitOfWorkBasicUpdateObjectTest(manager.getObject(Dog.class, "dogExample1")));
        suite.addTest((Test)new UnitOfWorkBasicUpdateObjectTest(manager.getObject(Cat.class, "catExample2")));
        suite.addTest((Test)new UnitOfWorkBasicUpdateObjectTest(manager.getObject(Dog.class, "dogExample2")));
        suite.addTest((Test)new UnitOfWorkBasicUpdateObjectTest(manager.getObject(Cat.class, "catExample3")));
        suite.addTest((Test)new UnitOfWorkBasicUpdateObjectTest(manager.getObject(Dog.class, "dogExample3")));
        suite.addTest((Test)new WriteObjectTest(manager.getObject(companyClass, "example1")));
        suite.addTest((Test)new UnitOfWorkBasicUpdateObjectTest(manager.getObject(companyClass, "example1")));
        suite.addTest((Test)new UnitOfWorkBasicUpdateObjectTest(manager.getObject(companyClass, "example2")));
        suite.addTest((Test)new UnitOfWorkBasicUpdateObjectTest(manager.getObject(companyClass, "example3")));
        suite.addTest((Test)new WriteObjectTest(manager.getObject(personClass, "example1")));
        suite.addTest((Test)new UnitOfWorkBasicUpdateObjectTest(manager.getObject(personClass, "example1")));
        suite.addTest((Test)new WriteObjectTest(manager.getObject(Engineer.class, "example2")));
        suite.addTest((Test)new UnitOfWorkBasicUpdateObjectTest(manager.getObject(Engineer.class, "example2")));
        suite.addTest((Test)new WriteObjectTest(manager.getObject(SalesRep.class, "example3")));
        suite.addTest((Test)new UnitOfWorkBasicUpdateObjectTest(manager.getObject(SalesRep.class, "example3")));
        suite.addTest((Test)new WriteObjectTest(manager.getObject(Mac.class, "example1")));
        suite.addTest((Test)new UnitOfWorkBasicUpdateObjectTest(manager.getObject(Mac.class, "example1")));
        suite.addTest((Test)new WriteObjectTest(manager.getObject(IBMPC.class, "example2")));
        suite.addTest((Test)new UnitOfWorkBasicUpdateObjectTest(manager.getObject(IBMPC.class, "example2")));
        suite.addTest((Test)new UnitOfWorkBasicUpdateObjectTest(manager.getObject(IBMPC.class, "example3")));
        suite.addTest((Test)new WriteObjectTest(manager.getObject(PC.class, "example4")));
        suite.addTest((Test)new UnitOfWorkBasicUpdateObjectTest(manager.getObject(PC.class, "example4")));
        suite.addTest((Test)new WriteObjectTest(manager.getObject(Mainframe.class, "example5")));
        suite.addTest((Test)new UnitOfWorkBasicUpdateObjectTest(manager.getObject(Mainframe.class, "example5")));
        return suite;
    }

    public static TestSuite getSingleInheritanceTestSuite() {
        TestSuite suite = InheritanceTestModel.getSRGSingleInheritanceTestSuite();
        return suite;
    }

    public static TestSuite getSRGSingleInheritanceTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("SingleInheritanceTestSuite");
        suite.setDescription("This suite tests an inheritance model containing only a single class .");
        PopulationManager manager = PopulationManager.getDefaultManager();
        suite.addTest((Test)new SingleInheritanceTest());
        return suite;
    }
}

