/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.insurance;

import java.util.Vector;
import junit.framework.Test;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.testing.framework.TestSuite;
import org.eclipse.persistence.testing.framework.TestSystem;
import org.eclipse.persistence.testing.framework.WriteObjectTest;
import org.eclipse.persistence.testing.models.insurance.Claim;
import org.eclipse.persistence.testing.models.insurance.HousePolicy;
import org.eclipse.persistence.testing.models.insurance.InsuranceSystem;
import org.eclipse.persistence.testing.models.insurance.Policy;
import org.eclipse.persistence.testing.models.insurance.PolicyHolder;
import org.eclipse.persistence.testing.models.insurance.objectrelational.InsuranceORSystem;
import org.eclipse.persistence.testing.tests.expressions.ReadAllExpressionTest;
import org.eclipse.persistence.testing.tests.insurance.InsuranceBasicTestModel;
import org.eclipse.persistence.testing.tests.insurance.ObjectArrayMappingUpdateTest;

public class InsuranceObjectRelationalTestModel
extends InsuranceBasicTestModel {
    @Override
    public void addRequiredSystems() {
        this.getDatabaseSession().logout();
        this.getDatabaseSession().login();
        if (this.getSession().getPlatform().isOracle9()) {
            this.addRequiredSystem(new InsuranceORSystem());
        }
    }

    @Override
    public void addTests() {
        if (this.getSession().getPlatform().isOracle9()) {
            super.addTests();
            this.addTest((Test)InsuranceObjectRelationalTestModel.getNestedTablesReadObjectTestSuite());
            this.addTest((Test)InsuranceObjectRelationalTestModel.getObjectArrayUpdateTestSuite());
            this.addTest((Test)InsuranceObjectRelationalTestModel.getNullUpdatesTestSuite());
        }
    }

    protected static TestSuite getNestedTablesReadObjectTestSuite() {
        TestSuite testSuite = new TestSuite();
        testSuite.setName("NestedTablesReadObjectTestSuite");
        testSuite.setDescription("nested tables read test");
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression exp1 = builder.anyOf("policies").get("maxCoverage").greaterThan(30000);
        ReadAllExpressionTest test1 = new ReadAllExpressionTest(PolicyHolder.class, 4);
        test1.setName("nested tables read test (PolicyHoler)");
        test1.setExpression(exp1);
        testSuite.addTest((Test)test1);
        builder = new ExpressionBuilder();
        Expression exp2 = builder.get("policyHolder").get("ssn").equal(1111);
        ReadAllExpressionTest test2 = new ReadAllExpressionTest(Policy.class, 1);
        test2.setName("nested tables read test (Policy)");
        test2.setExpression(exp2);
        testSuite.addTest((Test)test2);
        builder = new ExpressionBuilder();
        Expression exp3 = builder.get("policy").get("policyNumber").equal(102);
        ReadAllExpressionTest test3 = new ReadAllExpressionTest(Claim.class, 1);
        test3.setName("nested tables read test(Claim)");
        test3.setExpression(exp3);
        testSuite.addTest((Test)test3);
        builder = new ExpressionBuilder();
        Expression exp4 = builder.get("policyHolder").get("address").get("city").equal((Object)"Boston");
        ReadAllExpressionTest test4 = new ReadAllExpressionTest(Policy.class, 2);
        test4.setName("nested tables read test(Address from PolicyHolder from Policy)");
        test4.setExpression(exp4);
        testSuite.addTest((Test)test4);
        return testSuite;
    }

    protected static TestSuite getNullUpdatesTestSuite() {
        TestSuite testSuite = new TestSuite();
        testSuite.setName("NullUpdatesTestSuite");
        testSuite.setDescription("Tests setting various object-relational fields to null.");
        PolicyHolder policyHolder = PolicyHolder.example1();
        policyHolder.setChildrenNames(null);
        policyHolder.setAddress(null);
        policyHolder.setOccupation(null);
        policyHolder.setPhones(null);
        WriteObjectTest test = new WriteObjectTest((Object)policyHolder);
        test.setShouldBindAllParameters(true);
        test.setMakesTrivialUpdate(false);
        test.setDescription("Tests setting null on Array, Structure, and ObjectArray mappings.");
        testSuite.addTest((Test)test);
        policyHolder = PolicyHolder.example1();
        policyHolder.setChildrenNames(new Vector());
        policyHolder.setPhones(new Vector());
        test = new WriteObjectTest((Object)policyHolder);
        test.setShouldBindAllParameters(true);
        test.setMakesTrivialUpdate(false);
        test.setDescription("Tests setting empty vectors on Array and NestedTable mappings.");
        testSuite.addTest((Test)test);
        Policy policy = HousePolicy.example3();
        test = new WriteObjectTest((Object)policy);
        test.setShouldBindAllParameters(true);
        test.setDescription("Tests setting null on Ref and NestedTable mappings.");
        testSuite.addTest((Test)test);
        policyHolder = PolicyHolder.example1();
        policy = (Policy)policyHolder.getPolicies().firstElement();
        policy.setClaims(null);
        test = new WriteObjectTest((Object)policy);
        test.setShouldBindAllParameters(true);
        test.setMakesTrivialUpdate(false);
        test.setDescription("Tests setting null on a Ref mapping.");
        testSuite.addTest((Test)test);
        return testSuite;
    }

    protected static TestSuite getObjectArrayUpdateTestSuite() {
        TestSuite testSuite = new TestSuite();
        testSuite.setName("ObjectArrayAddRemoveUoWTestSuite");
        testSuite.setDescription("ObjectArray update test");
        testSuite.addTest((Test)new ObjectArrayMappingUpdateTest());
        return testSuite;
    }

    public void reset() {
        this.getExecutor().removeConfigureSystem((TestSystem)new InsuranceSystem());
    }
}

