/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.mapping;

import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.models.mapping.Employee;

public class DirectCollectionMappingDeleteNullValueTest
extends TestCase {
    final String lastName = "DCMDeleteNullValueT";
    ExpressionBuilder expb = new ExpressionBuilder();
    Expression exp = this.expb.get("lastName").equal((Object)"DCMDeleteNullValueT");

    protected void setup() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        Employee employee = (Employee)uow.registerObject((Object)new Employee());
        employee.firstName = "DCM";
        employee.lastName = "DCMDeleteNullValueT";
        employee.sex = "male";
        employee.getPolicies().add("somepolicy");
        employee.getPolicies().add(null);
        uow.commit();
    }

    protected void test() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        Employee employee = (Employee)uow.readObject(Employee.class, this.exp);
        employee.getPolicies().remove(null);
        uow.commit();
    }

    protected void verify() {
        Employee employee = (Employee)this.getSession().readObject(Employee.class, this.exp);
        this.getSession().refreshObject((Object)employee);
        if (employee.getPolicies().contains(null)) {
            this.throwError("Null value not deleted from DirectCollectionMapping");
        }
    }

    public void reset() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        Employee employee = (Employee)uow.readObject(Employee.class, this.exp);
        uow.deleteObject((Object)employee);
        uow.commit();
    }
}

