/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.mapping;

import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.mapping.Employee;
import org.eclipse.persistence.testing.models.mapping.MappingSystem;

public class SelectionCriteriaInOneToOneTest
extends AutoVerifyTestCase {
    public Employee employee1;
    public Employee employee2;
    public DatabaseSession newSession;
    public Project project;

    public SelectionCriteriaInOneToOneTest() {
        this.setDescription("Verify that buildSelectionCriteria in one-to-one mapping works");
    }

    protected void setup() throws Exception {
        MappingSystem mappingSystem = new MappingSystem();
        this.project = mappingSystem.project;
        ClassDescriptor descriptor = (ClassDescriptor)this.project.getDescriptors().get(Employee.class);
        descriptor.setAmendmentClass(MappingSystem.class);
        descriptor.setAmendmentMethodName("modifyOneToOneMappingDescriptor");
        descriptor.applyAmendmentMethod();
        DatabaseLogin databaseLogin = (DatabaseLogin)this.getSession().getLogin().clone();
        this.project.setLogin(databaseLogin);
        this.newSession = this.project.createDatabaseSession();
        this.newSession.setSessionLog(this.getSession().getSessionLog());
        this.newSession.login();
    }

    public void test() {
        this.modifyOneToOneMappingExample();
    }

    protected void verify() {
        if (!this.employee1.cubicle.location.equals("3rd floor, Section R, Third qubicle on left")) {
            throw new TestErrorException("OneToOneMapping.buildSelectionCriteria could not set the correct selection criteria. 1");
        }
        if (this.employee2.cubicle != null) {
            throw new TestErrorException("OneToOneMapping.buildSelectionCriteria could not set the correct selection criteria. 2");
        }
    }

    public void reset() {
        this.newSession.getIdentityMapAccessor().initializeIdentityMaps();
        this.newSession.logout();
    }

    public void modifyOneToOneMappingExample() {
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression exp = builder.get("firstName").equal((Object)"Dave").and(builder.get("lastName").equal((Object)"Vadis"));
        this.employee1 = (Employee)this.newSession.readObject(Employee.class, exp);
        ExpressionBuilder builder2 = new ExpressionBuilder();
        Expression exp2 = builder2.get("firstName").equal((Object)"Graham").and(builder2.get("lastName").equal((Object)"Gooch"));
        this.employee2 = (Employee)this.newSession.readObject(Employee.class, exp2);
    }
}

