/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.mapping.conversion;

import junit.framework.TestCase;
import org.eclipse.persistence.internal.mappings.converters.AttributeNamePrefix;
import org.eclipse.persistence.internal.mappings.converters.AttributeNameTokenizer;
import org.junit.Test;

public class AttributeNameTokenizerTest
extends TestCase {
    private static String[] ATTR_NAMES = new String[]{"value", "something", "something.somewhere", "something.somewhere.under.some.structure"};
    private static final String ATTR_NAME_SPLIT_REGEX = "\\.";

    private static String[] buildAttributeNamesWithPrefix(String[] source, String prefix) {
        String[] target = new String[source.length];
        for (int i = 0; i < source.length; ++i) {
            String sourceName = source[i];
            StringBuilder sb = new StringBuilder(sourceName.length() + prefix.length() + 1);
            sb.append(prefix);
            sb.append('.');
            sb.append(sourceName);
            target[i] = sb.toString();
        }
        return target;
    }

    @Test
    public void testGetNameAfterKey() {
        String[] prefixedNames = AttributeNameTokenizerTest.buildAttributeNamesWithPrefix(ATTR_NAMES, AttributeNamePrefix.KEY.getName());
        for (int i = 0; i < prefixedNames.length; ++i) {
            String prefixedName = prefixedNames[i];
            String result = AttributeNameTokenizer.getNameAfterKey((String)prefixedName);
            AttributeNameTokenizerTest.assertTrue((String)("Removal of " + AttributeNamePrefix.KEY.getName() + " prefix failed."), (boolean)result.equals(ATTR_NAMES[i]));
        }
    }

    @Test
    public void testGetNameAfterVersion() {
        String[] prefixedNames = AttributeNameTokenizerTest.buildAttributeNamesWithPrefix(ATTR_NAMES, AttributeNamePrefix.VALUE.getName());
        for (int i = 0; i < prefixedNames.length; ++i) {
            String prefixedName = prefixedNames[i];
            String result = AttributeNameTokenizer.getNameAfterVersion((String)prefixedName);
            AttributeNameTokenizerTest.assertTrue((String)("Removal of " + AttributeNamePrefix.VALUE.getName() + " prefix failed."), (boolean)result.equals(ATTR_NAMES[i]));
        }
    }

    @Test
    public void testIterator() {
        String[][] attrNames = new String[][]{ATTR_NAMES, AttributeNameTokenizerTest.buildAttributeNamesWithPrefix(ATTR_NAMES, AttributeNamePrefix.KEY.getName()), AttributeNameTokenizerTest.buildAttributeNamesWithPrefix(ATTR_NAMES, AttributeNamePrefix.VALUE.getName())};
        for (int i = 0; i < attrNames.length; ++i) {
            for (int j = 0; j < attrNames[i].length; ++j) {
                String attrName = attrNames[i][j];
                String[] tokens = attrName.split(ATTR_NAME_SPLIT_REGEX);
                int k = 0;
                for (String token : new AttributeNameTokenizer(attrName)) {
                    AttributeNameTokenizerTest.assertTrue((String)"Order of tokens did not match", (boolean)token.equals(tokens[k++]));
                }
                AttributeNameTokenizerTest.assertEquals((String)("Token count is wrong: " + tokens.length + "!=" + k), (int)tokens.length, (int)k);
                k = 0;
                for (String token : new AttributeNameTokenizer(attrName)) {
                    AttributeNameTokenizerTest.assertTrue((String)"Order of tokens did not match", (boolean)token.equals(tokens[k++]));
                }
                AttributeNameTokenizerTest.assertEquals((String)("Token count is wrong: " + tokens.length + "!=" + k), (int)tokens.length, (int)k);
            }
        }
    }

    @Test
    public void testTokensIterator() {
        String[][] attrNames = new String[][]{ATTR_NAMES, AttributeNameTokenizerTest.buildAttributeNamesWithPrefix(ATTR_NAMES, AttributeNamePrefix.KEY.getName()), AttributeNameTokenizerTest.buildAttributeNamesWithPrefix(ATTR_NAMES, AttributeNamePrefix.VALUE.getName())};
        for (int i = 0; i < attrNames.length; ++i) {
            for (int j = 0; j < attrNames[i].length; ++j) {
                String attrName = attrNames[i][j];
                String[] tokens = attrName.split(ATTR_NAME_SPLIT_REGEX);
                int k = i == 0 ? 0 : 1;
                AttributeNameTokenizer.TokensIterator it = new AttributeNameTokenizer.TokensIterator(attrName, true);
                while (it.hasNext()) {
                    String token = it.next();
                    AttributeNameTokenizerTest.assertTrue((String)"Order of tokens did not match", (boolean)token.equals(tokens[k++]));
                }
                AttributeNameTokenizerTest.assertEquals((String)("Token count is wrong: " + tokens.length + "!=" + k), (int)tokens.length, (int)k);
                AttributeNamePrefix prefix = it.getPrefix();
                AttributeNamePrefix expectedPrefix = null;
                switch (i) {
                    case 0: {
                        expectedPrefix = AttributeNamePrefix.NULL;
                        break;
                    }
                    case 1: {
                        expectedPrefix = AttributeNamePrefix.KEY;
                        break;
                    }
                    case 2: {
                        expectedPrefix = AttributeNamePrefix.VALUE;
                        break;
                    }
                    default: {
                        AttributeNameTokenizerTest.fail((String)"Illegal attribute names array iondex.");
                    }
                }
                AttributeNameTokenizerTest.assertTrue((String)"Returned prefix type is wrong", (boolean)expectedPrefix.equals((Object)prefix));
            }
        }
    }
}

