/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.nls.japanese;

import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.tests.nls.japanese.NLSEmployee;

public class NLSMemoryQueryThrowExceptionTest
extends AutoVerifyTestCase {
    protected ReadObjectQuery query;
    protected boolean exceptionThrown = false;

    public NLSMemoryQueryThrowExceptionTest() {
        this.setDescription("[NLS_Japanese] Test memory query throw indirection exception option");
    }

    public void reset() {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    public void setup() {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        this.query = (ReadObjectQuery)this.getSession().getDescriptor(NLSEmployee.class).getQueryManager().getQuery("memoryQueryThrowExceptionQuery");
        this.getSession().executeQuery((DatabaseQuery)this.query);
    }

    public void test() {
        ReadObjectQuery queryCopy = (ReadObjectQuery)this.query.clone();
        queryCopy.checkCacheOnly();
        queryCopy.setSelectionCriteria(new ExpressionBuilder().get("address").get("city").equal((Object)"\u3059\u30db\u30bb\u30c8\u30c4\u30aa\u30a2\u30b7"));
        try {
            this.getSession().executeQuery((DatabaseQuery)queryCopy);
        }
        catch (QueryException exception) {
            this.exceptionThrown = exception.getErrorCode() == 6092;
        }
    }

    public void verify() {
        if (!this.exceptionThrown) {
            throw new TestErrorException("In Memory Query did not return all objects because of indirection");
        }
    }
}

