/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.performance.reading;

import java.util.Vector;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.testing.framework.PerformanceComparisonTestCase;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.models.performance.toplink.Employee;

public class ReadObjectvsJoinTest
extends PerformanceComparisonTestCase {
    protected Employee employee;
    protected ReadObjectQuery query;
    protected ReadObjectQuery joinQuery;

    public ReadObjectvsJoinTest() {
        this.setDescription("This test compares the performance of read object and access to 1-1, 1-m vs joining.");
        this.addReadObjectJoinTest();
    }

    public void setup() throws Exception {
        Expression expression = new ExpressionBuilder().get("firstName").equal((Object)"Bob");
        this.employee = (Employee)this.getSession().readObject(Employee.class, expression);
        this.query = new ReadObjectQuery(Employee.class);
        this.query.setSelectionCriteria(this.query.getExpressionBuilder().get("id").equal(this.query.getExpressionBuilder().getParameter("id")));
        this.query.addArgument("id");
        this.joinQuery = new ReadObjectQuery(Employee.class);
        this.joinQuery.setSelectionCriteria(this.joinQuery.getExpressionBuilder().get("id").equal(this.joinQuery.getExpressionBuilder().getParameter("id")));
        this.joinQuery.addJoinedAttribute("address");
        this.joinQuery.addJoinedAttribute(this.joinQuery.getExpressionBuilder().anyOf("phoneNumbers"));
        this.joinQuery.addArgument("id");
    }

    public void test() throws Exception {
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        Vector<Long> arguments = new Vector<Long>();
        arguments.add(this.employee.getId());
        Employee result = (Employee)this.getSession().executeQuery((DatabaseQuery)this.query, arguments);
        result.getAddress();
        result.getPhoneNumbers().size();
    }

    public void addReadObjectJoinTest() {
        PerformanceComparisonTestCase test = new PerformanceComparisonTestCase(){

            public void test() {
                this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
                Vector<Long> arguments = new Vector<Long>();
                arguments.add(ReadObjectvsJoinTest.this.employee.getId());
                Employee result = (Employee)this.getSession().executeQuery((DatabaseQuery)ReadObjectvsJoinTest.this.joinQuery, arguments);
                result.getAddress();
                result.getPhoneNumbers().size();
            }
        };
        test.setName("ReadObjectJoinTest");
        test.setAllowableDecrease(30.0);
        this.addTest((TestCase)test);
    }
}

