/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.proxyindirection;

import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.tests.proxyindirection.AddressImpl;
import org.eclipse.persistence.testing.tests.proxyindirection.CubicleImpl;
import org.eclipse.persistence.testing.tests.proxyindirection.Employee;
import org.eclipse.persistence.testing.tests.proxyindirection.EmployeeImpl;

public class InsertTest
extends AutoVerifyTestCase {
    public InsertTest() {
        this.setDescription("Tests InsertObject, including private ownership, using Proxy Indirection.");
    }

    public void reset() {
        this.getAbstractSession().rollbackTransaction();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    public void setup() {
        this.getAbstractSession().beginTransaction();
    }

    public void test() {
        EmployeeImpl emp1 = new EmployeeImpl();
        emp1.setFirstName("Kevin");
        emp1.setLastName("Moore");
        emp1.setGender("Male");
        emp1.setAge(30);
        AddressImpl add = new AddressImpl();
        add.setStreet("600 Chromakey Dr.");
        add.setCity("Roswell");
        add.setState("NM");
        add.setCountry("USA");
        add.setPostalCode("21872");
        CubicleImpl cube1 = new CubicleImpl();
        cube1.setLength(7.7f);
        cube1.setWidth(12.2f);
        cube1.setHeight(5.0f);
        emp1.setAddress(add);
        cube1.setEmployee(emp1);
        ((DatabaseSession)this.getSession()).insertObject((Object)add);
        this.getAbstractSession().insertObject((Object)cube1);
    }

    public void verify() {
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        Employee kevin = (Employee)this.getSession().readObject(Employee.class, new ExpressionBuilder().get("firstName").equal((Object)"Kevin"));
        if (kevin == null) {
            throw new TestErrorException("No employee with first name \"Kevin\" was returned, private ownership may not have worked.");
        }
        if (((AbstractSession)this.getSession()).getIdentityMapAccessorInstance().getIdentityMap(AddressImpl.class).getSize() != 0) {
            throw new TestErrorException("ProxyIndirection did not work - Address was read in along with Employee.");
        }
        kevin.getAddress().getCity();
        if (((AbstractSession)this.getSession()).getIdentityMapAccessorInstance().getIdentityMap(EmployeeImpl.class).getSize() == 0) {
            throw new TestErrorException("ProxyIndirection did not work - Address was not read in when triggered from Employee.");
        }
    }
}

