/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.proxyindirection;

import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.tests.proxyindirection.AddressImpl;
import org.eclipse.persistence.testing.tests.proxyindirection.Employee;
import org.eclipse.persistence.testing.tests.proxyindirection.EmployeeImpl;

public class ReadWithExpressionTest
extends AutoVerifyTestCase {
    Employee employee;

    public ReadWithExpressionTest() {
        this.setDescription("Tests ReadObject using an Expression using Proxy Indirection.");
    }

    public void reset() {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    public void setup() {
    }

    public void test() {
        ReadObjectQuery q = new ReadObjectQuery();
        q.setReferenceClass(Employee.class);
        q.setSelectionCriteria(new ExpressionBuilder().get("firstName").like("Rick%"));
        this.employee = (Employee)this.getSession().executeQuery((DatabaseQuery)q);
    }

    public void verify() {
        if (this.employee == null) {
            throw new TestErrorException("No employee with first name \"Rick\" was returned.");
        }
        if (((AbstractSession)this.getSession()).getIdentityMapAccessorInstance().getIdentityMap(AddressImpl.class).getSize() != 0) {
            throw new TestErrorException("ProxyIndirection did not work - Address was read in along with Employee.");
        }
        this.employee.getAddress().getCity();
        if (((AbstractSession)this.getSession()).getIdentityMapAccessorInstance().getIdentityMap(EmployeeImpl.class).getSize() == 0) {
            throw new TestErrorException("ProxyIndirection did not work - Address was not read in when triggered from Employee.");
        }
    }
}

