/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries;

import java.util.Vector;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.UpdateAllQuery;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class UpdateAllQueryUOWTest
extends AutoVerifyTestCase {
    private Session m_session;
    private UnitOfWork m_uow;
    private boolean defer;

    public UpdateAllQueryUOWTest() {
        this(true);
    }

    public UpdateAllQueryUOWTest(boolean defer) {
        this.defer = defer;
        this.setName(this.getName() + " defer=" + defer);
    }

    protected void setup() {
        this.m_session = this.getSession();
        this.beginTransaction();
        this.m_uow = this.m_session.acquireUnitOfWork();
        this.m_session.getIdentityMapAccessor().initializeIdentityMaps();
    }

    public void reset() {
        this.m_session.getIdentityMapAccessor().initializeIdentityMaps();
        this.rollbackTransaction();
    }

    public void test() {
        if (this.m_session.getDatasourcePlatform().isSymfoware()) {
            this.throwWarning("Test UpdateAllQueryUOWTest skipped for this platform, Symfoware doesn't support UpdateAll/DeleteAll on multi-table objects (see rfe 298193).");
        }
        ExpressionBuilder eb = new ExpressionBuilder();
        UpdateAllQuery updateQuery = new UpdateAllQuery(Employee.class);
        updateQuery.addUpdate(eb.get("lastName"), (Object)"dummyLastName");
        updateQuery.setShouldDeferExecutionInUOW(this.defer);
        this.m_uow.executeQuery((DatabaseQuery)updateQuery);
    }

    protected void verify() {
        Employee emp;
        int i;
        Vector emps = this.m_session.readAllObjects(Employee.class);
        for (i = 0; i < emps.size(); ++i) {
            emp = (Employee)emps.elementAt(i);
            if (emp.getLastName().equals("dummyLastName")) {
                if (!this.defer) continue;
                throw new TestErrorException("Update all fired before the UOW commit");
            }
            if (this.defer) continue;
            throw new TestErrorException("Update all did not fire before the UOW commit");
        }
        this.m_uow.commit();
        this.m_session.getIdentityMapAccessor().initializeIdentityMaps();
        emps = this.m_session.readAllObjects(Employee.class);
        for (i = 0; i < emps.size(); ++i) {
            emp = (Employee)emps.elementAt(i);
            if (emp.getLastName().equals("dummyLastName") || !this.defer) continue;
            throw new TestErrorException("Update all did not fire at commit time");
        }
    }
}

