/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.remote;

import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.tests.remote.Master;
import org.eclipse.persistence.testing.tests.remote.Slave;

public class RefreshMaintainIdentityTest
extends TestCase {
    private Vector masters = null;
    private Vector slaves = null;
    private boolean mastersShouldRefresh = false;
    private boolean slavesShouldRefresh = false;

    public RefreshMaintainIdentityTest() {
        this.setDescription("Test to ensure identity is maintained across valueholders in remote sessions.");
    }

    public void reset() {
        this.getAbstractSession().rollbackTransaction();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        this.getSession().getDescriptor(Master.class).setShouldAlwaysRefreshCacheOnRemote(this.mastersShouldRefresh);
        this.getSession().getDescriptor(Slave.class).setShouldAlwaysRefreshCacheOnRemote(this.slavesShouldRefresh);
    }

    public void setup() {
        this.mastersShouldRefresh = this.getSession().getDescriptor(Master.class).shouldAlwaysRefreshCacheOnRemote();
        this.slavesShouldRefresh = this.getSession().getDescriptor(Slave.class).shouldAlwaysRefreshCacheOnRemote();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        this.getAbstractSession().beginTransaction();
    }

    public void test() {
        this.getSession().getDescriptor(Master.class).setShouldAlwaysRefreshCacheOnRemote(true);
        this.getSession().getDescriptor(Slave.class).setShouldAlwaysRefreshCacheOnRemote(true);
        this.slaves = this.getAllSlaves();
        this.masters = this.getAllMasters();
        Enumeration masterEnum = this.masters.elements();
        while (masterEnum.hasMoreElements()) {
            Master master = (Master)masterEnum.nextElement();
            master.getSlaves();
        }
        this.slaves = this.getAllSlaves();
        this.masters = this.getAllMasters();
    }

    protected void verify() {
        Enumeration slave_enum = this.slaves.elements();
        while (slave_enum.hasMoreElements()) {
            Slave slave = (Slave)slave_enum.nextElement();
            if (slave.getMaster().getSlaves().contains(slave)) continue;
            throw new TestErrorException("Identity Violated");
        }
    }

    protected Vector getAllMasters() {
        ReadAllQuery query = new ReadAllQuery(Master.class);
        return (Vector)this.getSession().executeQuery((DatabaseQuery)query);
    }

    protected Vector getAllSlaves() {
        ReadAllQuery query = new ReadAllQuery(Slave.class);
        return (Vector)this.getSession().executeQuery((DatabaseQuery)query);
    }
}

