/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.remote;

import org.eclipse.persistence.internal.sessions.remote.Transporter;
import org.eclipse.persistence.testing.framework.TestException;

public class TransporterGenerator {
    public static int RETURN_NULL = 0;
    public static int THROW_REMOTE_EXCEPTION = 1;
    public static int SET_EXCEPTION_INTO_TRANSPORTER = 2;
    protected String message;
    protected int mode;

    public TransporterGenerator(int mode) {
        this.mode = mode;
        this.message = "Generated by TransporterGenerator";
    }

    public TransporterGenerator(int mode, String message) {
        this(mode);
        this.message = message;
    }

    public int getMode() {
        return this.mode;
    }

    public String getMessage() {
        return this.message;
    }

    public Transporter generate() {
        if (this.mode == RETURN_NULL) {
            return null;
        }
        if (this.mode == THROW_REMOTE_EXCEPTION) {
            throw new Error(this.message);
        }
        if (this.mode == SET_EXCEPTION_INTO_TRANSPORTER) {
            Transporter transporter = new Transporter();
            transporter.setException((RuntimeException)new TestException(this.message));
            return transporter;
        }
        throw new TestException("TransporterGenerator: Invalid mode");
    }
}

