/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.transparentindirection;

import java.rmi.Naming;
import java.rmi.RemoteException;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.sessions.remote.rmi.RMIConnection;
import org.eclipse.persistence.testing.framework.TestProblemException;
import org.eclipse.persistence.testing.models.transparentindirection.AbstractOrder;
import org.eclipse.persistence.testing.tests.remote.RMIServerManager;
import org.eclipse.persistence.testing.tests.transparentindirection.IndirectContainerTestDatabase;

public class IndirectContainerTestDatabaseRemote
extends IndirectContainerTestDatabase {
    protected UnitOfWork unitOfWork;

    public IndirectContainerTestDatabaseRemote(String name) {
        super(name);
    }

    protected RMIConnection buildConnection() {
        RMIServerManager serverManager = null;
        try {
            serverManager = (RMIServerManager)Naming.lookup("SERVER-MANAGER");
        }
        catch (Exception exception) {
            throw new TestProblemException(exception.toString());
        }
        RMIConnection rmiConnection = null;
        try {
            rmiConnection = new RMIConnection(serverManager.createRemoteSessionController());
        }
        catch (RemoteException exception) {
            System.out.println("Error in invocation " + exception.toString());
        }
        return rmiConnection;
    }

    public void clearUnitOfWork() {
        this.unitOfWork = null;
    }

    public void commitUnitOfWork() {
        this.getUnitOfWork().commit();
        this.clearUnitOfWork();
    }

    protected UnitOfWork getUnitOfWork() {
        if (this.unitOfWork == null) {
            this.unitOfWork = this.getSession().acquireUnitOfWork();
        }
        return this.unitOfWork;
    }

    @Override
    protected AbstractOrder readOrder(AbstractOrder key) {
        return (AbstractOrder)this.getUnitOfWork().readObject((Object)key);
    }

    protected void registerNewOrderIn(AbstractOrder order, UnitOfWork uow) {
        uow.registerObject((Object)order);
    }

    @Override
    protected void setUp() {
        if (!this.getSession().isRemoteSession()) {
            throw new TestProblemException("session should be a remote session");
        }
        super.setUp();
    }

    @Override
    public void updateOrder(AbstractOrder order) {
        this.commitUnitOfWork();
    }

    @Override
    protected void writeNewOrder(AbstractOrder order) {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        this.registerNewOrderIn(order, uow);
        uow.commit();
    }
}

