/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.unitofwork.changeflag;

import java.util.Vector;
import org.eclipse.persistence.descriptors.DescriptorEvent;
import org.eclipse.persistence.descriptors.DescriptorEventAdapter;
import org.eclipse.persistence.descriptors.DescriptorEventListener;
import org.eclipse.persistence.descriptors.changetracking.ObjectChangePolicy;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class ChangeEventTest
extends AutoVerifyTestCase {
    protected boolean extraChangeComparison = false;
    protected boolean writeOccurred = false;
    protected boolean insertOccurred = false;
    protected Employee clone;
    protected Employee employeeToBeInserted = new Employee();
    protected ObjectChangePolicy changePolicy;
    private DescriptorEventAdapter eventAdapter = new DescriptorEventAdapter(){

        public void preWrite(DescriptorEvent event) {
            ChangeEventTest.this.writeOccurred(event);
        }

        public void preInsert(DescriptorEvent event) {
            ChangeEventTest.this.insertOccurred(event);
        }
    };

    public void setup() {
        this.getSession().getDescriptor(Employee.class).getEventManager().addListener((DescriptorEventListener)this.eventAdapter);
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        this.getAbstractSession().beginTransaction();
    }

    public void test() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        Vector employees = uow.readAllObjects(Employee.class);
        this.clone = (Employee)employees.firstElement();
        this.clone.setFirstName(this.clone.getFirstName() + "1");
        this.employeeToBeInserted.setFirstName("John");
        this.employeeToBeInserted.setLastName("Smith");
        this.employeeToBeInserted.setMale();
        uow.registerNewObject((Object)this.employeeToBeInserted);
        uow.commit();
    }

    public void reset() {
        this.getAbstractSession().rollbackTransaction();
        this.getSession().getDescriptor(Employee.class).getEventManager().removeListener((DescriptorEventListener)this.eventAdapter);
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
    }

    public void verify() {
        if (!this.writeOccurred) {
            throw new TestErrorException("There was no preWrite event thrown.");
        }
        if (!this.insertOccurred) {
            throw new TestErrorException("There was no preInsert event thrown.");
        }
    }

    public void writeOccurred(DescriptorEvent event) {
        this.writeOccurred = true;
    }

    public void insertOccurred(DescriptorEvent event) {
        this.insertOccurred = true;
    }
}

