/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.validation;

import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.exceptions.IntegrityChecker;
import org.eclipse.persistence.internal.descriptors.MethodAttributeAccessor;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.tests.validation.Address;
import org.eclipse.persistence.testing.tests.validation.ExceptionTest;
import org.eclipse.persistence.testing.tests.validation.PersonMethodAccess;

public class IllegalArgumentWhileSettingValueThruMethodAccessorTest
extends ExceptionTest {
    ClassDescriptor orgDescriptor;
    IntegrityChecker orgIntegrityChecker;

    public IllegalArgumentWhileSettingValueThruMethodAccessorTest() {
        this.setDescription("This tests Illegal Argument While Setting Value Thru Method Accessor (TL-ERROR 33)");
    }

    protected void setup() {
        this.expectedException = DescriptorException.illegalArgumentWhileSettingValueThruMethodAccessor((String)"setName", (Object)"Person", null);
        this.getAbstractSession().beginTransaction();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        this.orgDescriptor = ((DatabaseSession)this.getSession()).getDescriptor(PersonMethodAccess.class);
        this.orgIntegrityChecker = this.getSession().getIntegrityChecker();
    }

    @Override
    public void reset() {
        ((DatabaseSession)this.getSession()).getDescriptors().remove(PersonMethodAccess.class);
        if (this.orgDescriptor != null) {
            ((DatabaseSession)this.getSession()).addDescriptor(this.orgDescriptor);
        }
        if (this.orgIntegrityChecker != null) {
            this.getSession().setIntegrityChecker(this.orgIntegrityChecker);
        }
        this.getAbstractSession().rollbackTransaction();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    public void test() {
        PersonMethodAccess person = new PersonMethodAccess();
        person.setName("Person");
        Address address = new Address();
        try {
            this.getSession().setIntegrityChecker(new IntegrityChecker());
            this.getSession().getIntegrityChecker().dontCatchExceptions();
            ((DatabaseSession)this.getSession()).addDescriptor((ClassDescriptor)this.descriptor());
            UnitOfWork uow = ((DatabaseSession)this.getSession()).acquireUnitOfWork();
            uow.registerObject((Object)person);
            uow.commit();
            DatabaseMapping dMapping = this.descriptor().getMappingForAttributeName("p_name");
            DatabaseMapping idMapping = this.descriptor().getMappingForAttributeName("p_id");
            ((MethodAttributeAccessor)dMapping.getAttributeAccessor()).initializeAttributes(PersonMethodAccess.class);
            ((MethodAttributeAccessor)idMapping.getAttributeAccessor()).initializeAttributes(PersonMethodAccess.class);
            ((MethodAttributeAccessor)idMapping.getAttributeAccessor()).setGetMethodName("Vesna");
            ((MethodAttributeAccessor)dMapping.getAttributeAccessor()).setAttributeValueInObject((Object)address, dMapping.getAttributeValueFromObject((Object)person));
        }
        catch (EclipseLinkException exception) {
            this.caughtException = exception;
        }
    }

    public RelationalDescriptor descriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(PersonMethodAccess.class);
        descriptor.addTableName("EMPLOYEE");
        descriptor.addPrimaryKeyFieldName("EMPLOYEE.EMP_ID");
        descriptor.useSoftCacheWeakIdentityMap();
        descriptor.setIdentityMapSize(100);
        descriptor.useRemoteSoftCacheWeakIdentityMap();
        descriptor.setRemoteIdentityMapSize(100);
        descriptor.setSequenceNumberFieldName("EMP_ID");
        descriptor.setSequenceNumberName("EMP_SEQ");
        descriptor.setAlias("EMPLOYEE");
        descriptor.getQueryManager().checkCacheForDoesExist();
        DirectToFieldMapping p_idMapping = new DirectToFieldMapping();
        p_idMapping.setAttributeName("p_id");
        p_idMapping.setFieldName("EMPLOYEE.EMP_ID");
        p_idMapping.setGetMethodName("getId");
        p_idMapping.setSetMethodName("setId");
        descriptor.addMapping((DatabaseMapping)p_idMapping);
        DirectToFieldMapping p_nameMapping = new DirectToFieldMapping();
        p_nameMapping.setAttributeName("p_name");
        p_nameMapping.setFieldName("EMPLOYEE.F_NAME");
        p_nameMapping.setGetMethodName("getName");
        p_nameMapping.setSetMethodName("setName");
        descriptor.addMapping((DatabaseMapping)p_nameMapping);
        return descriptor;
    }
}

