/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.framework.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.testing.framework.LoadBuildSummary;
import org.eclipse.persistence.testing.framework.TestResult;
import org.eclipse.persistence.testing.framework.TestResultsSummary;
import org.eclipse.persistence.testing.framework.ui.NonEditableDefaultTableModel;

public class LoadBuildDisplayPanel
extends JPanel
implements ActionListener,
MouseListener {
    private Vector loadBuildsCache;
    private Vector testResultsCahce;
    private Vector testSummaryCahce;
    private LoadBuildSummary selectedLoadBuild;
    private final int LOADBUILD = 1;
    private final int SUMMARY = 2;
    private final int RESULT = 3;
    private int tableSelection;
    private DatabaseSession session;
    private JTable loadBuildTable;
    private JTable testResultTable;
    private JTable testSummaryTable;
    private JTabbedPane ivjLoadBuildTabbedPanel = null;
    private JPanel ivjViewPage = null;
    private JPanel ivjLoadBuildPage = null;
    private JButton ivjLoadErrorTestResultButton = null;
    private JTextArea ivjViewTextArea = null;
    private JButton ivjDeleteButton = null;
    private JScrollPane ivjViewScrollPane = null;
    private JScrollPane ivjLoadBuildScrollPane = null;
    private JTable ivjSelectedTable = null;
    private JButton ivjInspectButton = null;
    private JButton ivjUpButton = null;
    private JButton ivjViewButton = null;

    public LoadBuildDisplayPanel() {
        this.initialize();
    }

    public LoadBuildDisplayPanel(LayoutManager layout) {
        super(layout);
    }

    public LoadBuildDisplayPanel(LayoutManager layout, boolean isDoubleBuffered) {
        super(layout, isDoubleBuffered);
    }

    public LoadBuildDisplayPanel(boolean isDoubleBuffered) {
        super(isDoubleBuffered);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.getLoadErrorTestResultButton()) {
            this.connEtoC2(e);
        }
        if (e.getSource() == this.getDeleteButton()) {
            this.connEtoC9(e);
        }
        if (e.getSource() == this.getUpButton()) {
            this.connEtoC1(e);
        }
        if (e.getSource() == this.getInspectButton()) {
            this.connEtoC3(e);
        }
        if (e.getSource() == this.getViewButton()) {
            this.connEtoC4(e);
        }
    }

    public void buildErrorTestResultForSummary() {
        int index = this.getSelectedTable().getSelectedRow();
        TestResultsSummary selectedSummary = (TestResultsSummary)this.testSummaryCahce.elementAt(index);
        Vector<TestResult> testResults = new Vector<TestResult>();
        if (selectedSummary.getResults() != null && selectedSummary.getResults().size() > 0) {
            Enumeration enumtr = selectedSummary.getResults().elements();
            while (enumtr.hasMoreElements()) {
                TestResult result = (TestResult)enumtr.nextElement();
                if (!result.hasError() && !result.hasFatalError() && !result.hasProblem()) continue;
                testResults.addElement(result);
            }
        } else {
            TestResultsSummary summary;
            Vector<TestResultsSummary> summariesHasResult = new Vector<TestResultsSummary>();
            Enumeration enumtr = selectedSummary.getLoadBuildSummary().getSummaries().elements();
            while (enumtr.hasMoreElements()) {
                summary = (TestResultsSummary)enumtr.nextElement();
                if (summary.getResults() == null || summary.getResults().size() == 0) continue;
                summariesHasResult.addElement(summary);
            }
            Enumeration enum1 = summariesHasResult.elements();
            block2: while (enum1.hasMoreElements()) {
                TestResultsSummary temp = summary = (TestResultsSummary)enum1.nextElement();
                while (temp.getParent() != null) {
                    if (temp.getParent() == selectedSummary) {
                        Enumeration enum2 = summary.getResults().elements();
                        while (enum2.hasMoreElements()) {
                            TestResult result = (TestResult)enum2.nextElement();
                            if (!result.hasError() && !result.hasFatalError() && !result.hasProblem()) continue;
                            testResults.addElement(result);
                        }
                        continue block2;
                    }
                    temp = temp.getParent();
                }
            }
        }
        this.testResultsCahce = testResults;
    }

    public void clearTable(JTable table) {
        table.setModel(new NonEditableDefaultTableModel());
        table.repaint();
    }

    private void connEtoC1(ActionEvent arg1) {
        try {
            this.up();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC2(ActionEvent arg1) {
        try {
            this.loadErrorTestResults();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC3(ActionEvent arg1) {
        try {
            this.inspectDatabaseLogin();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC4(ActionEvent arg1) {
        try {
            this.viewStackTrace();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC9(ActionEvent arg1) {
        try {
            this.deleteLoadBuild();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    public void deleteLoadBuild() {
        int index = this.getSelectedTable().getSelectedRow();
        if (index < 0) {
            return;
        }
        int option = JOptionPane.showConfirmDialog(this, "Are you sure that  you want to remove this load build?", "", 2);
        if (option != 0) {
            return;
        }
        LoadBuildSummary loadBuild = (LoadBuildSummary)this.loadBuildsCache.elementAt(index);
        try {
            if (loadBuild.databaseLogin == null) {
                loadBuild = (LoadBuildSummary)this.session.readObject((Object)loadBuild);
            }
            this.session.deleteObject((Object)loadBuild);
            this.loadBuildsCache.removeElementAt(index);
            this.poppulateLoadBuildTable(this.loadBuildsCache);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    public void down() {
        int index = this.getSelectedTable().getSelectedRow();
        if (index < 0) {
            return;
        }
        if (this.tableSelection == 1) {
            TestResultsSummary summary = (TestResultsSummary)this.loadBuildsCache.elementAt(index);
            this.initilaizeTestSummaryCache(summary);
            if (this.tableSelection == 3) {
                this.poppulateTestResultTable(this.testResultsCahce);
            } else {
                this.poppulateTestSummaryTable(this.testSummaryCahce);
            }
        } else if (this.tableSelection == 2) {
            this.initilaizeTestSummaryCache((TestResultsSummary)this.testSummaryCahce.elementAt(index));
            if (this.tableSelection == 3) {
                this.poppulateTestResultTable(this.testResultsCahce);
            } else {
                this.poppulateTestSummaryTable(this.testSummaryCahce);
            }
        }
    }

    private JButton getDeleteButton() {
        if (this.ivjDeleteButton == null) {
            try {
                this.ivjDeleteButton = new JButton();
                this.ivjDeleteButton.setName("DeleteButton");
                this.ivjDeleteButton.setText("Delete");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjDeleteButton;
    }

    private JButton getInspectButton() {
        if (this.ivjInspectButton == null) {
            try {
                this.ivjInspectButton = new JButton();
                this.ivjInspectButton.setName("InspectButton");
                this.ivjInspectButton.setText("Inspect Login");
                this.ivjInspectButton.setHorizontalAlignment(0);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjInspectButton;
    }

    private JPanel getLoadBuildPage() {
        if (this.ivjLoadBuildPage == null) {
            try {
                this.ivjLoadBuildPage = new JPanel();
                this.ivjLoadBuildPage.setName("LoadBuildPage");
                this.ivjLoadBuildPage.setLayout(new GridBagLayout());
                GridBagConstraints constraintsLoadBuildScrollPane = new GridBagConstraints();
                constraintsLoadBuildScrollPane.gridx = 0;
                constraintsLoadBuildScrollPane.gridy = 0;
                constraintsLoadBuildScrollPane.gridwidth = 7;
                constraintsLoadBuildScrollPane.fill = 1;
                constraintsLoadBuildScrollPane.weightx = 1.0;
                constraintsLoadBuildScrollPane.weighty = 1.0;
                constraintsLoadBuildScrollPane.ipadx = 176;
                constraintsLoadBuildScrollPane.ipady = -67;
                constraintsLoadBuildScrollPane.insets = new Insets(0, 0, 5, 0);
                this.getLoadBuildPage().add((Component)this.getLoadBuildScrollPane(), constraintsLoadBuildScrollPane);
                GridBagConstraints constraintsUpButton = new GridBagConstraints();
                constraintsUpButton.gridx = 0;
                constraintsUpButton.gridy = 1;
                constraintsUpButton.anchor = 17;
                constraintsUpButton.insets = new Insets(0, 10, 5, 5);
                this.getLoadBuildPage().add((Component)this.getUpButton(), constraintsUpButton);
                GridBagConstraints constraintsDeleteButton = new GridBagConstraints();
                constraintsDeleteButton.gridx = 2;
                constraintsDeleteButton.gridy = 1;
                constraintsDeleteButton.anchor = 17;
                constraintsDeleteButton.insets = new Insets(0, 5, 5, 5);
                this.getLoadBuildPage().add((Component)this.getDeleteButton(), constraintsDeleteButton);
                GridBagConstraints constraintsLoadErrorTestResultButton = new GridBagConstraints();
                constraintsLoadErrorTestResultButton.gridx = 1;
                constraintsLoadErrorTestResultButton.gridy = 1;
                constraintsLoadErrorTestResultButton.anchor = 17;
                constraintsLoadErrorTestResultButton.insets = new Insets(0, 5, 5, 5);
                this.getLoadBuildPage().add((Component)this.getLoadErrorTestResultButton(), constraintsLoadErrorTestResultButton);
                GridBagConstraints constraintsInspectButton = new GridBagConstraints();
                constraintsInspectButton.gridx = 4;
                constraintsInspectButton.gridy = 1;
                constraintsInspectButton.anchor = 17;
                constraintsInspectButton.insets = new Insets(0, 5, 5, 5);
                this.getLoadBuildPage().add((Component)this.getInspectButton(), constraintsInspectButton);
                GridBagConstraints constraintsViewButton = new GridBagConstraints();
                constraintsViewButton.gridx = 6;
                constraintsViewButton.gridy = 1;
                constraintsViewButton.anchor = 17;
                constraintsViewButton.insets = new Insets(0, 5, 5, 5);
                this.getLoadBuildPage().add((Component)this.getViewButton(), constraintsViewButton);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjLoadBuildPage;
    }

    private JScrollPane getLoadBuildScrollPane() {
        if (this.ivjLoadBuildScrollPane == null) {
            try {
                this.ivjLoadBuildScrollPane = new JScrollPane();
                this.ivjLoadBuildScrollPane.setName("LoadBuildScrollPane");
                this.ivjLoadBuildScrollPane.setVerticalScrollBarPolicy(22);
                this.ivjLoadBuildScrollPane.setHorizontalScrollBarPolicy(32);
                this.getLoadBuildScrollPane().setViewportView(this.getSelectedTable());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjLoadBuildScrollPane;
    }

    private JTabbedPane getLoadBuildTabbedPanel() {
        if (this.ivjLoadBuildTabbedPanel == null) {
            try {
                this.ivjLoadBuildTabbedPanel = new JTabbedPane();
                this.ivjLoadBuildTabbedPanel.setName("LoadBuildTabbedPanel");
                this.ivjLoadBuildTabbedPanel.setBackground(SystemColor.control);
                this.ivjLoadBuildTabbedPanel.insertTab("    Result   ", null, this.getLoadBuildPage(), null, 0);
                this.ivjLoadBuildTabbedPanel.insertTab("     View    ", null, this.getViewPage(), null, 1);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjLoadBuildTabbedPanel;
    }

    private JButton getLoadErrorTestResultButton() {
        if (this.ivjLoadErrorTestResultButton == null) {
            try {
                this.ivjLoadErrorTestResultButton = new JButton();
                this.ivjLoadErrorTestResultButton.setName("LoadErrorTestResultButton");
                this.ivjLoadErrorTestResultButton.setText("Load Error Tests");
                this.ivjLoadErrorTestResultButton.setHorizontalAlignment(0);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjLoadErrorTestResultButton;
    }

    private JTable getSelectedTable() {
        if (this.ivjSelectedTable == null) {
            try {
                this.ivjSelectedTable = new JTable();
                this.ivjSelectedTable.setName("SelectedTable");
                this.getLoadBuildScrollPane().setColumnHeaderView(this.ivjSelectedTable.getTableHeader());
                this.ivjSelectedTable.setBounds(0, 0, 200, 200);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjSelectedTable;
    }

    private JButton getUpButton() {
        if (this.ivjUpButton == null) {
            try {
                this.ivjUpButton = new JButton();
                this.ivjUpButton.setName("UpButton");
                this.ivjUpButton.setText("Up");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjUpButton;
    }

    public int getUpIndex(TestResult theResult) {
        int i;
        if (theResult.getSummary() == null) {
            for (i = 0; i < this.loadBuildsCache.size(); ++i) {
                LoadBuildSummary loadBuild = (LoadBuildSummary)this.loadBuildsCache.elementAt(i);
                if (!loadBuild.timestamp.equals(theResult.getLoadBuildSummary().timestamp)) continue;
                return i;
            }
        } else if (theResult.getSummary().getParent() == null) {
            this.initilaizeTestSummaryCache(theResult.getLoadBuildSummary());
        } else {
            this.initilaizeTestSummaryCache(theResult.getSummary().getParent());
        }
        if (theResult.getSummary() != null) {
            for (i = 0; i < this.testSummaryCahce.size(); ++i) {
                TestResultsSummary summary = (TestResultsSummary)this.testSummaryCahce.elementAt(i);
                if (!summary.getName().equals(theResult.getSummary().getName())) continue;
                return i;
            }
        }
        return -1;
    }

    public int getUpIndex(TestResultsSummary theSummary) {
        if (theSummary.getParent() == null) {
            for (int i = 0; i < this.loadBuildsCache.size(); ++i) {
                LoadBuildSummary loadBuild = (LoadBuildSummary)this.loadBuildsCache.elementAt(i);
                if (!loadBuild.timestamp.equals(theSummary.getLoadBuildSummary().timestamp)) continue;
                return i;
            }
        } else {
            if (theSummary.getParent().getParent() == null) {
                this.initilaizeTestSummaryCache(theSummary.getLoadBuildSummary());
            } else {
                this.initilaizeTestSummaryCache(theSummary.getParent().getParent());
            }
            for (int i = 0; i < this.testSummaryCahce.size(); ++i) {
                TestResultsSummary summary = (TestResultsSummary)this.testSummaryCahce.elementAt(i);
                if (!summary.getName().equals(theSummary.getParent().getName())) continue;
                return i;
            }
        }
        return -1;
    }

    private JButton getViewButton() {
        if (this.ivjViewButton == null) {
            try {
                this.ivjViewButton = new JButton();
                this.ivjViewButton.setName("ViewButton");
                this.ivjViewButton.setText("View Exception");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjViewButton;
    }

    private JPanel getViewPage() {
        if (this.ivjViewPage == null) {
            try {
                this.ivjViewPage = new JPanel();
                this.ivjViewPage.setName("ViewPage");
                this.ivjViewPage.setLayout(new GridBagLayout());
                this.ivjViewPage.setBackground(SystemColor.control);
                this.ivjViewPage.setForeground(SystemColor.controlText);
                GridBagConstraints constraintsViewScrollPane = new GridBagConstraints();
                constraintsViewScrollPane.gridx = 1;
                constraintsViewScrollPane.gridy = 1;
                constraintsViewScrollPane.fill = 1;
                constraintsViewScrollPane.weightx = 1.0;
                constraintsViewScrollPane.weighty = 1.0;
                constraintsViewScrollPane.ipadx = 947;
                constraintsViewScrollPane.ipady = 323;
                this.getViewPage().add((Component)this.getViewScrollPane(), constraintsViewScrollPane);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjViewPage;
    }

    private JScrollPane getViewScrollPane() {
        if (this.ivjViewScrollPane == null) {
            try {
                this.ivjViewScrollPane = new JScrollPane();
                this.ivjViewScrollPane.setName("ViewScrollPane");
                this.getViewScrollPane().setViewportView(this.getViewTextArea());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjViewScrollPane;
    }

    private JTextArea getViewTextArea() {
        if (this.ivjViewTextArea == null) {
            try {
                this.ivjViewTextArea = new JTextArea();
                this.ivjViewTextArea.setName("ViewTextArea");
                this.ivjViewTextArea.setBounds(0, 0, 237, 19);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjViewTextArea;
    }

    private void handleException(Throwable exception) {
        exception.printStackTrace(System.out);
    }

    private void initConnections() throws Exception {
        this.getSelectedTable().addMouseListener(this);
        this.getLoadErrorTestResultButton().addActionListener(this);
        this.getDeleteButton().addActionListener(this);
        this.getUpButton().addActionListener(this);
        this.getInspectButton().addActionListener(this);
        this.getViewButton().addActionListener(this);
    }

    private void initialize() {
        try {
            this.setName("LoadBuildPanel");
            this.setLayout(new GridBagLayout());
            this.setBackground(SystemColor.control);
            this.setSize(640, 417);
            GridBagConstraints constraintsLoadBuildTabbedPanel = new GridBagConstraints();
            constraintsLoadBuildTabbedPanel.gridx = 0;
            constraintsLoadBuildTabbedPanel.gridy = 0;
            constraintsLoadBuildTabbedPanel.gridwidth = 6;
            constraintsLoadBuildTabbedPanel.gridheight = 6;
            constraintsLoadBuildTabbedPanel.fill = 1;
            constraintsLoadBuildTabbedPanel.weightx = 1.0;
            constraintsLoadBuildTabbedPanel.weighty = 1.0;
            constraintsLoadBuildTabbedPanel.insets = new Insets(1, 1, 1, 1);
            this.add((Component)this.getLoadBuildTabbedPanel(), constraintsLoadBuildTabbedPanel);
            this.initConnections();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
        this.getUpButton().setEnabled(false);
        this.getLoadErrorTestResultButton().setEnabled(false);
        this.getDeleteButton().setEnabled(false);
        this.getInspectButton().setEnabled(false);
        this.getViewButton().setEnabled(false);
    }

    public void initilaizeTestSummaryCache(LoadBuildSummary loadBuild) {
        Vector<TestResultsSummary> rootSummaries = new Vector<TestResultsSummary>();
        Enumeration enumtr = loadBuild.getSummaries().elements();
        while (enumtr.hasMoreElements()) {
            TestResultsSummary summary = (TestResultsSummary)enumtr.nextElement();
            if (summary.getParent() != null) continue;
            rootSummaries.addElement(summary);
        }
        this.testSummaryCahce = rootSummaries;
    }

    public void initilaizeTestSummaryCache(TestResultsSummary theSummary) {
        if (theSummary.getResults() != null && theSummary.getResults().size() > 0) {
            this.tableSelection = 3;
            this.testResultsCahce = theSummary.getResults();
            return;
        }
        Vector<TestResultsSummary> children = new Vector<TestResultsSummary>();
        Enumeration enumtr = theSummary.getLoadBuildSummary().getSummaries().elements();
        while (enumtr.hasMoreElements()) {
            TestResultsSummary summary = (TestResultsSummary)enumtr.nextElement();
            if (summary.getParent() == null || !summary.getParent().getName().equals(theSummary.getName())) continue;
            children.addElement(summary);
        }
        this.testSummaryCahce = children;
    }

    public void inspect(Object object) {
        try {
            Class[] argTypes = new Class[]{Object.class};
            Object[] args = new Object[]{object};
            Class.forName("com.ibm.uvm.tools.DebugSupport").getMethod("inspect", argTypes).invoke(null, args);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void inspectDatabaseLogin() {
        int index = this.getSelectedTable().getSelectedRow();
        if (index < 0) {
            return;
        }
        LoadBuildSummary loadBuild = (LoadBuildSummary)this.loadBuildsCache.elementAt(index);
        if (this.session == null || loadBuild.databaseLogin != null) {
            this.inspect(loadBuild.databaseLogin);
            return;
        }
        loadBuild = (LoadBuildSummary)this.session.readObject((Object)loadBuild);
        if (this.loadBuildsCache != null && index <= this.loadBuildsCache.size()) {
            this.loadBuildsCache.removeElementAt(index);
            this.loadBuildsCache.insertElementAt(loadBuild, index);
        }
        this.inspect(loadBuild.databaseLogin);
    }

    public void loadErrorTestResults() {
        this.buildErrorTestResultForSummary();
        this.poppulateTestResultTable(this.testResultsCahce);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() > 1) {
            this.down();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    public void poppulateLoadBuildTable(Vector summaries) {
        this.loadBuildsCache = summaries;
        this.tableSelection = 1;
        NonEditableDefaultTableModel tableModel = new NonEditableDefaultTableModel(new String[]{"Name", "Time", "Database", "OS", "JVM", "Machine", "TopLink Version", "Tests", "Setup Failures", "Errors", "Fatal Errors", "Problems", "Total Time"}, 0);
        Enumeration enumtr = summaries.elements();
        while (enumtr.hasMoreElements()) {
            TestResultsSummary summary = (TestResultsSummary)enumtr.nextElement();
            Vector<Object> row = new Vector<Object>();
            row.addElement(summary.getName());
            row.addElement(summary.getLoadBuildSummary().timestamp);
            row.addElement(summary.getLoadBuildSummary().loginChoice);
            row.addElement(summary.getLoadBuildSummary().os);
            row.addElement(summary.getLoadBuildSummary().jvm);
            row.addElement(summary.getLoadBuildSummary().machine);
            row.addElement(summary.getLoadBuildSummary().toplinkVersion);
            row.addElement(new Integer(summary.getTotalTests()));
            row.addElement(new Integer(summary.getSetupFailures()));
            row.addElement(new Integer(summary.getErrors()));
            row.addElement(new Integer(summary.getFatalErrors()));
            row.addElement(new Integer(summary.getProblems()));
            row.addElement(new Long(summary.getTotalTime()));
            tableModel.addRow(row);
        }
        this.getSelectedTable().setModel(tableModel);
        this.selectFirstRow();
        this.resetButtons();
        this.getSelectedTable().repaint();
    }

    public void poppulateTestResultTable(Vector results) {
        Collections.sort(results);
        this.testResultsCahce = results;
        this.tableSelection = 3;
        this.resetButtons();
        NonEditableDefaultTableModel tableModel = new NonEditableDefaultTableModel(new String[]{"Name", "Outcome", "Test Time", "Total Time", "Has Exception", "Time", "Database", "OS", "JVM", "Machine", "TopLink Version"}, 0);
        Enumeration enumtr = results.elements();
        while (enumtr.hasMoreElements()) {
            TestResult result = (TestResult)enumtr.nextElement();
            Vector<Object> row = new Vector<Object>();
            row.addElement(result.getName());
            row.addElement(result.getOutcome());
            row.addElement(new Long(result.getTestTime()));
            row.addElement(new Long(result.getTotalTime()));
            row.addElement(new Boolean(result.getException() != null));
            row.addElement(result.getLoadBuildSummary().timestamp);
            row.addElement(result.getLoadBuildSummary().loginChoice);
            row.addElement(result.getLoadBuildSummary().os);
            row.addElement(result.getLoadBuildSummary().jvm);
            row.addElement(result.getLoadBuildSummary().machine);
            row.addElement(result.getLoadBuildSummary().toplinkVersion);
            tableModel.addRow(row);
        }
        this.getSelectedTable().setModel(tableModel);
        this.selectFirstRow();
        this.resetButtons();
        this.getSelectedTable().repaint();
    }

    public void poppulateTestSummaryTable(Vector summaries) {
        Collections.sort(summaries);
        this.testSummaryCahce = summaries;
        this.tableSelection = 2;
        this.resetButtons();
        NonEditableDefaultTableModel tableModel = new NonEditableDefaultTableModel(new String[]{"Name", "Total Tests", "Setup Failures", "Passed", "Errors", "Fatal Errors", "Problems", "Warnings", "Total Time"}, 0);
        Enumeration enumtr = summaries.elements();
        while (enumtr.hasMoreElements()) {
            TestResultsSummary summary = (TestResultsSummary)enumtr.nextElement();
            Vector<Object> row = new Vector<Object>();
            row.addElement(summary.getName());
            row.addElement(new Integer(summary.getTotalTests()));
            row.addElement(new Integer(summary.getSetupFailures()));
            row.addElement(new Integer(summary.getPassed()));
            row.addElement(new Integer(summary.getErrors()));
            row.addElement(new Integer(summary.getFatalErrors()));
            row.addElement(new Integer(summary.getProblems()));
            row.addElement(new Integer(summary.getWarnings()));
            row.addElement(new Long(summary.getTotalTime()));
            tableModel.addRow(row);
        }
        this.getSelectedTable().setModel(tableModel);
        this.selectFirstRow();
        this.resetButtons();
        this.getSelectedTable().repaint();
    }

    public void resetButtons() {
        if (this.getSelectedTable().getRowCount() <= 0) {
            this.getUpButton().setEnabled(false);
            this.getLoadErrorTestResultButton().setEnabled(false);
            this.getDeleteButton().setEnabled(false);
            this.getInspectButton().setEnabled(false);
            this.getViewButton().setEnabled(false);
            return;
        }
        if (this.tableSelection == 1) {
            this.getUpButton().setEnabled(false);
            this.getLoadErrorTestResultButton().setEnabled(true);
            this.getDeleteButton().setEnabled(true);
            this.getInspectButton().setEnabled(true);
            this.getViewButton().setEnabled(false);
            return;
        }
        if (this.tableSelection == 2) {
            this.getUpButton().setEnabled(true);
            this.getLoadErrorTestResultButton().setEnabled(true);
            this.getDeleteButton().setEnabled(false);
            this.getInspectButton().setEnabled(false);
            this.getViewButton().setEnabled(false);
            return;
        }
        if (this.tableSelection == 3) {
            this.getUpButton().setEnabled(true);
            this.getLoadErrorTestResultButton().setEnabled(false);
            this.getDeleteButton().setEnabled(false);
            this.getInspectButton().setEnabled(false);
            this.getViewButton().setEnabled(true);
        }
    }

    public void selectFirstRow() {
        if (this.getSelectedTable().getRowCount() > 0) {
            this.getSelectedTable().setRowSelectionInterval(0, 0);
        }
    }

    public void setSession(DatabaseSession session) {
        this.session = session;
    }

    public void up() {
        int index = this.getSelectedTable().getSelectedRow();
        if (index < 0) {
            return;
        }
        if (this.tableSelection == 2) {
            TestResultsSummary summary = (TestResultsSummary)this.testSummaryCahce.elementAt(index);
            int upIndex = this.getUpIndex(summary);
            if (summary.getParent() == null) {
                this.poppulateLoadBuildTable(this.loadBuildsCache);
            } else {
                this.poppulateTestSummaryTable(this.testSummaryCahce);
            }
            this.getSelectedTable().setRowSelectionInterval(upIndex, upIndex);
        } else if (this.tableSelection == 3) {
            TestResult result = (TestResult)this.testResultsCahce.elementAt(index);
            int upIndex = this.getUpIndex(result);
            if (result.getSummary() != null) {
                this.poppulateTestSummaryTable(this.testSummaryCahce);
            } else {
                this.poppulateLoadBuildTable(this.loadBuildsCache);
            }
            this.getSelectedTable().setRowSelectionInterval(upIndex, upIndex);
        }
    }

    public void viewStackTrace() {
        this.getViewTextArea().setText("");
        int index = this.getSelectedTable().getSelectedRow();
        if (index < 0) {
            return;
        }
        TestResult result = (TestResult)this.testResultsCahce.elementAt(index);
        this.getViewTextArea().setText(result.getExceptionStackTrace());
        this.getLoadBuildTabbedPanel().setSelectedComponent(this.getViewPage());
        this.getViewTextArea().setCaretPosition(1);
    }
}

