/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.advanced;

import org.eclipse.persistence.internal.jpa.EntityManagerImpl;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.jpa.advanced.Employee;
import org.eclipse.persistence.testing.models.jpa.advanced.ModelExamples;
import org.eclipse.persistence.testing.models.jpa.advanced.PhoneNumber;
import org.eclipse.persistence.testing.models.jpa.advanced.Project;
import org.eclipse.persistence.testing.models.jpa.advanced.SmallProject;
import org.eclipse.persistence.testing.tests.jpa.EntityContainerTestBase;

public class CallbackEventTest
extends EntityContainerTestBase {
    protected boolean reset = false;
    protected Project m_project;
    protected Employee m_employee;
    protected int m_beforeEvent;
    protected int m_afterEvent;

    @Override
    public void setup() {
        super.setup();
        this.reset = true;
        this.m_employee = new Employee();
        this.m_project = new SmallProject();
        try {
            this.beginTransaction();
            this.m_employee.setFirstName("Guy");
            this.m_employee.setLastName("Pelletier");
            this.getEntityManager().persist((Object)this.m_employee);
            this.m_project.setName("A tiny project");
            this.m_project.setDescription("Must be an easy one");
            this.getEntityManager().persist((Object)this.m_project);
            this.commitTransaction();
        }
        catch (Exception ex) {
            this.rollbackTransaction();
            throw new TestErrorException("Exception thrown during setup try to create an employee" + ex);
        }
        ((EntityManagerImpl)this.getEntityManager()).getActiveSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    @Override
    public void reset() {
        if (this.reset) {
            this.reset = false;
        }
        super.reset();
    }

    public void verify() {
        if (this.m_afterEvent - this.m_beforeEvent != 1) {
            throw new TestErrorException("The callback method was called " + (this.m_afterEvent - this.m_beforeEvent) + " times.  It should have been called only once");
        }
    }

    protected Employee persistNewEmployee() throws Exception {
        Employee employee = null;
        this.beginTransaction();
        try {
            employee = new Employee();
            employee.setFirstName("Kirty");
            employee.setLastName("Pelletier");
            this.getEntityManager().persist((Object)employee);
            this.commitTransaction();
        }
        catch (RuntimeException ex) {
            this.rollbackTransaction();
            throw ex;
        }
        return employee;
    }

    protected void removeEmployee() throws Exception {
        this.beginTransaction();
        this.getEntityManager().remove(this.getEntityManager().find(Employee.class, (Object)this.m_employee.getId()));
        this.commitTransaction();
    }

    protected void updateEmployee() throws Exception {
        this.beginTransaction();
        Employee emp = (Employee)this.getEntityManager().find(Employee.class, (Object)this.m_employee.getId());
        emp.setFirstName("New name");
        this.commitTransaction();
    }

    protected void updateEmployeePhoneNumber() throws Exception {
        this.beginTransaction();
        try {
            Employee emp = (Employee)this.getEntityManager().find(Employee.class, (Object)this.m_employee.getId());
            PhoneNumber phone = ModelExamples.phoneExample1();
            phone.setOwner(emp);
            emp.getPhoneNumbers().add(phone);
            this.commitTransaction();
        }
        catch (RuntimeException ex) {
            this.rollbackTransaction();
            throw ex;
        }
    }

    protected Project persistNewProject() throws Exception {
        Project project = null;
        this.beginTransaction();
        try {
            project = new Project();
            project.setName("Kirty's Project");
            project.setDescription("A government project");
            this.getEntityManager().persist((Object)project);
            this.commitTransaction();
        }
        catch (RuntimeException ex) {
            this.rollbackTransaction();
            throw ex;
        }
        return project;
    }

    protected Project removeProject() throws Exception {
        Project project = null;
        this.beginTransaction();
        try {
            project = (Project)this.getEntityManager().find(Project.class, (Object)this.m_project.getId());
            this.getEntityManager().remove((Object)project);
            this.commitTransaction();
        }
        catch (RuntimeException ex) {
            this.rollbackTransaction();
            throw ex;
        }
        return project;
    }

    protected Project updateProject() throws Exception {
        Project project = null;
        this.beginTransaction();
        try {
            project = (Project)this.getEntityManager().find(Project.class, (Object)this.m_project.getId());
            project.setDescription("Now a tough project");
            this.commitTransaction();
        }
        catch (RuntimeException ex) {
            this.rollbackTransaction();
            throw ex;
        }
        return project;
    }
}

