/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.advanced;

import org.eclipse.persistence.jpa.JpaEntityManager;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.jpa.advanced.Employee;
import org.eclipse.persistence.testing.models.jpa.advanced.PhoneNumber;
import org.eclipse.persistence.testing.models.jpa.advanced.Project;
import org.eclipse.persistence.testing.tests.jpa.EntityContainerTestBase;

public class EMCascadingPersistAndCommitTest
extends EntityContainerTestBase {
    public Integer[] empIDs = new Integer[2];

    public EMCascadingPersistAndCommitTest() {
        this.setDescription("Test cascading persist and commit in EntityManager");
    }

    public void test() {
        Employee employee = new Employee();
        employee.setFirstName("First");
        employee.setLastName("Bean");
        Project project = new Project();
        project.setName("Project # 1");
        project.setDescription("A simple Project");
        PhoneNumber phone = new PhoneNumber("Work", "613", "9876543");
        employee.addProject(project);
        employee.addPhoneNumber(phone);
        try {
            this.beginTransaction();
            this.getEntityManager().persist((Object)employee);
            this.empIDs[0] = employee.getId();
            this.commitTransaction();
        }
        catch (Exception ex) {
            this.rollbackTransaction();
            throw new TestErrorException("Exception thrown durring persist and flush" + ex);
        }
    }

    public void verify() {
        Employee emp = (Employee)this.getEntityManager().find(Employee.class, (Object)this.empIDs[0]);
        if (emp == null) {
            throw new TestErrorException("Employee, empID: " + this.empIDs[0] + " Not created");
        }
        if (emp.getProjects().size() != 1) {
            throw new TestErrorException("Employee, empID: " + this.empIDs[0] + " Project not added");
        }
        if (emp.getPhoneNumbers().size() != 1) {
            throw new TestErrorException("Employee, empID: " + this.empIDs[0] + " PhoneNumber not added");
        }
        ((JpaEntityManager)this.getEntityManager()).getActiveSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        emp = (Employee)this.getEntityManager().find(Employee.class, (Object)this.empIDs[0]);
        if (emp == null) {
            throw new TestErrorException("Employee, empID: " + this.empIDs[0] + " Not created");
        }
        if (emp.getProjects().size() != 1) {
            throw new TestErrorException("Employee, empID: " + this.empIDs[0] + " Project not added");
        }
        if (emp.getPhoneNumbers().size() != 1) {
            throw new TestErrorException("Employee, empID: " + this.empIDs[0] + " PhoneNumber not added");
        }
    }
}

