/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.dynamic.simple;

import java.util.Calendar;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.dynamic.DynamicClassLoader;
import org.eclipse.persistence.dynamic.DynamicEntity;
import org.eclipse.persistence.dynamic.DynamicType;
import org.eclipse.persistence.internal.dynamic.DynamicTypeImpl;
import org.eclipse.persistence.jpa.JpaHelper;
import org.eclipse.persistence.jpa.dynamic.JPADynamicHelper;
import org.eclipse.persistence.jpa.dynamic.JPADynamicTypeBuilder;
import org.eclipse.persistence.sessions.IdentityMapAccessor;
import org.eclipse.persistence.sessions.server.Server;
import org.eclipse.persistence.testing.tests.jpa.dynamic.DynamicTestHelper;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class SimpleTypeTestSuite {
    static EntityManagerFactory emf = null;
    static JPADynamicHelper helper = null;
    static DynamicType simpleType = null;

    @BeforeClass
    public static void setUp() throws Exception {
        emf = DynamicTestHelper.createEMF("dynamic");
        helper = new JPADynamicHelper(emf);
        DynamicClassLoader dcl = helper.getDynamicClassLoader();
        Class javaType = dcl.createDynamicClass("model.Simple");
        JPADynamicTypeBuilder typeBuilder = new JPADynamicTypeBuilder(javaType, null, new String[]{"SIMPLE_TYPE"});
        typeBuilder.setPrimaryKeyFields(new String[]{"SID"});
        typeBuilder.addDirectMapping("id", Integer.TYPE, "SID");
        typeBuilder.addDirectMapping("value1", String.class, "VAL_1");
        typeBuilder.addDirectMapping("value2", Boolean.TYPE, "VAL_2");
        typeBuilder.addDirectMapping("value3", Calendar.class, "VAL_3");
        typeBuilder.addDirectMapping("value4", Character.class, "VAL_4");
        helper.addTypes(true, true, new DynamicType[]{typeBuilder.getType()});
        simpleType = helper.getType("Simple");
    }

    @AfterClass
    public static void tearDown() throws Exception {
        if (emf != null && emf.isOpen()) {
            EntityManager em = emf.createEntityManager();
            em.getTransaction().begin();
            em.createNativeQuery("DROP TABLE SIMPLE_TYPE").executeUpdate();
            em.getTransaction().commit();
            em.close();
            emf.close();
        }
    }

    @Before
    @After
    public void clearSimpleTypeInstances() {
        if (emf != null && emf.isOpen()) {
            EntityManager em = emf.createEntityManager();
            em.getTransaction().begin();
            em.createQuery("DELETE FROM Simple").executeUpdate();
            em.getTransaction().commit();
            em.close();
        }
        JpaHelper.getServerSession((EntityManagerFactory)emf).getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    @Test
    public void verifyConfig() throws Exception {
        ClassDescriptor descriptor = helper.getSession().getClassDescriptorForAlias("Simple");
        Assert.assertNotNull((String)"No descriptor found for alias='Simple'", (Object)descriptor);
        DynamicTypeImpl simpleTypeImpl = (DynamicTypeImpl)simpleType;
        Assert.assertNotNull((String)"'Simple' EntityType not found", (Object)simpleTypeImpl);
        Assert.assertEquals((long)(1 + descriptor.getPrimaryKeyFields().size()), (long)simpleTypeImpl.getMappingsRequiringInitialization().size());
        Assert.assertEquals((Object)descriptor, (Object)simpleTypeImpl.getDescriptor());
    }

    @Test
    public void find() {
        this.createSimpleInstance(1);
        EntityManager em = emf.createEntityManager();
        DynamicEntity simpleInstance = this.find(em, 1);
        Assert.assertNotNull((String)"Could not find simple instance with id = 1", (Object)simpleInstance);
        simpleInstance = this.find(em, new Integer(1));
        Assert.assertNotNull((String)"Could not find simple instance with id = Integer(1)", (Object)simpleInstance);
    }

    @Test
    public void simpleInstance_CRUD() {
        Server session = JpaHelper.getServerSession((EntityManagerFactory)emf);
        IdentityMapAccessor cache = session.getIdentityMapAccessor();
        DynamicEntity simpleInstance = this.createSimpleInstance(1);
        Assert.assertNotNull((Object)simpleInstance);
        Assert.assertTrue((boolean)cache.containsObjectInIdentityMap((Object)simpleInstance));
        cache.initializeAllIdentityMaps();
        Assert.assertFalse((boolean)cache.containsObjectInIdentityMap((Object)simpleInstance));
        EntityManager em = emf.createEntityManager();
        Assert.assertFalse((boolean)em.contains((Object)simpleInstance));
        simpleInstance = (DynamicEntity)em.merge((Object)simpleInstance);
        Assert.assertTrue((boolean)em.contains((Object)simpleInstance));
        em.close();
    }

    @Test
    public void verifyDefaultValuesFromEntityType() throws Exception {
        Assert.assertNotNull((Object)simpleType);
        DynamicEntity simpleInstance = simpleType.newDynamicEntity();
        this.assertDefaultValues(simpleInstance);
    }

    @Test
    public void verifyDefaultValuesFromDescriptor() throws Exception {
        DynamicTypeImpl simpleTypeImpl = (DynamicTypeImpl)simpleType;
        Assert.assertNotNull((Object)simpleTypeImpl);
        DynamicEntity simpleInstance = (DynamicEntity)simpleTypeImpl.getDescriptor().getObjectBuilder().buildNewInstance();
        this.assertDefaultValues(simpleInstance);
    }

    protected void assertDefaultValues(DynamicEntity simpleInstance) {
        Assert.assertNotNull((Object)simpleInstance);
        Assert.assertEquals((String)"id not default value", (long)0L, (long)((Integer)simpleInstance.get("id")).intValue());
        Assert.assertFalse((String)"value1 set on new instance", (boolean)simpleInstance.isSet("value1"));
        Assert.assertEquals((String)"value2 not default value on new instance", (Object)false, (Object)((Boolean)simpleInstance.get("value2")));
        Assert.assertFalse((String)"value3 set on new instance", (boolean)simpleInstance.isSet("value3"));
        Assert.assertFalse((String)"value4 set on new instance", (boolean)simpleInstance.isSet("value4"));
    }

    public DynamicEntity createSimpleInstance(int id) {
        EntityManager em = emf.createEntityManager();
        Assert.assertNotNull((Object)simpleType);
        DynamicEntity simpleInstance = simpleType.newDynamicEntity();
        simpleInstance.set("id", (Object)id);
        simpleInstance.set("value2", (Object)true);
        Assert.assertEquals((long)0L, (long)((Number)em.createQuery("SELECT COUNT(s) FROM Simple s").getSingleResult()).intValue());
        em.getTransaction().begin();
        em.persist((Object)simpleInstance);
        em.getTransaction().commit();
        Assert.assertEquals((long)1L, (long)((Number)em.createQuery("SELECT COUNT(s) FROM Simple s").getSingleResult()).intValue());
        DynamicEntity foundEntity = this.find(em, 1);
        Assert.assertNotNull((Object)foundEntity);
        Assert.assertEquals((Object)simpleInstance.get("id"), (Object)foundEntity.get("id"));
        Assert.assertEquals((Object)simpleInstance.get("value1"), (Object)foundEntity.get("value1"));
        Assert.assertEquals((Object)simpleInstance.get("value2"), (Object)foundEntity.get("value2"));
        em.close();
        return simpleInstance;
    }

    protected DynamicEntity find(EntityManager em, Object id) {
        return (DynamicEntity)em.find(simpleType.getJavaClass(), id);
    }
}

