/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.fetchgroups;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.persistence.internal.core.queries.CoreAttributeConverter;
import org.eclipse.persistence.internal.queries.AttributeItem;
import org.eclipse.persistence.queries.FetchGroup;

public class FetchGroupAPITests
extends TestCase {
    public FetchGroupAPITests() {
    }

    public FetchGroupAPITests(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("FetchGroupAPITests");
        suite.addTest((Test)new FetchGroupAPITests("verifyConverterWithValidSingleElements"));
        suite.addTest((Test)new FetchGroupAPITests("verifyConverterWithValidComplexElements"));
        suite.addTest((Test)new FetchGroupAPITests("verifyConverterWithValidArrays"));
        suite.addTest((Test)new FetchGroupAPITests("verifyConverterWithInvalidSingleElements"));
        suite.addTest((Test)new FetchGroupAPITests("verifyConverterWithInvalidComplexElements"));
        suite.addTest((Test)new FetchGroupAPITests("verifyConverterWithInvalidArrays"));
        suite.addTest((Test)new FetchGroupAPITests("verifyDefaultConstructor"));
        suite.addTest((Test)new FetchGroupAPITests("verifyNameConstructor"));
        suite.addTest((Test)new FetchGroupAPITests("verifyNameConstructor_Null"));
        suite.addTest((Test)new FetchGroupAPITests("verifyInvalidAdd_null"));
        suite.addTest((Test)new FetchGroupAPITests("verifyInvalidAdd_empty"));
        suite.addTest((Test)new FetchGroupAPITests("verifyInvalidAdd_dot"));
        suite.addTest((Test)new FetchGroupAPITests("verifyInvalidAdd_startWithDot"));
        suite.addTest((Test)new FetchGroupAPITests("verifyInvalidAdd_endWithDot"));
        suite.addTest((Test)new FetchGroupAPITests("verifyInvalidAdd_space"));
        suite.addTest((Test)new FetchGroupAPITests("verifygetItem_EmptyFG"));
        suite.addTest((Test)new FetchGroupAPITests("verifyAddAttribute"));
        suite.addTest((Test)new FetchGroupAPITests("verifyAddAttribute_Nested"));
        suite.addTest((Test)new FetchGroupAPITests("verifyAdd2AttributesNestedFG"));
        suite.addTest((Test)new FetchGroupAPITests("verifyAdd2AttributesNestedFG_parentFirst"));
        suite.addTest((Test)new FetchGroupAPITests("verifyAddAttribute_Nested2"));
        suite.addTest((Test)new FetchGroupAPITests("verifyAdd"));
        suite.addTest((Test)new FetchGroupAPITests("verifyAdd_Nested"));
        return suite;
    }

    @org.junit.Test
    public void verifyConverterWithValidSingleElements() {
        String[][] elements;
        for (String[] element : elements = new String[][]{{"a"}, {"ab"}, {"abc"}, {"abcd"}, {"a b"}, {"a b c"}, {"ab cd"}}) {
            String[] result = CoreAttributeConverter.convert((String[])element);
            FetchGroupAPITests.assertNotNull((String)("Converter returned null for input: \"" + element[0] + "\""), (Object)result);
            FetchGroupAPITests.assertEquals((String)("Size of returned array differs from input: \"" + element[0] + "\""), (int)element.length, (int)result.length);
            FetchGroupAPITests.assertTrue((String)("Returned String does not match input: \"" + element[0] + "\""), (boolean)element[0].equals(result[0]));
        }
    }

    @org.junit.Test
    public void verifyConverterWithValidComplexElements() {
        String[][] paths;
        for (String[] path : paths = new String[][]{{"a", "b"}, {"a", "b", "c"}, {"a", "b", "c", "d"}, {"a b", "c d"}, {"a b", "c d", "e f"}}) {
            int i;
            int length = 0;
            for (i = 0; i < path.length; ++i) {
                length += path[i].length() + 1;
            }
            StringBuilder element = new StringBuilder(length);
            for (i = 0; i < path.length; ++i) {
                if (i > 0) {
                    element.append('.');
                }
                element.append(path[i]);
            }
            String elStr = element.toString();
            String[] result = CoreAttributeConverter.convert((String[])new String[]{elStr});
            FetchGroupAPITests.assertNotNull((String)("Converter returned null for input: \"" + elStr + "\""), (Object)result);
            FetchGroupAPITests.assertEquals((String)("Size of returned array differs from input: \"" + elStr + "\""), (int)path.length, (int)result.length);
            for (i = 0; i < path.length; ++i) {
                FetchGroupAPITests.assertTrue((String)("Returned String array does not match input: \"" + elStr + "\""), (boolean)path[i].equals(result[i]));
            }
        }
    }

    @org.junit.Test
    public void verifyConverterWithValidArrays() {
        String[][] paths;
        for (String[] path : paths = new String[][]{{"a", "b"}, {"a", "b", "c"}, {"a", "b", "c", "d"}, {"a b", "c d"}, {"a b", "c d", "e f"}}) {
            int i;
            String[] result = CoreAttributeConverter.convert((String[])path);
            StringBuilder sb = new StringBuilder();
            for (i = 0; i < path.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append('\"').append(path[i]).append('\"');
            }
            FetchGroupAPITests.assertNotNull((String)("Converter returned null for input: " + sb.toString()), (Object)result);
            FetchGroupAPITests.assertEquals((String)("Size of returned array differs from input: " + sb.toString()), (int)path.length, (int)result.length);
            for (i = 0; i < path.length; ++i) {
                FetchGroupAPITests.assertTrue((String)("Returned String array does not match input array: " + sb.toString()), (boolean)path[i].equals(result[i]));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @org.junit.Test
    public void verifyConverterWithInvalidSingleElements() {
        String[][] elements = new String[][]{{null}, {""}, {" "}, {" a"}, {"a "}, {" a "}, {" a b"}, {"a b "}, {" a b "}};
        boolean exception = false;
        for (String[] element : elements) {
            try {
                exception = false;
                String[] result = CoreAttributeConverter.convert((String[])element);
            }
            catch (IllegalArgumentException ex) {
                exception = true;
            }
            finally {
                FetchGroupAPITests.assertTrue((String)("Converter did not throw IllegalArgumentException on invalid input: \"" + element[0] + "\""), (boolean)exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @org.junit.Test
    public void verifyConverterWithInvalidComplexElements() {
        String[][] paths = new String[][]{{"", "b"}, {"a", ""}, {" ", "b"}, {"a", " "}, {"", ""}, {" ", " "}, {" a", "b"}, {"a", " b"}, {"a ", "b"}, {"a", "b "}, {" a ", "b"}, {"a", " b "}};
        boolean exception = false;
        for (String[] path : paths) {
            int i;
            int length = 0;
            for (i = 0; i < path.length; ++i) {
                length += path[i].length() + 1;
            }
            StringBuilder element = new StringBuilder(length);
            for (i = 0; i < path.length; ++i) {
                if (i > 0) {
                    element.append('.');
                }
                element.append(path[i]);
            }
            String elStr = element.toString();
            try {
                exception = false;
                String[] result = CoreAttributeConverter.convert((String[])new String[]{elStr});
            }
            catch (IllegalArgumentException ex) {
                exception = true;
            }
            finally {
                FetchGroupAPITests.assertTrue((String)("Converter did not throw IllegalArgumentException on invalid input: \"" + elStr + "\""), (boolean)exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @org.junit.Test
    public void verifyConverterWithInvalidArrays() {
        String[][] paths = new String[][]{{"", "b"}, {"a", ""}, {" ", "b"}, {"a", " "}, {"", ""}, {" ", " "}, {" a", "b"}, {"a", " b"}, {"a ", "b"}, {"a", "b "}, {" a ", "b"}, {"a", " b "}};
        boolean exception = false;
        for (String[] path : paths) {
            try {
                exception = false;
                String[] result = CoreAttributeConverter.convert((String[])path);
            }
            catch (IllegalArgumentException ex) {
                exception = true;
            }
            finally {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < path.length; ++i) {
                    if (i > 0) {
                        sb.append(", ");
                    }
                    sb.append('\"').append(path[i]).append('\"');
                }
                FetchGroupAPITests.assertTrue((String)("Converter did not throw IllegalArgumentException on invalid input: " + sb.toString()), (boolean)exception);
            }
        }
    }

    @org.junit.Test
    public void verifyDefaultConstructor() {
        FetchGroup fg = new FetchGroup();
        FetchGroupAPITests.assertEquals((String)"default FetchGroup name is not an empty string", (String)fg.getName(), (String)"");
        FetchGroupAPITests.assertTrue((boolean)fg.getItems().isEmpty());
    }

    @org.junit.Test
    public void verifyNameConstructor() {
        FetchGroup fg = new FetchGroup("Test");
        FetchGroupAPITests.assertEquals((String)"Test name not set", (String)"Test", (String)fg.getName());
        FetchGroupAPITests.assertTrue((boolean)fg.getItems().isEmpty());
        fg.toString();
    }

    @org.junit.Test
    public void verifyNameConstructor_Null() {
        FetchGroup fg = new FetchGroup(null);
        FetchGroupAPITests.assertNull((String)"Null name not set", (Object)fg.getName());
        FetchGroupAPITests.assertTrue((boolean)fg.getItems().isEmpty());
        fg.toString();
    }

    private void verifyInvalid(String arg) {
        FetchGroup fg = new FetchGroup();
        try {
            fg.addAttribute(arg);
        }
        catch (IllegalArgumentException iae) {
            return;
        }
        FetchGroupAPITests.fail((String)"IllegalArgumentException expected but not caught.");
    }

    @org.junit.Test
    public void verifyInvalidAdd_null() {
        this.verifyInvalid(null);
    }

    @org.junit.Test
    public void verifyInvalidAdd_empty() {
        this.verifyInvalid("");
    }

    @org.junit.Test
    public void verifyInvalidAdd_dot() {
        this.verifyInvalid(".");
        this.verifyInvalid("..");
        this.verifyInvalid(". ");
        this.verifyInvalid(" .");
        this.verifyInvalid(" . ");
        this.verifyInvalid(". .");
    }

    @org.junit.Test
    public void verifyInvalidAdd_startWithDot() {
        this.verifyInvalid(".name");
    }

    @org.junit.Test
    public void verifyInvalidAdd_endWithDot() {
        this.verifyInvalid("name.");
    }

    @org.junit.Test
    public void verifyInvalidAdd_space() {
        this.verifyInvalid(" ");
        this.verifyInvalid("\t");
        this.verifyInvalid("\n");
        this.verifyInvalid("\r");
    }

    @org.junit.Test
    public void verifygetItem_EmptyFG() {
        FetchGroup fg = new FetchGroup();
        FetchGroupAPITests.assertTrue((boolean)fg.getItems().isEmpty());
        FetchGroupAPITests.assertNull((Object)fg.getItem("test"));
        FetchGroupAPITests.assertNull((Object)fg.getItem("a.b"));
        FetchGroupAPITests.assertTrue((boolean)fg.getItems().isEmpty());
    }

    @org.junit.Test
    public void verifyAddAttribute() {
        FetchGroup fg = new FetchGroup();
        fg.addAttribute("test");
        FetchGroupAPITests.assertEquals((int)1, (int)fg.getItems().size());
        FetchGroupAPITests.assertTrue((boolean)fg.getItems().containsKey("test"));
        FetchGroupAPITests.assertNotNull(fg.getItems().get("test"));
        AttributeItem item = fg.getItem("test");
        FetchGroupAPITests.assertNotNull((Object)item);
        FetchGroupAPITests.assertEquals((String)"test", (String)item.getAttributeName());
    }

    @org.junit.Test
    public void verifyAddAttribute_Nested() {
        FetchGroup fg = new FetchGroup();
        fg.addAttribute("test.test");
        FetchGroupAPITests.assertEquals((int)1, (int)fg.getItems().size());
        FetchGroupAPITests.assertTrue((boolean)fg.getItems().containsKey("test"));
        AttributeItem testFI = (AttributeItem)fg.getItems().get("test");
        FetchGroupAPITests.assertNotNull((Object)testFI);
        FetchGroupAPITests.assertEquals((String)"test", (String)testFI.getAttributeName());
        FetchGroupAPITests.assertNotNull((Object)testFI.getGroup());
        FetchGroupAPITests.assertEquals((String)"test", (String)testFI.getGroup().getName());
        testFI = fg.getItem("test");
        FetchGroupAPITests.assertNotNull((Object)testFI);
        FetchGroupAPITests.assertEquals((String)"test", (String)testFI.getAttributeName());
        FetchGroupAPITests.assertEquals((int)1, (int)testFI.getGroup().getItems().size());
        FetchGroupAPITests.assertTrue((boolean)testFI.getGroup().getItems().containsKey("test"));
        FetchGroupAPITests.assertNotNull((Object)testFI.getGroup().getItem("test"));
    }

    @org.junit.Test
    public void verifyAdd2AttributesNestedFG() {
        FetchGroup fg = new FetchGroup();
        fg.addAttribute("a.b");
        fg.addAttribute("a.c");
        FetchGroupAPITests.assertEquals((int)1, (int)fg.getItems().size());
        FetchGroupAPITests.assertTrue((boolean)fg.getItems().containsKey("a"));
        AttributeItem aItem = fg.getItem("a");
        FetchGroup aFG = (FetchGroup)aItem.getGroup();
        FetchGroupAPITests.assertNotNull((Object)aItem);
        FetchGroupAPITests.assertNotNull((Object)aFG);
        FetchGroupAPITests.assertEquals((int)2, (int)aFG.getItems().size());
        FetchGroupAPITests.assertEquals((String)"a", (String)aFG.getName());
        AttributeItem bItem = aFG.getItem("b");
        FetchGroupAPITests.assertNotNull((Object)bItem);
        FetchGroupAPITests.assertEquals((String)"b", (String)bItem.getAttributeName());
        FetchGroupAPITests.assertNull((Object)bItem.getGroup());
        FetchGroupAPITests.assertSame((Object)bItem, (Object)fg.getItem("a.b"));
        AttributeItem cItem = aFG.getItem("c");
        FetchGroupAPITests.assertNotNull((Object)cItem);
        FetchGroupAPITests.assertEquals((String)"c", (String)cItem.getAttributeName());
        FetchGroupAPITests.assertNull((Object)cItem.getGroup());
        FetchGroupAPITests.assertSame((Object)cItem, (Object)fg.getItem("a.c"));
    }

    @org.junit.Test
    public void verifyAdd2AttributesNestedFG_parentFirst() {
        FetchGroup fg = new FetchGroup();
        fg.addAttribute("a");
        fg.addAttribute("a.b");
        fg.addAttribute("a.c");
        FetchGroupAPITests.assertEquals((int)1, (int)fg.getItems().size());
        FetchGroupAPITests.assertTrue((boolean)fg.getItems().containsKey("a"));
        AttributeItem aItem = fg.getItem("a");
        FetchGroup aFG = (FetchGroup)aItem.getGroup();
        FetchGroupAPITests.assertNotNull((Object)aItem);
        FetchGroupAPITests.assertNotNull((Object)aFG);
        FetchGroupAPITests.assertEquals((int)2, (int)aFG.getItems().size());
        FetchGroupAPITests.assertEquals((String)"a", (String)aFG.getName());
        AttributeItem bItem = aFG.getItem("b");
        FetchGroupAPITests.assertNotNull((Object)bItem);
        FetchGroupAPITests.assertEquals((String)"b", (String)bItem.getAttributeName());
        FetchGroupAPITests.assertNull((Object)bItem.getGroup());
        FetchGroupAPITests.assertSame((Object)bItem, (Object)fg.getItem("a.b"));
        AttributeItem cItem = aFG.getItem("c");
        FetchGroupAPITests.assertNotNull((Object)cItem);
        FetchGroupAPITests.assertEquals((String)"c", (String)cItem.getAttributeName());
        FetchGroupAPITests.assertNull((Object)cItem.getGroup());
        FetchGroupAPITests.assertSame((Object)cItem, (Object)fg.getItem("a.c"));
    }

    @org.junit.Test
    public void verifyAddAttribute_Nested2() {
        FetchGroup fg = new FetchGroup();
        fg.addAttribute("test.test.test");
        FetchGroupAPITests.assertEquals((int)1, (int)fg.getItems().size());
        FetchGroupAPITests.assertTrue((boolean)fg.getItems().containsKey("test"));
        AttributeItem testFI = (AttributeItem)fg.getItems().get("test");
        FetchGroupAPITests.assertNotNull((Object)testFI);
        FetchGroupAPITests.assertEquals((String)"test", (String)testFI.getAttributeName());
        testFI = fg.getItem("test");
        FetchGroupAPITests.assertNotNull((Object)testFI);
        FetchGroupAPITests.assertEquals((String)"test", (String)testFI.getAttributeName());
        FetchGroupAPITests.assertNotNull((Object)testFI.getGroup());
        AttributeItem testFI2 = (AttributeItem)testFI.getGroup().getItems().get("test");
        FetchGroupAPITests.assertNotNull((Object)testFI2);
        FetchGroupAPITests.assertEquals((String)"test", (String)testFI2.getAttributeName());
        FetchGroupAPITests.assertNotNull((Object)testFI2.getGroup());
        FetchGroupAPITests.assertEquals((String)"test", (String)testFI2.getGroup().getName());
        FetchGroupAPITests.assertFalse((boolean)testFI2.getGroup().getItems().isEmpty());
        testFI2 = testFI.getGroup().getItem("test");
        FetchGroupAPITests.assertNotNull((Object)testFI2);
        FetchGroupAPITests.assertEquals((String)"test", (String)testFI2.getAttributeName());
        FetchGroupAPITests.assertFalse((boolean)testFI2.getGroup().getItems().isEmpty());
        FetchGroupAPITests.assertEquals((int)1, (int)testFI2.getGroup().getItems().size());
        FetchGroupAPITests.assertTrue((boolean)testFI2.getGroup().getItems().containsKey("test"));
        FetchGroupAPITests.assertNotNull(testFI2.getGroup().getItems().get("test"));
        testFI2 = fg.getItem("test.test");
        FetchGroupAPITests.assertNotNull((Object)testFI2);
        FetchGroupAPITests.assertEquals((String)"test", (String)testFI2.getGroup().getName());
    }

    @org.junit.Test
    public void verifyAdd() {
        FetchGroup fg = new FetchGroup();
        fg.addAttribute("test");
        FetchGroupAPITests.assertEquals((int)1, (int)fg.getItems().size());
        FetchGroupAPITests.assertTrue((boolean)fg.getItems().containsKey("test"));
        FetchGroupAPITests.assertNotNull(fg.getItems().get("test"));
        FetchGroupAPITests.assertNotNull((Object)fg.getItem("test"));
    }

    @org.junit.Test
    public void verifyAdd_Nested() {
        FetchGroup fg = new FetchGroup();
        fg.addAttribute("test.test");
        FetchGroupAPITests.assertEquals((int)1, (int)fg.getItems().size());
        FetchGroupAPITests.assertTrue((boolean)fg.getItems().containsKey("test"));
        AttributeItem testFI = (AttributeItem)fg.getItems().get("test");
        FetchGroupAPITests.assertNotNull((Object)testFI);
        FetchGroupAPITests.assertEquals((String)"test", (String)testFI.getAttributeName());
        testFI = fg.getItem("test");
        FetchGroupAPITests.assertNotNull((Object)testFI);
        FetchGroupAPITests.assertEquals((String)"test", (String)testFI.getAttributeName());
        FetchGroupAPITests.assertEquals((int)1, (int)testFI.getGroup().getItems().size());
        FetchGroupAPITests.assertTrue((boolean)testFI.getGroup().getItems().containsKey("test"));
        FetchGroupAPITests.assertNotNull((Object)testFI.getGroup().getItem("test"));
    }
}

