/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.gen.internal.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class FileUtil {
    public static byte[] readFile(File src) throws IOException {
        FileInputStream fin = new FileInputStream(src);
        try {
            long fileLen = src.length();
            if (fileLen > Integer.MAX_VALUE) {
                throw new IOException("file length too big to be read by FileUtil.readFile: " + fileLen);
            }
            byte[] bytes = new byte[(int)fileLen];
            fin.read(bytes);
            byte[] byArray = bytes;
            return byArray;
        }
        finally {
            fin.close();
        }
    }

    public static void writeFile(File dest, byte[] bytes) throws IOException {
        if (dest.exists() && !dest.canWrite()) {
            throw new IOException();
        }
        FileOutputStream fout = new FileOutputStream(dest.getPath(), false);
        try {
            fout.write(bytes);
        }
        finally {
            fout.flush();
            fout.close();
        }
    }
}

