/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.tests;

import java.lang.reflect.InvocationTargetException;
import junit.framework.TestCase;
import org.eclipse.persistence.tools.utility.BitTools;
import org.eclipse.persistence.tools.utility.ClassTools;

public class BitToolsTests
extends TestCase {
    public BitToolsTests(String name) {
        super(name);
    }

    public void testFlagIsSetIntInt() {
        BitToolsTests.assertTrue((boolean)BitTools.flagIsSet((int)3, (int)1));
        BitToolsTests.assertTrue((boolean)BitTools.flagIsSet((int)771, (int)1));
        BitToolsTests.assertTrue((boolean)BitTools.flagIsSet((int)771, (int)257));
        BitToolsTests.assertTrue((boolean)BitTools.flagIsSet((int)771, (int)259));
        BitToolsTests.assertFalse((boolean)BitTools.flagIsSet((int)771, (int)4355));
        BitToolsTests.assertFalse((boolean)BitTools.flagIsSet((int)0, (int)4355));
    }

    public void testSetFlagIntInt() {
        BitToolsTests.assertEquals((int)3, (int)BitTools.setFlag((int)3, (int)1));
        BitToolsTests.assertEquals((int)4867, (int)BitTools.setFlag((int)771, (int)4355));
        BitToolsTests.assertEquals((int)4355, (int)BitTools.setFlag((int)0, (int)4355));
    }

    public void testFlagIsOffIntInt() {
        BitToolsTests.assertFalse((boolean)BitTools.flagIsOff((int)3, (int)1));
        BitToolsTests.assertFalse((boolean)BitTools.flagIsOff((int)771, (int)1));
        BitToolsTests.assertFalse((boolean)BitTools.flagIsOff((int)771, (int)257));
        BitToolsTests.assertFalse((boolean)BitTools.flagIsOff((int)771, (int)259));
        BitToolsTests.assertTrue((boolean)BitTools.flagIsOff((int)8708, (int)4355));
        BitToolsTests.assertTrue((boolean)BitTools.flagIsOff((int)0, (int)4355));
    }

    public void testClearFlagIntInt() {
        BitToolsTests.assertEquals((int)2, (int)BitTools.clearFlag((int)3, (int)1));
        BitToolsTests.assertEquals((int)512, (int)BitTools.clearFlag((int)771, (int)4355));
        BitToolsTests.assertEquals((int)0, (int)BitTools.clearFlag((int)0, (int)4355));
    }

    public void testOnlyFlagIsSetIntInt() {
        BitToolsTests.assertFalse((boolean)BitTools.onlyFlagIsSet((int)3, (int)1));
        BitToolsTests.assertTrue((boolean)BitTools.onlyFlagIsSet((int)1, (int)1));
        BitToolsTests.assertFalse((boolean)BitTools.onlyFlagIsSet((int)771, (int)1));
        BitToolsTests.assertTrue((boolean)BitTools.onlyFlagIsSet((int)1, (int)1));
        BitToolsTests.assertFalse((boolean)BitTools.onlyFlagIsSet((int)771, (int)257));
        BitToolsTests.assertTrue((boolean)BitTools.onlyFlagIsSet((int)257, (int)257));
        BitToolsTests.assertFalse((boolean)BitTools.onlyFlagIsSet((int)771, (int)259));
        BitToolsTests.assertTrue((boolean)BitTools.onlyFlagIsSet((int)259, (int)259));
        BitToolsTests.assertFalse((boolean)BitTools.onlyFlagIsSet((int)771, (int)4355));
        BitToolsTests.assertTrue((boolean)BitTools.onlyFlagIsSet((int)4355, (int)4355));
        BitToolsTests.assertFalse((boolean)BitTools.onlyFlagIsSet((int)0, (int)4355));
        BitToolsTests.assertTrue((boolean)BitTools.onlyFlagIsSet((int)259, (int)259));
    }

    public void testOnlyFlagIsOffIntInt() {
        BitToolsTests.assertFalse((boolean)BitTools.onlyFlagIsOff((int)3, (int)1));
        BitToolsTests.assertFalse((boolean)BitTools.onlyFlagIsOff((int)771, (int)1));
        BitToolsTests.assertTrue((boolean)BitTools.onlyFlagIsOff((int)-2, (int)1));
        BitToolsTests.assertFalse((boolean)BitTools.onlyFlagIsOff((int)771, (int)257));
        BitToolsTests.assertTrue((boolean)BitTools.onlyFlagIsOff((int)-258, (int)257));
        BitToolsTests.assertFalse((boolean)BitTools.onlyFlagIsOff((int)771, (int)259));
        BitToolsTests.assertTrue((boolean)BitTools.onlyFlagIsOff((int)-260, (int)259));
        BitToolsTests.assertFalse((boolean)BitTools.onlyFlagIsOff((int)771, (int)4355));
        BitToolsTests.assertTrue((boolean)BitTools.onlyFlagIsOff((int)-4356, (int)4355));
    }

    public void testAllFlagsAreSetIntInt() {
        BitToolsTests.assertTrue((boolean)BitTools.allFlagsAreSet((int)3, (int)1));
        BitToolsTests.assertTrue((boolean)BitTools.allFlagsAreSet((int)771, (int)1));
        BitToolsTests.assertTrue((boolean)BitTools.allFlagsAreSet((int)771, (int)257));
        BitToolsTests.assertTrue((boolean)BitTools.allFlagsAreSet((int)771, (int)259));
        BitToolsTests.assertFalse((boolean)BitTools.allFlagsAreSet((int)771, (int)4355));
        BitToolsTests.assertFalse((boolean)BitTools.allFlagsAreSet((int)0, (int)4355));
    }

    public void testSetAllFlagsIntInt() {
        BitToolsTests.assertEquals((int)3, (int)BitTools.setAllFlags((int)3, (int)1));
        BitToolsTests.assertEquals((int)4867, (int)BitTools.setAllFlags((int)771, (int)4355));
        BitToolsTests.assertEquals((int)4355, (int)BitTools.setAllFlags((int)0, (int)4355));
    }

    public void testAllFlagsAreOffIntInt() {
        BitToolsTests.assertFalse((boolean)BitTools.allFlagsAreOff((int)3, (int)1));
        BitToolsTests.assertFalse((boolean)BitTools.allFlagsAreOff((int)771, (int)1));
        BitToolsTests.assertFalse((boolean)BitTools.allFlagsAreOff((int)771, (int)257));
        BitToolsTests.assertFalse((boolean)BitTools.allFlagsAreOff((int)771, (int)259));
        BitToolsTests.assertTrue((boolean)BitTools.allFlagsAreOff((int)8708, (int)4355));
        BitToolsTests.assertTrue((boolean)BitTools.allFlagsAreOff((int)0, (int)4355));
    }

    public void testClearAllFlagsIntInt() {
        BitToolsTests.assertEquals((int)2, (int)BitTools.clearAllFlags((int)3, (int)1));
        BitToolsTests.assertEquals((int)512, (int)BitTools.clearAllFlags((int)771, (int)4355));
        BitToolsTests.assertEquals((int)0, (int)BitTools.clearAllFlags((int)0, (int)4355));
    }

    public void testOnlyFlagsAreSetIntInt() {
        BitToolsTests.assertFalse((boolean)BitTools.onlyFlagsAreSet((int)3, (int)1));
        BitToolsTests.assertTrue((boolean)BitTools.onlyFlagsAreSet((int)1, (int)1));
        BitToolsTests.assertFalse((boolean)BitTools.onlyFlagsAreSet((int)771, (int)1));
        BitToolsTests.assertTrue((boolean)BitTools.onlyFlagsAreSet((int)1, (int)1));
        BitToolsTests.assertFalse((boolean)BitTools.onlyFlagsAreSet((int)771, (int)257));
        BitToolsTests.assertTrue((boolean)BitTools.onlyFlagsAreSet((int)257, (int)257));
        BitToolsTests.assertFalse((boolean)BitTools.onlyFlagsAreSet((int)771, (int)259));
        BitToolsTests.assertTrue((boolean)BitTools.onlyFlagsAreSet((int)259, (int)259));
        BitToolsTests.assertFalse((boolean)BitTools.onlyFlagsAreSet((int)771, (int)4355));
        BitToolsTests.assertTrue((boolean)BitTools.onlyFlagsAreSet((int)4355, (int)4355));
        BitToolsTests.assertFalse((boolean)BitTools.onlyFlagsAreSet((int)0, (int)4355));
        BitToolsTests.assertTrue((boolean)BitTools.onlyFlagsAreSet((int)259, (int)259));
    }

    public void testOnlyFlagsAreOffIntInt() {
        BitToolsTests.assertFalse((boolean)BitTools.onlyFlagsAreOff((int)3, (int)1));
        BitToolsTests.assertFalse((boolean)BitTools.onlyFlagsAreOff((int)771, (int)1));
        BitToolsTests.assertTrue((boolean)BitTools.onlyFlagsAreOff((int)-2, (int)1));
        BitToolsTests.assertFalse((boolean)BitTools.onlyFlagsAreOff((int)771, (int)257));
        BitToolsTests.assertTrue((boolean)BitTools.onlyFlagsAreOff((int)-258, (int)257));
        BitToolsTests.assertFalse((boolean)BitTools.onlyFlagsAreOff((int)771, (int)259));
        BitToolsTests.assertTrue((boolean)BitTools.onlyFlagsAreOff((int)-260, (int)259));
        BitToolsTests.assertFalse((boolean)BitTools.onlyFlagsAreOff((int)771, (int)4355));
        BitToolsTests.assertTrue((boolean)BitTools.onlyFlagsAreOff((int)-4356, (int)4355));
    }

    public void testAnyFlagsAreSetIntInt() {
        BitToolsTests.assertTrue((boolean)BitTools.anyFlagsAreSet((int)3, (int)1));
        BitToolsTests.assertTrue((boolean)BitTools.anyFlagsAreSet((int)65535, (int)1));
        BitToolsTests.assertTrue((boolean)BitTools.anyFlagsAreSet((int)3, (int)65535));
        BitToolsTests.assertFalse((boolean)BitTools.anyFlagsAreSet((int)771, (int)4112));
        BitToolsTests.assertFalse((boolean)BitTools.anyFlagsAreSet((int)0, (int)65535));
    }

    public void testAnyFlagsAreOffIntInt() {
        BitToolsTests.assertTrue((boolean)BitTools.anyFlagsAreOff((int)13118, (int)1));
        BitToolsTests.assertTrue((boolean)BitTools.anyFlagsAreOff((int)65534, (int)1));
        BitToolsTests.assertTrue((boolean)BitTools.anyFlagsAreOff((int)3, (int)65535));
        BitToolsTests.assertFalse((boolean)BitTools.anyFlagsAreOff((int)29555, (int)4112));
        BitToolsTests.assertFalse((boolean)BitTools.anyFlagsAreOff((int)65535, (int)65535));
    }

    public void testAllFlagsAreSetIntIntArray() {
        BitToolsTests.assertTrue((boolean)BitTools.allFlagsAreSet((int)3, (int[])new int[]{1}));
        BitToolsTests.assertTrue((boolean)BitTools.allFlagsAreSet((int)771, (int[])new int[]{1}));
        BitToolsTests.assertTrue((boolean)BitTools.allFlagsAreSet((int)771, (int[])new int[]{256, 1}));
        BitToolsTests.assertTrue((boolean)BitTools.allFlagsAreSet((int)771, (int[])new int[]{256, 2, 1}));
        BitToolsTests.assertFalse((boolean)BitTools.allFlagsAreSet((int)771, (int[])new int[]{4096, 256, 2, 1}));
        BitToolsTests.assertFalse((boolean)BitTools.allFlagsAreSet((int)0, (int[])new int[]{4096, 256, 2, 1}));
    }

    public void testSetAllFlagsIntIntArray() {
        BitToolsTests.assertEquals((int)3, (int)BitTools.setAllFlags((int)3, (int[])new int[]{1}));
        BitToolsTests.assertEquals((int)4867, (int)BitTools.setAllFlags((int)771, (int[])new int[]{3, 4352}));
        BitToolsTests.assertEquals((int)4355, (int)BitTools.setAllFlags((int)0, (int[])new int[]{3, 4352}));
    }

    public void testAllFlagsAreOffIntIntArray() {
        BitToolsTests.assertFalse((boolean)BitTools.allFlagsAreOff((int)3, (int[])new int[]{1}));
        BitToolsTests.assertFalse((boolean)BitTools.allFlagsAreOff((int)771, (int[])new int[]{1}));
        BitToolsTests.assertFalse((boolean)BitTools.allFlagsAreOff((int)771, (int[])new int[]{256, 1}));
        BitToolsTests.assertFalse((boolean)BitTools.allFlagsAreOff((int)771, (int[])new int[]{256, 2, 1}));
        int[] nArray = new int[4];
        nArray[0] = 4096;
        nArray[1] = 1024;
        nArray[2] = 32;
        BitToolsTests.assertTrue((boolean)BitTools.allFlagsAreOff((int)771, (int[])nArray));
        BitToolsTests.assertTrue((boolean)BitTools.allFlagsAreOff((int)0, (int[])new int[]{4096, 256, 2, 1}));
    }

    public void testClearAllFlagsIntIntArray() {
        BitToolsTests.assertEquals((int)2, (int)BitTools.clearAllFlags((int)3, (int[])new int[]{1}));
        BitToolsTests.assertEquals((int)512, (int)BitTools.clearAllFlags((int)771, (int[])new int[]{3, 4352}));
        BitToolsTests.assertEquals((int)0, (int)BitTools.clearAllFlags((int)0, (int[])new int[]{3, 4352}));
    }

    public void testOnlyFlagsAreSetIntIntArray() {
        int[] nArray = new int[4];
        nArray[0] = 1;
        nArray[3] = 1;
        BitToolsTests.assertFalse((boolean)BitTools.onlyFlagsAreSet((int)3, (int[])nArray));
        int[] nArray2 = new int[4];
        nArray2[0] = 1;
        nArray2[3] = 1;
        BitToolsTests.assertTrue((boolean)BitTools.onlyFlagsAreSet((int)1, (int[])nArray2));
        int[] nArray3 = new int[4];
        nArray3[0] = 1;
        nArray3[3] = 1;
        BitToolsTests.assertFalse((boolean)BitTools.onlyFlagsAreSet((int)771, (int[])nArray3));
        int[] nArray4 = new int[4];
        nArray4[0] = 1;
        nArray4[3] = 1;
        BitToolsTests.assertTrue((boolean)BitTools.onlyFlagsAreSet((int)1, (int[])nArray4));
        int[] nArray5 = new int[4];
        nArray5[0] = 1;
        nArray5[1] = 256;
        nArray5[3] = 1;
        BitToolsTests.assertFalse((boolean)BitTools.onlyFlagsAreSet((int)771, (int[])nArray5));
        int[] nArray6 = new int[4];
        nArray6[0] = 1;
        nArray6[1] = 256;
        nArray6[3] = 1;
        BitToolsTests.assertTrue((boolean)BitTools.onlyFlagsAreSet((int)257, (int[])nArray6));
        BitToolsTests.assertFalse((boolean)BitTools.onlyFlagsAreSet((int)771, (int[])new int[]{1, 256, 2, 1}));
        BitToolsTests.assertTrue((boolean)BitTools.onlyFlagsAreSet((int)259, (int[])new int[]{1, 256, 2, 1}));
        BitToolsTests.assertFalse((boolean)BitTools.onlyFlagsAreSet((int)771, (int[])new int[]{17, 256, 2, 1}));
        BitToolsTests.assertTrue((boolean)BitTools.onlyFlagsAreSet((int)4355, (int[])new int[]{4352, 256, 2, 1}));
        BitToolsTests.assertFalse((boolean)BitTools.onlyFlagsAreSet((int)0, (int[])new int[]{17, 256, 2, 1}));
        BitToolsTests.assertTrue((boolean)BitTools.onlyFlagsAreSet((int)259, (int[])new int[]{257, 256, 2, 1}));
    }

    public void testOnlyFlagsAreOffIntIntArray() {
        int[] nArray = new int[4];
        nArray[0] = 1;
        nArray[3] = 1;
        BitToolsTests.assertFalse((boolean)BitTools.onlyFlagsAreOff((int)3, (int[])nArray));
        int[] nArray2 = new int[4];
        nArray2[0] = 1;
        nArray2[3] = 1;
        BitToolsTests.assertFalse((boolean)BitTools.onlyFlagsAreOff((int)771, (int[])nArray2));
        int[] nArray3 = new int[4];
        nArray3[0] = 1;
        nArray3[3] = 1;
        BitToolsTests.assertTrue((boolean)BitTools.onlyFlagsAreOff((int)-2, (int[])nArray3));
        int[] nArray4 = new int[4];
        nArray4[0] = 1;
        nArray4[1] = 256;
        nArray4[3] = 1;
        BitToolsTests.assertFalse((boolean)BitTools.onlyFlagsAreOff((int)771, (int[])nArray4));
        int[] nArray5 = new int[4];
        nArray5[0] = 1;
        nArray5[1] = 256;
        nArray5[3] = 1;
        BitToolsTests.assertTrue((boolean)BitTools.onlyFlagsAreOff((int)-258, (int[])nArray5));
        BitToolsTests.assertFalse((boolean)BitTools.onlyFlagsAreOff((int)771, (int[])new int[]{1, 256, 2, 1}));
        BitToolsTests.assertTrue((boolean)BitTools.onlyFlagsAreOff((int)-260, (int[])new int[]{1, 256, 2, 1}));
        BitToolsTests.assertFalse((boolean)BitTools.onlyFlagsAreOff((int)771, (int[])new int[]{4352, 256, 2, 1}));
        BitToolsTests.assertTrue((boolean)BitTools.onlyFlagsAreOff((int)-4356, (int[])new int[]{4352, 256, 2, 1}));
    }

    public void testAnyFlagsAreSetIntIntArray() {
        BitToolsTests.assertTrue((boolean)BitTools.anyFlagsAreSet((int)3, (int[])new int[]{1}));
        BitToolsTests.assertTrue((boolean)BitTools.anyFlagsAreSet((int)65535, (int[])new int[]{1}));
        BitToolsTests.assertTrue((boolean)BitTools.anyFlagsAreSet((int)771, (int[])new int[]{61440, 3840, 240, 15}));
        BitToolsTests.assertFalse((boolean)BitTools.anyFlagsAreSet((int)771, (int[])new int[]{4096, 16}));
        BitToolsTests.assertFalse((boolean)BitTools.anyFlagsAreSet((int)0, (int[])new int[]{61440, 3840, 240, 15}));
    }

    public void testAnyFlagsAreOffIntIntArray() {
        BitToolsTests.assertFalse((boolean)BitTools.anyFlagsAreOff((int)3, (int[])new int[]{1}));
        BitToolsTests.assertFalse((boolean)BitTools.anyFlagsAreOff((int)65535, (int[])new int[]{1}));
        BitToolsTests.assertFalse((boolean)BitTools.anyFlagsAreOff((int)771, (int[])new int[]{256, 512, 3, 2}));
        BitToolsTests.assertTrue((boolean)BitTools.anyFlagsAreOff((int)771, (int[])new int[]{256, 16}));
        BitToolsTests.assertTrue((boolean)BitTools.anyFlagsAreOff((int)0, (int[])new int[]{61440, 3840, 240, 15}));
    }

    public void testOrFlags() {
        int[] nArray = new int[2];
        nArray[0] = 1;
        BitToolsTests.assertEquals((int)1, (int)BitTools.orFlags((int[])nArray));
        BitToolsTests.assertEquals((int)17, (int)BitTools.orFlags((int[])new int[]{1, 17}));
        BitToolsTests.assertEquals((int)61457, (int)BitTools.orFlags((int[])new int[]{1, 17, 61440}));
    }

    public void testAndFlags() {
        BitToolsTests.assertEquals((int)1, (int)BitTools.andFlags((int[])new int[]{1, 1}));
        BitToolsTests.assertEquals((int)1, (int)BitTools.andFlags((int[])new int[]{1, 17}));
        BitToolsTests.assertEquals((int)0, (int)BitTools.andFlags((int[])new int[]{1, 17, 61440}));
        BitToolsTests.assertEquals((int)1, (int)BitTools.andFlags((int[])new int[]{1, 17, 61441}));
    }

    public void testXorFlags() {
        int[] nArray = new int[2];
        nArray[0] = 1;
        BitToolsTests.assertEquals((int)1, (int)BitTools.xorFlags((int[])nArray));
        BitToolsTests.assertEquals((int)16, (int)BitTools.xorFlags((int[])new int[]{1, 17}));
        BitToolsTests.assertEquals((int)61456, (int)BitTools.xorFlags((int[])new int[]{1, 17, 61440}));
        BitToolsTests.assertEquals((int)65297, (int)BitTools.xorFlags((int[])new int[]{1, 17, 61440, 3841}));
        BitToolsTests.assertEquals((int)61456, (int)BitTools.xorFlags((int[])new int[]{1, 17, 61440, 3841, 3841}));
    }

    public void testIsEven() {
        BitToolsTests.assertTrue((boolean)BitTools.isEven((int)-22));
        BitToolsTests.assertTrue((boolean)BitTools.isEven((int)0));
        BitToolsTests.assertTrue((boolean)BitTools.isEven((int)22));
        BitToolsTests.assertFalse((boolean)BitTools.isEven((int)-21));
        BitToolsTests.assertFalse((boolean)BitTools.isEven((int)21));
    }

    public void testIsOdd() {
        BitToolsTests.assertFalse((boolean)BitTools.isOdd((int)-22));
        BitToolsTests.assertFalse((boolean)BitTools.isOdd((int)0));
        BitToolsTests.assertFalse((boolean)BitTools.isOdd((int)22));
        BitToolsTests.assertTrue((boolean)BitTools.isOdd((int)-21));
        BitToolsTests.assertTrue((boolean)BitTools.isOdd((int)21));
    }

    public void testHalf() {
        BitToolsTests.assertEquals((int)-11, (int)BitTools.half((int)-22));
        BitToolsTests.assertEquals((int)0, (int)BitTools.half((int)0));
        BitToolsTests.assertEquals((int)11, (int)BitTools.half((int)22));
        BitToolsTests.assertEquals((int)-11, (int)BitTools.half((int)-21));
        BitToolsTests.assertEquals((int)10, (int)BitTools.half((int)21));
    }

    public void testTwice() {
        BitToolsTests.assertEquals((int)-22, (int)BitTools.twice((int)-11));
        BitToolsTests.assertEquals((int)0, (int)BitTools.twice((int)0));
        BitToolsTests.assertEquals((int)22, (int)BitTools.twice((int)11));
    }

    public void testConstructor() {
        boolean exCaught;
        block2: {
            exCaught = false;
            try {
                Object at = ClassTools.newInstance(BitTools.class);
                BitToolsTests.fail((String)("bogus: " + at));
            }
            catch (RuntimeException ex) {
                if (!(ex.getCause() instanceof InvocationTargetException) || !(ex.getCause().getCause() instanceof UnsupportedOperationException)) break block2;
                exCaught = true;
            }
        }
        BitToolsTests.assertTrue((boolean)exCaught);
    }
}

