/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.tests.collection;

import org.eclipse.persistence.tools.utility.collection.ArrayQueue;
import org.eclipse.persistence.tools.utility.collection.Queue;
import org.eclipse.persistence.tools.utility.tests.collection.QueueTests;

public class ArrayQueueTests
extends QueueTests {
    public ArrayQueueTests(String name) {
        super(name);
    }

    @Override
    Queue<String> buildQueue() {
        return new ArrayQueue();
    }

    public void testWrappedElements() {
        Queue<String> queue = this.buildQueue();
        ArrayQueueTests.assertTrue((boolean)queue.isEmpty());
        queue.enqueue((Object)"first");
        ArrayQueueTests.assertFalse((boolean)queue.isEmpty());
        queue.enqueue((Object)"second");
        ArrayQueueTests.assertFalse((boolean)queue.isEmpty());
        queue.enqueue((Object)"third");
        queue.enqueue((Object)"fourth");
        queue.enqueue((Object)"fifth");
        queue.enqueue((Object)"sixth");
        ArrayQueueTests.assertEquals((String)"first", (String)((String)queue.dequeue()));
        ArrayQueueTests.assertFalse((boolean)queue.isEmpty());
        ArrayQueueTests.assertEquals((String)"second", (String)((String)queue.dequeue()));
        ArrayQueueTests.assertFalse((boolean)queue.isEmpty());
        ArrayQueueTests.assertEquals((String)"third", (String)((String)queue.dequeue()));
        queue.enqueue((Object)"seventh");
        queue.enqueue((Object)"eighth");
        queue.enqueue((Object)"ninth");
        queue.enqueue((Object)"tenth");
        queue.enqueue((Object)"eleventh");
        queue.enqueue((Object)"twelfth");
        ArrayQueueTests.assertEquals((String)"fourth", (String)((String)queue.dequeue()));
        ArrayQueueTests.assertEquals((String)"fifth", (String)((String)queue.dequeue()));
        ArrayQueueTests.assertEquals((String)"sixth", (String)((String)queue.dequeue()));
        ArrayQueueTests.assertEquals((String)"seventh", (String)((String)queue.dequeue()));
        ArrayQueueTests.assertEquals((String)"eighth", (String)((String)queue.dequeue()));
        ArrayQueueTests.assertEquals((String)"ninth", (String)((String)queue.dequeue()));
        ArrayQueueTests.assertEquals((String)"tenth", (String)((String)queue.dequeue()));
        ArrayQueueTests.assertEquals((String)"eleventh", (String)((String)queue.dequeue()));
        ArrayQueueTests.assertEquals((String)"twelfth", (String)((String)queue.dequeue()));
        ArrayQueueTests.assertTrue((boolean)queue.isEmpty());
    }

    public void testArrayCapacityExceeded() {
        Queue<String> queue = this.buildQueue();
        ArrayQueueTests.assertTrue((boolean)queue.isEmpty());
        queue.enqueue((Object)"first");
        ArrayQueueTests.assertFalse((boolean)queue.isEmpty());
        queue.enqueue((Object)"second");
        ArrayQueueTests.assertFalse((boolean)queue.isEmpty());
        queue.enqueue((Object)"third");
        queue.enqueue((Object)"fourth");
        queue.enqueue((Object)"fifth");
        queue.enqueue((Object)"sixth");
        queue.enqueue((Object)"seventh");
        queue.enqueue((Object)"eighth");
        queue.enqueue((Object)"ninth");
        queue.enqueue((Object)"tenth");
        queue.enqueue((Object)"eleventh");
        queue.enqueue((Object)"twelfth");
        ArrayQueueTests.assertEquals((String)"first", (String)((String)queue.dequeue()));
        ArrayQueueTests.assertFalse((boolean)queue.isEmpty());
        ArrayQueueTests.assertEquals((String)"second", (String)((String)queue.dequeue()));
        ArrayQueueTests.assertFalse((boolean)queue.isEmpty());
        ArrayQueueTests.assertEquals((String)"third", (String)((String)queue.dequeue()));
        ArrayQueueTests.assertEquals((String)"fourth", (String)((String)queue.dequeue()));
        ArrayQueueTests.assertEquals((String)"fifth", (String)((String)queue.dequeue()));
        ArrayQueueTests.assertEquals((String)"sixth", (String)((String)queue.dequeue()));
        ArrayQueueTests.assertEquals((String)"seventh", (String)((String)queue.dequeue()));
        ArrayQueueTests.assertEquals((String)"eighth", (String)((String)queue.dequeue()));
        ArrayQueueTests.assertEquals((String)"ninth", (String)((String)queue.dequeue()));
        ArrayQueueTests.assertEquals((String)"tenth", (String)((String)queue.dequeue()));
        ArrayQueueTests.assertEquals((String)"eleventh", (String)((String)queue.dequeue()));
        ArrayQueueTests.assertEquals((String)"twelfth", (String)((String)queue.dequeue()));
        ArrayQueueTests.assertTrue((boolean)queue.isEmpty());
    }

    public void testArrayCapacityExceededWithWrappedElements() {
        Queue<String> queue = this.buildQueue();
        ArrayQueueTests.assertTrue((boolean)queue.isEmpty());
        queue.enqueue((Object)"first");
        ArrayQueueTests.assertFalse((boolean)queue.isEmpty());
        queue.enqueue((Object)"second");
        ArrayQueueTests.assertFalse((boolean)queue.isEmpty());
        queue.enqueue((Object)"third");
        queue.enqueue((Object)"fourth");
        queue.enqueue((Object)"fifth");
        queue.enqueue((Object)"sixth");
        ArrayQueueTests.assertEquals((String)"first", (String)((String)queue.dequeue()));
        ArrayQueueTests.assertFalse((boolean)queue.isEmpty());
        ArrayQueueTests.assertEquals((String)"second", (String)((String)queue.dequeue()));
        ArrayQueueTests.assertFalse((boolean)queue.isEmpty());
        ArrayQueueTests.assertEquals((String)"third", (String)((String)queue.dequeue()));
        queue.enqueue((Object)"seventh");
        queue.enqueue((Object)"eighth");
        queue.enqueue((Object)"ninth");
        queue.enqueue((Object)"tenth");
        queue.enqueue((Object)"eleventh");
        queue.enqueue((Object)"twelfth");
        queue.enqueue((Object)"thirteenth");
        queue.enqueue((Object)"fourteenth");
        queue.enqueue((Object)"fifteenth");
        ArrayQueueTests.assertEquals((String)"fourth", (String)((String)queue.dequeue()));
        ArrayQueueTests.assertEquals((String)"fifth", (String)((String)queue.dequeue()));
        ArrayQueueTests.assertEquals((String)"sixth", (String)((String)queue.dequeue()));
        ArrayQueueTests.assertEquals((String)"seventh", (String)((String)queue.dequeue()));
        ArrayQueueTests.assertEquals((String)"eighth", (String)((String)queue.dequeue()));
        ArrayQueueTests.assertEquals((String)"ninth", (String)((String)queue.dequeue()));
        ArrayQueueTests.assertEquals((String)"tenth", (String)((String)queue.dequeue()));
        ArrayQueueTests.assertEquals((String)"eleventh", (String)((String)queue.dequeue()));
        ArrayQueueTests.assertEquals((String)"twelfth", (String)((String)queue.dequeue()));
        ArrayQueueTests.assertEquals((String)"thirteenth", (String)((String)queue.dequeue()));
        ArrayQueueTests.assertEquals((String)"fourteenth", (String)((String)queue.dequeue()));
        ArrayQueueTests.assertEquals((String)"fifteenth", (String)((String)queue.dequeue()));
        ArrayQueueTests.assertTrue((boolean)queue.isEmpty());
    }
}

