/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.tests.command;

import org.eclipse.persistence.tools.utility.command.Command;
import org.eclipse.persistence.tools.utility.command.CommandExecutor;
import org.eclipse.persistence.tools.utility.command.ExtendedCommandExecutor;
import org.eclipse.persistence.tools.utility.command.ThreadLocalExtendedCommandExecutor;
import org.eclipse.persistence.tools.utility.tests.MultiThreadedTestCase;
import org.eclipse.persistence.tools.utility.tests.TestTools;

public class CommandExecutorTests
extends MultiThreadedTestCase {
    public CommandExecutorTests(String name) {
        super(name);
    }

    public void testDefaultCommandExecutor_toString() throws Exception {
        CommandExecutor commandExecutor = CommandExecutor.Default.instance();
        CommandExecutorTests.assertNotNull((Object)commandExecutor.toString());
    }

    public void testDefaultCommandExecutor_serialization() throws Exception {
        CommandExecutor commandExecutor1 = CommandExecutor.Default.instance();
        CommandExecutor commandExecutor2 = TestTools.serialize(commandExecutor1);
        CommandExecutorTests.assertSame((Object)commandExecutor1, (Object)commandExecutor2);
    }

    public void testDefaultCommandExecutor() {
        TestCommand testCommand = new TestCommand();
        CommandExecutorTests.assertEquals((int)0, (int)testCommand.count);
        CommandExecutor commandExecutor = CommandExecutor.Default.instance();
        commandExecutor.execute((Command)testCommand);
        CommandExecutorTests.assertEquals((int)1, (int)testCommand.count);
    }

    public void testThreadLocalCommandExecutor_toString() throws Exception {
        ThreadLocalExtendedCommandExecutor commandExecutor = new ThreadLocalExtendedCommandExecutor();
        CommandExecutorTests.assertNotNull((Object)commandExecutor.toString());
    }

    public void testThreadLocalCommandExecutor() throws Exception {
        ThreadLocalExtendedCommandExecutor threadLocalCommandExecutor = new ThreadLocalExtendedCommandExecutor();
        TestRunnable testRunnable1 = new TestRunnable(threadLocalCommandExecutor, 1);
        Thread thread1 = this.buildThread(testRunnable1);
        thread1.run();
        TestRunnable testRunnable2 = new TestRunnable(threadLocalCommandExecutor, 2);
        Thread thread2 = this.buildThread(testRunnable2);
        thread2.run();
        TestRunnable testRunnable3 = new TestRunnable(threadLocalCommandExecutor, 3, null);
        Thread thread3 = this.buildThread(testRunnable3);
        thread3.run();
        thread1.join();
        thread2.join();
        thread3.join();
        CommandExecutorTests.assertEquals((int)1, (int)testRunnable1.testCommand.count);
        CommandExecutorTests.assertEquals((int)1, (int)testRunnable1.testCommandExecutor.count);
        CommandExecutorTests.assertEquals((int)2, (int)testRunnable2.testCommand.count);
        CommandExecutorTests.assertEquals((int)2, (int)testRunnable2.testCommandExecutor.count);
        CommandExecutorTests.assertEquals((int)3, (int)testRunnable3.testCommand.count);
        CommandExecutorTests.assertNull((Object)testRunnable3.testCommandExecutor);
    }

    static class TestCommand
    implements Command {
        int count = 0;

        TestCommand() {
        }

        public void execute() {
            ++this.count;
        }
    }

    static class TestCommandExecutor
    implements ExtendedCommandExecutor {
        int count = 0;

        TestCommandExecutor() {
        }

        public void execute(Command command) {
            ++this.count;
            command.execute();
        }

        public void waitToExecute(Command command) {
            this.execute(command);
        }

        public boolean waitToExecute(Command command, long timeout) {
            this.execute(command);
            return true;
        }
    }

    static class TestRunnable
    implements Runnable {
        final ThreadLocalExtendedCommandExecutor threadLocalCommandExecutor;
        final int executionCount;
        final TestCommand testCommand = new TestCommand();
        final TestCommandExecutor testCommandExecutor;

        TestRunnable(ThreadLocalExtendedCommandExecutor threadLocalCommandExecutor, int executionCount) {
            this(threadLocalCommandExecutor, executionCount, new TestCommandExecutor());
        }

        TestRunnable(ThreadLocalExtendedCommandExecutor threadLocalCommandExecutor, int executionCount, TestCommandExecutor testCommandExecutor) {
            this.threadLocalCommandExecutor = threadLocalCommandExecutor;
            this.executionCount = executionCount;
            this.testCommandExecutor = testCommandExecutor;
        }

        @Override
        public void run() {
            this.threadLocalCommandExecutor.set((CommandExecutor)this.testCommandExecutor);
            int i = 0;
            while (i < this.executionCount) {
                this.threadLocalCommandExecutor.execute((Command)this.testCommand);
                ++i;
            }
        }
    }
}

