/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.tests.io;

import java.io.IOException;
import java.io.Reader;
import junit.framework.TestCase;
import org.eclipse.persistence.tools.utility.io.InvalidReader;
import org.eclipse.persistence.tools.utility.tests.TestTools;

public class InvalidReaderTests
extends TestCase {
    private Reader invalidReader;

    public InvalidReaderTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.invalidReader = InvalidReader.instance();
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    public void testClose() throws IOException {
        this.invalidReader.close();
    }

    public void testMark() {
        boolean exCaught = false;
        try {
            this.invalidReader.mark(100);
        }
        catch (IOException iOException) {
            exCaught = true;
        }
        InvalidReaderTests.assertTrue((boolean)exCaught);
    }

    public void testMarkSupported() {
        InvalidReaderTests.assertFalse((boolean)this.invalidReader.markSupported());
    }

    public void testRead() throws IOException {
        boolean exCaught = false;
        try {
            this.invalidReader.read();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            exCaught = true;
        }
        InvalidReaderTests.assertTrue((boolean)exCaught);
    }

    public void testReadCharArray() throws IOException {
        char[] cbuf = new char[10];
        boolean exCaught = false;
        try {
            this.invalidReader.read(cbuf);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            exCaught = true;
        }
        InvalidReaderTests.assertTrue((boolean)exCaught);
    }

    public void testReadCharArrayIntInt() throws IOException {
        char[] cbuf = new char[10];
        boolean exCaught = false;
        try {
            this.invalidReader.read(cbuf, 3, 2);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            exCaught = true;
        }
        InvalidReaderTests.assertTrue((boolean)exCaught);
    }

    public void testReady() throws IOException {
        InvalidReaderTests.assertFalse((boolean)this.invalidReader.ready());
    }

    public void testReset() {
        boolean exCaught = false;
        try {
            this.invalidReader.reset();
        }
        catch (IOException iOException) {
            exCaught = true;
        }
        InvalidReaderTests.assertTrue((boolean)exCaught);
    }

    public void testSkip() throws IOException {
        boolean exCaught = false;
        try {
            this.invalidReader.skip(44L);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            exCaught = true;
        }
        InvalidReaderTests.assertTrue((boolean)exCaught);
    }
}

